/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.testprogramme;

import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Testprogramm, um festzustellen, ob die Threadnummern hochgezählt werden, auch
 * wenn die vorherigen Threads beendet wurden.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public class ThreadCountTest {

	/**
	 * Debug-Logger.
	 */
	private static final Debug DEBUG = Debug.getLogger();

	/**
	 * Runnable für einen Thread, der eine bestimmte Zeit läuft und sich dann
	 * beendet.
	 *
	 * @author uhlmann
	 *
	 */
	static class DummyThread implements Runnable {

		@Override
		public void run() {
			// final Random random = new Random();
			final int sleeptime = 1; // random.nextInt(20) + 1;
			ThreadCountTest.DEBUG.warning("Thread begins, sleep time is " + sleeptime + " sec.",
					Thread.currentThread().getName());
			try {
				Thread.sleep(1000 * sleeptime);
			} catch (final InterruptedException e) {
				ThreadCountTest.DEBUG.warning("Oops", e);
			}
			ThreadCountTest.DEBUG.warning("Thread exits", Thread.currentThread().getName());
		}

	}

	/**
	 * Erzeugt jede Sekunde einen neuen Thread.
	 */
	public void doThreads() {
		while (true) {
			try {
				Thread.sleep(2000);
			} catch (final InterruptedException e) {
				ThreadCountTest.DEBUG.warning("Oops", e);
			}
			final Thread t = new Thread(new DummyThread());
			t.start();
		}
	}

	/**
	 * Einsprungpunkt.
	 *
	 * @param args
	 *            Kommandozeilenargumente, unbenutzt.
	 */
	public static void main(final String[] args) {
		final ThreadCountTest app = new ThreadCountTest();
		app.doThreads();
	}
}
