/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import de.bsvrz.buv.plugin.param.editors.ParameterSaver.ParameterSaveUrsache;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.daten.DataWithTime;

/**
 * Behandelt das Abspeichern der Originaldaten auf allen selektierten Objekten.
 *
 * Die Klasse ist absichtlich package-privat, damit sie nur hier verwendet wird,
 * aber sie nicht als innere Klasse den {@link MehrereParameterKopierenViewer}
 * aufbläht.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
class MehrereParameterKopierenButtonSelectionAdapter extends AbstractParameterKopierenButtonSelectionAdapter {

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param viewer
	 *            der Viewer, an dessen "Kopieren"- Button wir angeschlossen sind.
	 */
	public MehrereParameterKopierenButtonSelectionAdapter(final AbstractParameterKopierenViewer viewer) {
		super(viewer);
	}

	@Override
	protected void handleWidgetSelectedSafe(final ISelection s, final Parameter[] input,
			final short selectedSimulationsVariante) {
		final IStructuredSelection selection = (IStructuredSelection) s;
		final List<Parameter> parameters = new ArrayList<>(input.length);
		final Iterator<?> iterator = selection.iterator();
		int loop = 0;
		while (iterator.hasNext()) {
			final Object next = iterator.next();
			if (next instanceof Parameter) {
				final Parameter p = (Parameter) next;
				final ParameterInfo info = new ParameterInfo(p.getObjekt(), p.getTyp(), p.getAtg(),
						selectedSimulationsVariante);
				final DataWithTime dataWithTime = p.getDataWithTime();
				parameters.add(new Parameter(info,
						new DataWithTime(dataWithTime.getData().createModifiableCopy(), dataWithTime.getZeitpunkt())));
			}
			++loop;
		}
		/* HINWEIS Überschreiben vererbter Parameter abfragen! TBuV 137-16 */
		final Parameter[] editedParameters = parameters.toArray(new Parameter[parameters.size()]);
		doSaveEditedParameters(input, editedParameters);
	}

	@Override
	protected ParameterSaveUrsache getSaveUrsache() {
		return ParameterSaveUrsache.KOPIERT;
	}
}
