/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.viewer;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.Zeichenketten;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginTableLabelProvider;
import de.bsvrz.buv.plugin.param.provider.helper.MehrfachauswahlDialog;
import de.bsvrz.puk.param.lib.Parameter;

/**
 * Viewer für das Kopieren n:n.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class MehrereParameterKopierenViewer extends AbstractParameterKopierenViewer {

	/**
	 * TableViewer zur anzeige der Quellobjekte.
	 */
	private TableViewer vonTableViewer;

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param parent
	 *            Elterncontrol.
	 * @param dialogId
	 *            Dialog- oder View-Id, in der wir uns befinden.
	 * @param hilfeId
	 *            Id für den F1 Hilfecontext.
	 */
	public MehrereParameterKopierenViewer(final Composite parent, final String dialogId, final String hilfeId) {
		super(parent, dialogId, hilfeId);
	}

	@Override
	protected void fillNachGroup() {
		final GridLayout nachGroupLayout = new GridLayout(1, false);
		getNachGroup().setLayout(nachGroupLayout);
		Label l = new Label(getNachGroup(), SWT.NONE);
		l.setText("Objekte: Wie auf der VON-Seite");
		GridData gd = new GridData(SWT.FILL, SWT.CENTER, false, false);
		gd.horizontalSpan = 1;
		l.setLayoutData(gd);
		l = new Label(getNachGroup(), SWT.NONE);
		l.setText("Simulationsvariante:");
		gd = new GridData(SWT.FILL, SWT.CENTER, false, false);
		gd.horizontalSpan = 1;
		l.setLayoutData(gd);

		createSimulationsVarianteCombo();
		gd = (GridData) getNachGroup().getLayoutData();
		gd.grabExcessHorizontalSpace = false;
	}

	@Override
	protected void fillVonGroup() {
		final Table table = new Table(getVonGroup(), SWT.FULL_SELECTION | SWT.BORDER | SWT.MULTI);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		final GridData gd = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd.widthHint = 400;
		gd.heightHint = 220;
		table.setLayoutData(gd);
		final AbstractParamPluginTableLabelProvider labelProvider = new AbstractParamPluginTableLabelProvider() {

			@Override
			public String getColumnId(final int columnIndex) {
				String text = "unbekannt";
				switch (columnIndex) {
				case 0:
					text = AbstractParamPluginTableLabelProvider.COLUMNID_OBJECT_NAME;
					break;
				case 1:
					text = AbstractParamPluginTableLabelProvider.COLUMNID_SIM;
					break;
				case 2:
					text = AbstractParamPluginTableLabelProvider.COLUMNID_QUELLE;
					break;
				case 3:
					text = AbstractParamPluginTableLabelProvider.COLUMNID_QUELLTYP;
					break;
				default:
					break;
				}
				return text;
			}

			@Override
			public int getNumColumns() {
				return 4;
			}
		};
		int columnIndex;
		for (columnIndex = 0; columnIndex < labelProvider.getNumColumns(); ++columnIndex) {
			final TableColumn column = new TableColumn(table, SWT.NONE);
			final String columnId = labelProvider.getColumnId(columnIndex);
			column.setText(columnId);
			column.setWidth(labelProvider.getPreferredColumnWidth(columnId));
		}
		vonTableViewer = new TableViewer(table);
		vonTableViewer.setLabelProvider(labelProvider);
		vonTableViewer.addSelectionChangedListener(new ISelectionChangedListener() {

			@Override
			public void selectionChanged(final SelectionChangedEvent event) {
				boolean enabled = !event.getSelection().isEmpty();
				if ((((IStructuredSelection) event.getSelection()).size() > 1) && MehrfachauswahlDialog.isEnabled()) {
					final MehrfachauswahlDialog mad = new MehrfachauswahlDialog(null, getHilfeId());
					final int userResponse = mad.open();
					enabled = Window.OK == userResponse;
				}
				getKopierenButton().setEnabled(enabled);
			}
		});
		final GridData vonGroupGridData = (GridData) getVonGroup().getLayoutData();
		vonGroupGridData.grabExcessHorizontalSpace = true;
	}

	@Override
	protected SelectionListener getKopierenButtonSelectionListener() {
		return new MehrereParameterKopierenButtonSelectionAdapter(this);
	}

	@Override
	public ISelection getSelection() {
		return vonTableViewer.getSelection();
	}

	@Override
	public void refresh() {
		if (getInput() instanceof Parameter[]) {
			final Parameter[] parameters = (Parameter[]) getInput();
			final Parameter p = parameters[0];
			final IArtDesParametersatzesProvider backend = RahmenwerkService.getService()
					.getArtDesParametersatzesProvider();
			vonTableViewer.setContentProvider(getContentProvider());
			vonTableViewer.setInput(parameters);
			updateSimulationsVarianteCombo(p, backend);
			getKopierenButton().setEnabled(!getSelection().isEmpty());
		} else {
			vonTableViewer.setInput(null);
			getKopierenButton().setEnabled(false);
		}
	}

	@Override
	public void setSelection(final ISelection selection, final boolean reveal) {
		vonTableViewer.setSelection(selection, reveal);
	}

	@Override
	protected String getNachGroupLabel() {
		return "Nach";
	}

	@Override
	protected String getVonGroupLabel() {
		return "Von";
	}

	@Override
	protected String getKopierenButtonText() {
		return Zeichenketten.PLUGIN_PARAM_BUTTON_KOPIEREN;
	}

	@Override
	protected Image getKopierenButtonImage() {
		return ParamSharedImage.KOPIEREN.getImage();
	}
}
