/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

import de.bsvrz.buv.plugin.param.ModifiableParameterInfo;
import de.bsvrz.buv.plugin.param.editors.ParameterSaver.ParameterSaveUrsache;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.daten.DataWithTime;

/**
 * Behandelt das Abspeichern der Originaldaten auf allen selektierten Objekten.
 *
 * Die Klasse ist absichtlich package-privat, damit sie nur hier verwendet wird,
 * aber sie nicht als innere Klasse den {@link ParameterKopierenViewer}
 * aufbläht.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
class ParameterKopierenButtonSelectionAdapter extends AbstractParameterKopierenButtonSelectionAdapter {

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param viewer
	 *            der Viewer, an dessen "Kopieren"- Button wir angeschlossen sind.
	 */
	public ParameterKopierenButtonSelectionAdapter(final AbstractParameterKopierenViewer viewer) {
		super(viewer);
	}

	@Override
	protected void handleWidgetSelectedSafe(final ISelection s, final Parameter[] input,
			final short selectedSimulationsVariante) {
		final IStructuredSelection selection = (IStructuredSelection) s;
		final Parameter inputParameter = input[0];
		final List<Parameter> parameters = new ArrayList<>();
		final Iterator<?> iterator = selection.iterator();
		while (iterator.hasNext()) {
			final Object next = iterator.next();
			if (next instanceof SystemObject) {
				final SystemObject o = (SystemObject) next;
				final ModifiableParameterInfo mpi = new ModifiableParameterInfo();
				mpi.setObjekt(o);
				mpi.setAtg(inputParameter.getAtg());
				mpi.setSim(selectedSimulationsVariante);
				mpi.autoFillTypes();
				final ModifiableParameterInfo[] mpis = mpi.resolve();
				// HINWEIS Userabfrage, falls mpis.length > 1
				final ParameterInfo info = mpis[0].toParameterInfos()[0];
				final DataWithTime dataWithTime = inputParameter.getDataWithTime();
				parameters.add(new Parameter(info,
						new DataWithTime(dataWithTime.getData().createModifiableCopy(), dataWithTime.getZeitpunkt())));
			}
		}
		/* HINWEIS Überschreiben vererbter Parameter abfragen! TBuV 137-16 */
		final Parameter[] editedParameters = parameters.toArray(new Parameter[parameters.size()]);
		final Parameter[] inputParameters = new Parameter[] { inputParameter };
		doSaveEditedParameters(inputParameters, editedParameters);
	}

	@Override
	protected ParameterSaveUrsache getSaveUrsache() {
		return ParameterSaveUrsache.KOPIERT;
	}

}
