/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.viewer;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.Zeichenketten;

/**
 * Viewer für die Ansicht
 * {@link de.bsvrz.buv.plugin.param.views.ParameterTauschenView}. Im Prinzip wie
 * Parameter kopieren 1:n, nur wird beim Speichern eben nicht nur der Parameter
 * von links nach rechts, sondern auch der von rechts nach links übertragen.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class ParameterTauschenViewer extends ParameterKopierenViewer {

	/**
	 * Konstruktor reicht nur durch.
	 *
	 * @param parent
	 *            Elterncontrol.
	 * @param dialogId
	 *            Dialog- oder View-Id, in der wir uns befinden.
	 * @param hilfeId
	 *            Id für den F1 Hilfecontext.
	 */
	public ParameterTauschenViewer(final Composite parent, final String dialogId, final String hilfeId) {
		super(parent, dialogId, hilfeId);
	}

	@Override
	protected SelectionListener getKopierenButtonSelectionListener() {
		return new ParameterTauschenButtonSelectionAdapter(this);
	}

	@Override
	protected String getNachGroupLabel() {
		return "Rechts";
	}

	@Override
	protected String getVonGroupLabel() {
		return "Links";
	}

	@Override
	protected Image getKopierenButtonImage() {
		return ParamSharedImage.EXCHANGE.getImage();
	}

	@Override
	protected String getKopierenButtonText() {
		return Zeichenketten.PLUGIN_PARAM_BUTTON_TAUSCHEN;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @seede.bsvrz.buv.plugin.param.viewer.AbstractParameterKopierenViewer#
	 * isMultipleTargetsAllowed()
	 */
	@Override
	protected boolean isMultipleTargetsAllowed() {
		return false;
	}

}
