/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginLabelProvider;
import de.bsvrz.buv.plugin.param.provider.ArtDesParametersatzesContentProvider;
import de.bsvrz.buv.plugin.param.viewer.ArtDesParametersatzesViewer;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;

/**
 * Realisiert die Ansicht links unten in Abb. 5-41.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 */
public class ArtDesParametersatzesView extends AbstractParamPluginView {

	/** die Kontext-Hilfe-ID. */
	private static final String HILFE_ID = ParamPlugin.PLUGIN_ID + "."
			+ ArtDesParametersatzesView.class.getSimpleName();

	/** die ID der Ansicht. */
	public static final String ID = ArtDesParametersatzesView.class.getName();

	@Override
	protected AbstractParamPluginContentProvider getContentProvider() {
		AbstractParamPluginContentProvider provider = null;
		if ((getContentViewer() == null) || (getContentViewer().getContentProvider() == null)) {
			provider = new ArtDesParametersatzesContentProvider(this);
		} else {
			provider = (AbstractParamPluginContentProvider) getContentViewer().getContentProvider();
		}
		return provider;
	}

	@Override
	protected AbstractParamPluginLabelProvider getLabelProvider() {
		// leer, kein Labelprovider
		return null;
	}

	@Override
	public void verbindungAufgebaut() {
		setControlsState(true);
		if ((getPanel() != null) && (getPanel().getDisplay() != null) && !getPanel().getDisplay().isDisposed()) {
			getPanel().getDisplay().asyncExec(new Runnable() {

				@Override
				public void run() {
					if (getContentViewer() != null) {
						getContentViewer().setInput(RahmenwerkService.getService().getArtDesParametersatzesProvider());
					}
				}
			});
		}
	}

	@Override
	public void createPartControl(final Composite parent) {
		setPanel(parent);
		setContentViewer(new ArtDesParametersatzesViewer(getPanel()));
		getContentViewer().setContentProvider(getContentProvider());
		getContentViewer().setInput(RahmenwerkService.getService().getArtDesParametersatzesProvider());

		setControlsState(RahmenwerkService.getService().getObjektFactory().isVerbunden());
		RahmenwerkService.getService().getObjektFactory().addPropertyChangeListener(DavProvider.PROP_VERBUNDEN, this);
		getContentProvider().addPropertyChangeListener(AbstractParamPluginContentProvider.PROP_KURZINFO, this);

		getSite().setSelectionProvider(getContentViewer());

		createContextMenu();

		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(getContentViewer().getControl(),
				ArtDesParametersatzesView.HILFE_ID);
	}

}
