/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.handler.ParamDoubleClickListener;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginLabelProvider;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginTableLabelProvider;
import de.bsvrz.buv.plugin.param.provider.BetroffeneObjekteContentProvider;
import de.bsvrz.buv.plugin.param.provider.BetroffeneObjekteLabelProvider;
import de.bsvrz.buv.plugin.param.provider.ParameterSorter;
import de.bsvrz.buv.plugin.param.provider.helper.BitCtrlSpaltenkopfListener;
import de.bsvrz.buv.plugin.selektion.SelektionsTransfer;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;

/**
 * Ansicht zur Darstellung der von der Objektauswahl (linke untere Ansicht in
 * Abb 5-41) potentiell änderbaren Objekte (rechte untere Ansicht in Abb 5-41).
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class BetroffeneObjekteView extends AbstractParamPluginView {

	/** die Kontext-Hilfe-ID. */
	private static final String HILFE_ID = ParamPlugin.PLUGIN_ID + "." + BetroffeneObjekteView.class.getSimpleName();

	/** die ID der Ansicht. */
	public static final String ID = BetroffeneObjekteView.class.getName();

	/** {@inheritDoc} */
	@Override
	public void createPartControl(final Composite parent) {
		setPanel(new Composite(parent, SWT.NONE));
		getPanel().setLayout(new GridLayout(1, false));

		final Table table = new Table(getPanel(), SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		final AbstractParamPluginTableLabelProvider labelProvider = (AbstractParamPluginTableLabelProvider) getLabelProvider();
		setContentViewer(new TableViewer(table));
		int columnIndex;
		for (columnIndex = 0; columnIndex < labelProvider.getNumColumns(); ++columnIndex) {
			final TableColumn column = new TableColumn(table, SWT.NONE);
			final String columnId = labelProvider.getColumnId(columnIndex);
			column.setText(columnId);
			column.setWidth(labelProvider.getPreferredColumnWidth(columnId));
			column.addSelectionListener(new BitCtrlSpaltenkopfListener(column, (TableViewer) getContentViewer()));
		}

		((TableViewer) getContentViewer()).setComparator(new ParameterSorter());
		((TableViewer) getContentViewer()).addDoubleClickListener(new ParamDoubleClickListener());
		((TableViewer) getContentViewer()).setComparer(new ParamViewerElementComparer());
		final BetroffeneObjekteContentProvider contentProvider = (BetroffeneObjekteContentProvider) getContentProvider();
		contentProvider.setBetroffeneObjekteZeigen(true);
		contentProvider.setNichtAenderbareObjekteZeigen(true);
		getContentViewer().setContentProvider(contentProvider);
		getContentViewer().setLabelProvider(labelProvider);

		// setInput() wird erst aufgerufen, wenn im ObjektauswahlView eine
		// Selektion erfolgt
		setControlsState(RahmenwerkService.getService().getObjektFactory().isVerbunden());
		RahmenwerkService.getService().getObjektFactory().addPropertyChangeListener(DavProvider.PROP_VERBUNDEN, this);
		contentProvider.addPropertyChangeListener(AbstractParamPluginContentProvider.PROP_KURZINFO, this);

		getSite().setSelectionProvider(getContentViewer());

		createContextMenu();

		/*
		 * Anmeldung für den automatischen Empfang von Selektionen (Mantis#1547,1270)
		 */
		SelektionsTransfer.getInstanz().addSelektionsListener(new ParamPluginSelektionsListener(this));

		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(getContentViewer().getControl(),
				BetroffeneObjekteView.HILFE_ID);
	}

	@Override
	protected AbstractParamPluginContentProvider getContentProvider() {
		AbstractParamPluginContentProvider provider = null;
		if ((getContentViewer() == null) || (getContentViewer().getContentProvider() == null)) {
			provider = new BetroffeneObjekteContentProvider(this);
		} else {
			provider = (AbstractParamPluginContentProvider) getContentViewer().getContentProvider();
		}
		return provider;
	}

	@Override
	protected AbstractParamPluginLabelProvider getLabelProvider() {
		AbstractParamPluginLabelProvider provider = null;
		if ((getContentViewer() == null) || (getContentViewer().getLabelProvider() == null)
				|| !(getContentViewer().getLabelProvider() instanceof AbstractParamPluginLabelProvider)) {
			provider = new BetroffeneObjekteLabelProvider();
		} else {
			provider = (AbstractParamPluginLabelProvider) getContentViewer().getLabelProvider();
		}
		return provider;
	}

}
