/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.views;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginLabelProvider;
import de.bsvrz.buv.plugin.param.provider.ObjektauswahlContentProvider;
import de.bsvrz.buv.plugin.param.provider.ObjektauswahlLabelProvider;
import de.bsvrz.buv.plugin.param.provider.ObjektauswahlLegendenAbschnitt;
import de.bsvrz.buv.rw.basislib.legende.ILegende;
import de.bsvrz.sys.funclib.bitctrl.daf.DavProvider;

/**
 * Ansicht zur Darstellung der Objektauswahl, linke untere Ansicht in Abb 5-41.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ObjektauswahlView extends AbstractParamPluginView {

	/** die Kontext-Hilfe-ID. */
	public static final String HILFE_ID = ParamPlugin.PLUGIN_ID + "." + ObjektauswahlView.class.getSimpleName();

	/** die ID der Ansicht. */
	public static final String ID = ObjektauswahlView.class.getName();

	/** alphabetischer Sortierer für die dargestellten Elemente. */
	private final ViewerComparator alphabetischerSortierer = new ViewerComparator();

	/** {@inheritDoc} */
	@Override
	public void createPartControl(final Composite parent) {
		setPanel(new Composite(parent, SWT.NONE));
		getPanel().setLayout(new GridLayout(1, false));

		final Tree tree = new Tree(getPanel(), SWT.BORDER | SWT.MULTI);
		tree.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		setContentViewer(new TreeViewer(tree));
		((TreeViewer) getContentViewer()).setComparer(new ParamViewerElementComparer());

		/*
		 * Vorerst kein Doppelklicklistener, weil dadurch auch ein
		 * SelectionChanged-Event folgt, welches eine Parametrierungsanfrage stellt,
		 * welche blockiert.
		 */
		/*
		 * ((TreeViewer) contentViewer) .addDoubleClickListener(new
		 * ParamDoubleClickListener());
		 */

		getContentViewer().setContentProvider(getContentProvider());
		getContentViewer().setLabelProvider(getLabelProvider());
		((TreeViewer) getContentViewer()).setComparator(alphabetischerSortierer);

		// if (ParamPlugin.getDefault().getObjektFactory().isVerbunden()) {
		// contentViewer.setInput(ParametertypenCache.getInstanz());
		// }
		setControlsState(RahmenwerkService.getService().getObjektFactory().isVerbunden());
		RahmenwerkService.getService().getObjektFactory().addPropertyChangeListener(DavProvider.PROP_VERBUNDEN, this);
		getContentProvider().addPropertyChangeListener(AbstractParamPluginContentProvider.PROP_KURZINFO, this);

		getSite().setSelectionProvider(getContentViewer());

		createContextMenu();

		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(getContentViewer().getControl(), ObjektauswahlView.HILFE_ID);
	}

	/**
	 * {@inheritDoc}
	 *
	 * Das suppress warnings ist ok. Die Methodensignatur kann nicht korrigiert
	 * werden, da die Schnittstelle von Eclipse kommt.
	 */
	@Override
	public Object getAdapter(final Class adapter) {
		if (ILegende.class.isAssignableFrom(adapter)) {
			return new ObjektauswahlLegendenAbschnitt();
		}
		return super.getAdapter(adapter);
	}

	@Override
	protected AbstractParamPluginContentProvider getContentProvider() {
		AbstractParamPluginContentProvider provider = null;
		if ((getContentViewer() == null) || (getContentViewer().getContentProvider() == null)) {
			provider = new ObjektauswahlContentProvider(this);
		} else {
			provider = (AbstractParamPluginContentProvider) getContentViewer().getContentProvider();
		}
		return provider;
	}

	@Override
	protected AbstractParamPluginLabelProvider getLabelProvider() {
		AbstractParamPluginLabelProvider provider = null;
		if ((getContentViewer() == null) || (getContentViewer().getLabelProvider() == null)
				|| !(getContentViewer().getLabelProvider() instanceof AbstractParamPluginLabelProvider)) {
			provider = new ObjektauswahlLabelProvider();
		} else {
			provider = (AbstractParamPluginLabelProvider) getContentViewer().getLabelProvider();
		}
		return provider;
	}

	/**
	 * Workaround, der Viewer wird aktualisiert, wenn ein Parameterdatensatz
	 * gesichert wurde.
	 */
	public void refresh() {
		getContentViewer().refresh();
	}
}
