/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.selektion.SelektionsListener;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Behandelt die automatische Übernahme von Selektionen (Mantis#1547,1270).
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
public final class ParamPluginSelektionsListener implements SelektionsListener {

	/**
	 * Logger zur Verfolgung der Selektionen im Plug-in.
	 */
	private static final Debug DEBUG = Debug.getLogger();

	/**
	 * Der View, in den die Selektion übernommen werden soll.
	 */
	private final AbstractParamPluginView paramPluginView;

	/**
	 * Konstruktor übernimmt Member und Prüft auf Not-Null.
	 *
	 * @param paramPluginView
	 *            Der View, in den die Selektion übernommen werden soll.
	 */
	public ParamPluginSelektionsListener(final AbstractParamPluginView paramPluginView) {
		this.paramPluginView = paramPluginView;
		Assert.isNotNull(paramPluginView);
		DEBUG.info(getClass().getSimpleName() + " konstruiert für Ansicht", paramPluginView.getPartName());
	}

	@Override
	public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
		if (!paramPluginView.isSelektionEmpfangen()) {
			DEBUG.finest("Selektionsempfang ist ausgeschaltet an Ansicht", paramPluginView.getPartName());
			return;
		}
		if (part == paramPluginView) {
			DEBUG.finer("Kreisselektion detektiert an Ansicht", paramPluginView.getPartName());
			return;
		}
		DEBUG.fine("Wende Selektion aus Part " + part.getTitle() + " an auf Ansicht", paramPluginView.getPartName());
		paramPluginView.selectionChanged(part, selection);
	}

	@Override
	public boolean vorigeSelektionBeobachten() {
		return false;
	}

	@Override
	public boolean definierteSelektionenBeobachten(final String... namen) {
		return false;
	}

	@Override
	public boolean aktuelleSelektionBeobachten() {
		return true;
	}
}
