/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.param.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IElementComparer;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;

/**
 * Comparer für Viewer, die Parameter als Elemente haben.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 *
 */
class ParamViewerElementComparer implements IElementComparer {
	@Override
	public int hashCode(final Object element) {
		int hashcode = 0;
		if (element instanceof Parameter) {
			hashcode = ((Parameter) element).getInfo().hashCode();
		} else if (element instanceof SystemObject) {
			hashcode = ((SystemObject) element).hashCode();
		}
		return hashcode;
	}

	@Override
	public boolean equals(final Object a, final Object b) {
		if (a == b) {
			return true;
		}
		boolean result = false;
		SystemObject o = null;
		Parameter p = null;
		if (a instanceof Parameter && b instanceof Parameter) {
			final ParameterInfo ai = ((Parameter) a).getInfo();
			final ParameterInfo bi = ((Parameter) b).getInfo();
			result = ai.equals(bi);
		} else if (a instanceof Parameter && b instanceof SystemObject) {
			o = (SystemObject) b;
			p = (Parameter) a;
		} else if (a instanceof SystemObject && b instanceof Parameter) {
			o = (SystemObject) a;
			p = (Parameter) b;
		} else if (a instanceof SystemObject && b instanceof SystemObject) {
			o = (SystemObject) a;
			result = o.equals(b);
		} else {
			final Object sa = Platform.getAdapterManager().getAdapter(a, SystemObject.class);
			final Object sb = Platform.getAdapterManager().getAdapter(b, SystemObject.class);
			if (sa instanceof SystemObject && sb instanceof SystemObject) {
				o = (SystemObject) sa;
				result = o.equals(sb);
			}
		}
		if (null != o && null != p) {
			result = o.equals(p.getObjekt());
		}
		return result;
	}
}
