/*
 * Rahmenwerk-Plug-in "Parametrierung"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.param.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.viewer.AbstractParameterKopierenViewer;
import de.bsvrz.buv.plugin.param.viewer.ParameterTauschenViewer;

/**
 * Ansicht zum Tauschen zweier Parameter. Im Prinzip wie Parameter kopieren 1:n,
 * nur wird beim Speichern eben nicht nur der Parameter von links nach rechts,
 * sondern auch der von rechts nach links übertragen.
 *
 * @author BitCtrl Systems GmbH, Albrecht Uhlmann
 *
 */
public class ParameterTauschenView extends ParameterKopierenView {

	/**
	 * die ID der Ansicht. Parameter tauschen und Parameter kopieren 1:n sind so
	 * ähnlich, dass eine abstrakte Superklase nicht lohnt. Die Üverdeckung der ID
	 * ist ok.
	 */
	@SuppressWarnings("hiding")
	public static final String ID = ParameterTauschenView.class.getName();

	/** die Kontext-Hilfe-ID. */
	private static final String HILFE_ID = ParamPlugin.PLUGIN_ID + "." + ParameterTauschenView.class.getSimpleName();

	@Override
	public void createPartControl(final Composite parent) {
		super.createPartControl(parent);

		// Online-Hilfe hinzufügen
		PlatformUI.getWorkbench().getHelpSystem().setHelp(getContentViewer().getControl(),
				ParameterTauschenView.HILFE_ID);
	}

	@Override
	protected AbstractParameterKopierenViewer createParameterKopierenViewer(final Composite parent) {
		return new ParameterTauschenViewer(parent, ID, HILFE_ID);
	}

}
