/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param;

import com.bitctrl.beans.BeanUtils;
import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.sys.funclib.bitctrl.modell.AenderbareMenge;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.konfigurationsdaten.KdSimulationsEigenschaften;
import de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation;
import de.bsvrz.sys.funclib.bitctrl.modell.util.KappichModellUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArtDesParametersatzesCache
implements IArtDesParametersatzesProvider {
    private String artDesParametersatzes = IArtDesParametersatzesProvider.ART_ORIGINAL;
    private short selectedSimulationsVariante = (short)-1;
    private long zeitpunkt = -1L;
    private boolean archivAvailable;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public short getSelectedSimulationsVariante() {
        return this.selectedSimulationsVariante;
    }

    @Override
    public String getSimulationsVarianteString(short simulationsVariante) {
        switch (simulationsVariante) {
            case -1: {
                return "Automatisch";
            }
            case 0: {
                return "Original (Echtanlage)";
            }
        }
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        String userName = "";
        if (factory.isVerbunden()) {
            AenderbareMenge simulationen = KappichModellUtil.getAOE((ObjektFactory)factory).getSimulationen();
            for (Simulation simulation : simulationen) {
                KdSimulationsEigenschaften.Daten kdSimulationsEigenschaften = (KdSimulationsEigenschaften.Daten)simulation.getKdSimulationsEigenschaften().getDatum();
                if (kdSimulationsEigenschaften == null) {
                    ParamPlugin.getDefault().getLogger().error("Konfigurationsdaten f\u00fcr Simulation fehlen!");
                    continue;
                }
                if ((Short)kdSimulationsEigenschaften.getSimulationsVariante().getValue() != simulationsVariante) continue;
                userName = ": " + simulation.getName();
                break;
            }
        }
        return "Simulation " + simulationsVariante + userName;
    }

    @Override
    public List<Short> getValidSimlationsVarianten() {
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        ArrayList<Short> validSimulationsVarianten = new ArrayList<Short>();
        validSimulationsVarianten.add((short)-1);
        validSimulationsVarianten.add((short)0);
        if (factory.isVerbunden()) {
            AenderbareMenge simulationen = KappichModellUtil.getAOE((ObjektFactory)factory).getSimulationen();
            for (Simulation simulation : simulationen) {
                KdSimulationsEigenschaften.Daten kdSimulationsEigenschaften = (KdSimulationsEigenschaften.Daten)simulation.getKdSimulationsEigenschaften().getDatum();
                if (kdSimulationsEigenschaften == null) {
                    ParamPlugin.getDefault().getLogger().error("Konfigurationsdaten f\u00fcr Simulation fehlen!");
                    continue;
                }
                validSimulationsVarianten.add((Short)kdSimulationsEigenschaften.getSimulationsVariante().getValue());
            }
        }
        Collections.sort(validSimulationsVarianten);
        return validSimulationsVarianten;
    }

    @Override
    public void setSelectedSimulationsVariante(short selectedSimulationsVariante) {
        boolean valid = this.getValidSimlationsVarianten().contains(selectedSimulationsVariante);
        if (valid) {
            if (this.selectedSimulationsVariante != selectedSimulationsVariante) {
                short oldValue = this.selectedSimulationsVariante;
                this.selectedSimulationsVariante = selectedSimulationsVariante;
                this.propertyChangeSupport.firePropertyChange("selectedSimulationsVariante", oldValue, this.selectedSimulationsVariante);
            }
        } else {
            ParamPlugin.getDefault().getLogger().error("Simulationsvariante " + selectedSimulationsVariante + " ist nicht definiert, vorheriger Wert (" + this.selectedSimulationsVariante + ") wird beibehalten.");
        }
    }

    @Override
    public long getZeitpunkt() {
        return this.zeitpunkt;
    }

    @Override
    public void setZeitpunkt(long zeitpunkt) {
        long now = RahmenwerkService.getService().getObjektFactory().getDav().getTime();
        if (zeitpunkt > now) {
            ParamPlugin.getDefault().getLogger().warning("Zeitpunkt liegt in der Zukunft, setze AKTUELL");
            long oldValue = this.zeitpunkt;
            this.zeitpunkt = -1L;
            this.propertyChangeSupport.firePropertyChange("zeitpunkt", oldValue, this.zeitpunkt);
        } else if (this.zeitpunkt != zeitpunkt) {
            long oldValue = this.zeitpunkt;
            this.zeitpunkt = zeitpunkt;
            this.propertyChangeSupport.firePropertyChange("zeitpunkt", oldValue, this.zeitpunkt);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        return BeanUtils.toString((Object)this);
    }

    @Override
    public String getArtDesParametersatzes() {
        return this.artDesParametersatzes;
    }

    @Override
    public void setArtDesParametersatzes(String artDesParametersatzes) {
        if ((IArtDesParametersatzesProvider.ART_ORIGINAL.equals(artDesParametersatzes) || IArtDesParametersatzesProvider.ART_SIMULATION.equals(artDesParametersatzes) || IArtDesParametersatzesProvider.ART_HISTORISCH.equals(artDesParametersatzes)) && !this.artDesParametersatzes.equals(artDesParametersatzes)) {
            String oldValue = this.artDesParametersatzes;
            this.artDesParametersatzes = artDesParametersatzes;
            this.propertyChangeSupport.firePropertyChange("artDesParametersatzes", oldValue, artDesParametersatzes);
        }
    }

    @Override
    public boolean isArchivAvailable() {
        return this.archivAvailable;
    }

    @Override
    public void setArchivAvailable(boolean archivAvailable) {
        this.archivAvailable = archivAvailable;
    }
}

