/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param;

import com.bitctrl.beans.BeanUtils;
import de.bsvrz.buv.plugin.param.ObjektAuswahlEnum;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.ParameterInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModifiableParameterInfo {
    private SystemObject objekt;
    private final List<SystemObjectType> typen = new ArrayList<SystemObjectType>();
    private AttributeGroup atg;
    private short sim = (short)-1;
    private boolean historisch;
    private long zeitpunkt;

    public SystemObject getObjekt() {
        return this.objekt;
    }

    public void setObjekt(SystemObject objekt) {
        this.objekt = objekt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTyp(SystemObjectType type) {
        List<SystemObjectType> list = this.typen;
        synchronized (list) {
            if (!this.typen.contains(type)) {
                this.typen.add(type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeType(SystemObjectType type) {
        List<SystemObjectType> list = this.typen;
        synchronized (list) {
            this.typen.remove(type);
        }
    }

    public AttributeGroup getAtg() {
        return this.atg;
    }

    public void setAtg(AttributeGroup atg) {
        this.atg = atg;
    }

    public short getSim() {
        return this.sim;
    }

    public void setSim(short sim) {
        if ((sim < 0 || sim > 999) && sim != -1) {
            throw new IllegalArgumentException("Simulationsvariante " + sim + " ist ung\u00fcltig!");
        }
        this.sim = sim;
    }

    public boolean isHistorisch() {
        return this.historisch;
    }

    public void setHistorisch(boolean historisch) {
        this.historisch = historisch;
    }

    public long getZeitpunkt() {
        return this.zeitpunkt;
    }

    public void setZeitpunkt(long zeitpunkt) {
        this.zeitpunkt = zeitpunkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjektAuswahlEnum autoFillTypes() {
        ObjektAuswahlEnum objektAuswahlArt = null;
        List<SystemObjectType> list = this.typen;
        synchronized (list) {
            SystemObjectType selectedType;
            if (this.atg == null) {
                throw new IllegalStateException("Attributgruppe muss angegeben sein");
            }
            if (this.objekt == null) {
                throw new IllegalStateException("Objekt muss angegeben sein");
            }
            ParametertypenCache ptypcache = ParametertypenCache.getInstanz();
            this.typen.clear();
            Set<SystemObjectType> parents = ptypcache.getParents(this.atg);
            objektAuswahlArt = this.objekt instanceof SystemObjectType ? ((selectedType = (SystemObjectType)this.objekt).getAttributeGroups().contains(this.atg) ? ObjektAuswahlEnum.TYP_ECHT : ObjektAuswahlEnum.TYP_VIRTUELL) : ((selectedType = this.objekt.getType()).getAttributeGroups().contains(this.atg) ? ObjektAuswahlEnum.INSTANZ_ECHT : ObjektAuswahlEnum.INSTANZ_VIRTUELL);
            switch (objektAuswahlArt) {
                case TYP_ECHT: 
                case INSTANZ_ECHT: {
                    this.addTyp(selectedType);
                    break;
                }
                case TYP_VIRTUELL: 
                case INSTANZ_VIRTUELL: {
                    HashSet<SystemObjectType> possibleTypes = new HashSet<SystemObjectType>();
                    possibleTypes.addAll(parents);
                    possibleTypes.retainAll(ptypcache.getDirectParents(this.atg));
                    possibleTypes.retainAll(ptypcache.getMappedTypes(selectedType));
                    for (SystemObjectType t : possibleTypes) {
                        this.addTyp(t);
                    }
                    break;
                }
                default: {
                    String s = "Unbekannte Auswahlart " + (Object)((Object)objektAuswahlArt);
                    throw new IllegalStateException(s);
                }
            }
        }
        return objektAuswahlArt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterInfo[] toParameterInfos() {
        ParameterInfo[] infos;
        List<SystemObjectType> list = this.typen;
        synchronized (list) {
            if (this.typen.isEmpty()) {
                throw new IllegalStateException("Mindestens ein Typ muss angegeben sein");
            }
            if (this.atg == null) {
                throw new IllegalStateException("Attributgruppe muss angegeben sein");
            }
            if (this.objekt == null) {
                throw new IllegalStateException("Objekt muss angegeben sein");
            }
            infos = new ParameterInfo[this.typen.size()];
            int loop = 0;
            while (loop < this.typen.size()) {
                infos[loop] = new ParameterInfo(this.objekt, this.typen.get(loop), this.atg, this.sim);
                ++loop;
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModifiableParameterInfo[] resolve() {
        ModifiableParameterInfo[] infos;
        List<SystemObjectType> list = this.typen;
        synchronized (list) {
            if (this.typen.isEmpty()) {
                throw new IllegalStateException("Mindestens ein Typ muss angegeben sein");
            }
            if (this.atg == null) {
                throw new IllegalStateException("Attributgruppe muss angegeben sein");
            }
            if (this.objekt == null) {
                throw new IllegalStateException("Objekt muss angegeben sein");
            }
            infos = new ModifiableParameterInfo[this.typen.size()];
            int loop = 0;
            while (loop < this.typen.size()) {
                ModifiableParameterInfo mpi = new ModifiableParameterInfo();
                mpi.setAtg(this.getAtg());
                mpi.setHistorisch(this.isHistorisch());
                mpi.setObjekt(this.getObjekt());
                mpi.setSim(this.getSim());
                mpi.setZeitpunkt(this.getZeitpunkt());
                mpi.addTyp(this.typen.get(loop));
                infos[loop] = mpi;
                ++loop;
            }
        }
        return infos;
    }

    public void fromParameterInfo(ParameterInfo info) {
        this.objekt = info.getObjekt();
        this.typen.clear();
        this.typen.add(info.getTyp());
        this.atg = info.getAtg();
        this.sim = info.getSim();
    }

    public String toString() {
        return BeanUtils.toString((Object)this);
    }
}

