/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param;

import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;

public final class ParamUtils {
    private static Font boldSystemFont;

    private ParamUtils() {
    }

    public static Font getBoldSystemFont() {
        if (boldSystemFont == null) {
            FontData fontData = PlatformUI.getWorkbench().getDisplay().getSystemFont().getFontData()[0];
            FontData boldFd = new FontData(String.valueOf(fontData.getName()) + " Fett", fontData.getHeight(), fontData.getStyle() | 1);
            boldSystemFont = new Font((Device)PlatformUI.getWorkbench().getDisplay(), boldFd);
        }
        return boldSystemFont;
    }

    public static String getInfotextForAttributeType(AttributeType attributeType, boolean kurz) {
        if (attributeType == null) {
            return "Keine weiteren Informationen verf\u00fcgbar";
        }
        StringBuilder b = new StringBuilder(200);
        b.append("Attributtyp: ");
        if (kurz) {
            b.append(attributeType.getNameOrPidOrId());
        } else {
            b.append(attributeType.toString());
        }
        if (attributeType instanceof IntegerAttributeType) {
            long maximum;
            long minimum;
            IntegerAttributeType iat = (IntegerAttributeType)attributeType;
            b.append("\nGanzzahl. ");
            List states = iat.getStates();
            if (states == null || states.isEmpty()) {
                b.append("Keine Zust\u00e4nde definiert.");
            } else {
                int numStates = states.size();
                b.append(numStates);
                if (1 == numStates) {
                    b.append(" Zustand");
                } else {
                    b.append(" Zust\u00e4nde");
                }
                b.append(" definiert: ");
                int stateLoop = 0;
                for (IntegerValueState state : states) {
                    if (stateLoop > 0) {
                        b.append(", ");
                    }
                    b.append(state.getName());
                    b.append(" (");
                    b.append(state.getValue());
                    b.append(")");
                    if (++stateLoop > 3) break;
                }
            }
            b.append("\nWertebereich: ");
            IntegerValueRange range = iat.getRange();
            double faktor = 1.0;
            String unit = null;
            if (range == null) {
                switch (iat.getByteCount()) {
                    case 1: {
                        minimum = -128L;
                        maximum = 127L;
                        break;
                    }
                    case 4: {
                        minimum = Integer.MIN_VALUE;
                        maximum = Integer.MAX_VALUE;
                        break;
                    }
                    case 2: {
                        minimum = -32768L;
                        maximum = 32767L;
                        break;
                    }
                    default: {
                        minimum = Long.MIN_VALUE;
                        maximum = Long.MAX_VALUE;
                        break;
                    }
                }
            } else {
                faktor = range.getConversionFactor();
                minimum = range.getMinimum();
                maximum = range.getMaximum();
                unit = range.getUnit();
            }
            b.append(minimum);
            b.append(" - ");
            b.append(maximum);
            b.append("\nGenauigkeit: ");
            if (faktor > 1.0) {
                b.append((long)faktor);
            } else {
                b.append(faktor);
            }
            if (unit != null) {
                b.append(" ");
                b.append(unit);
            }
        } else if (attributeType instanceof ReferenceAttributeType) {
            ReferenceAttributeType rat = (ReferenceAttributeType)attributeType;
            b.append("\nObjektreferenz ");
            if (rat.isUndefinedAllowed()) {
                b.append("(optional), ");
            } else {
                b.append("(Pflicht), ");
            }
            SystemObjectType rot = rat.getReferencedObjectType();
            b.append("Typ: ");
            if (rot == null) {
                b.append("Alle erlaubt");
            } else if (kurz) {
                b.append(rot.getNameOrPidOrId());
            } else {
                b.append(rot.toString());
            }
        } else if (attributeType instanceof TimeAttributeType) {
            TimeAttributeType attType = (TimeAttributeType)attributeType;
            if (attType.isRelative()) {
                b.append("\nRelative Zeitangabe");
            } else {
                b.append("\nAbsolute Zeitangabe");
            }
            if (attType.getAccuracy() == 1) {
                b.append(", millisekundengenau");
            } else if (attType.getAccuracy() == 0) {
                b.append(", sekundengenau");
            }
        } else if (attributeType instanceof StringAttributeType) {
            b.append("\nTextwert. Maximle L\u00e4nge: ");
            StringAttributeType sat = (StringAttributeType)attributeType;
            if (sat.getMaxLength() == 0) {
                b.append("Unbegrenzt");
            } else {
                b.append(sat.getMaxLength());
                b.append(" Zeichen");
            }
        }
        b.append("\nKurzinfo: ");
        b.append(attributeType.getInfo().getShortInfo());
        String beschreibung = attributeType.getInfo().getDescription();
        if (beschreibung.length() > 0) {
            b.append("\nBeschreibung: ");
            if (kurz && beschreibung.length() > 100) {
                b.append(beschreibung.substring(0, 100));
                b.append("...");
            } else {
                b.append(beschreibung);
            }
        }
        return b.toString();
    }
}

