/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param;

import com.bitctrl.lib.eclipse.log.PluginLogger;
import de.bsvrz.buv.plugin.param.HierarchieObjekteEintrag;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectComparatorAlphabetical;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class ParametertypenCache {
    private final AttributeGroup[] parametrierendeAttributGruppen;
    private final SystemObjectType[] parametrierbareSystemObjektTypen;
    private final Map<SystemObjectType, List<AttributeGroup>> systemObjektParameterMap = new LinkedHashMap<SystemObjectType, List<AttributeGroup>>();
    private final Map<ConfigurationArea, List<SystemObjectType>> configAreaMap = new LinkedHashMap<ConfigurationArea, List<SystemObjectType>>();
    private static ParametertypenCache instanz;
    private final Map<AttributeGroup, Set<SystemObjectType>> attributeGroupParents = new LinkedHashMap<AttributeGroup, Set<SystemObjectType>>();
    private final Map<SystemObjectType, Set<SystemObjectType>> hierarchieBeeinflussteTypen = new LinkedHashMap<SystemObjectType, Set<SystemObjectType>>();

    private ParametertypenCache(ObjektFactory factory) {
        DataModel model = factory.getDav().getDataModel();
        ArrayList<AttributeGroup> patgs = new ArrayList<AttributeGroup>();
        List alleTypen = model.getType("typ.typ").getElements();
        SystemObjectType hierarchieDefinitionType = model.getType("typ.hierarchieDefinition");
        List hierarchien = hierarchieDefinitionType.getElements();
        LinkedHashMap typVerwendungenInHierarchien = new LinkedHashMap();
        for (SystemObject o : hierarchien) {
            Data definitionData = o.getConfigurationData(model.getAttributeGroup("atg.hierarchieDefinition"));
            ArrayList<HierarchieObjekteEintrag> hoe = new ArrayList<HierarchieObjekteEintrag>();
            ArrayList<SystemObjectType> currentObjects = new ArrayList<SystemObjectType>();
            Data.Array hierarchieObjekteArray = definitionData.getArray("HierarchieObjekte");
            int loop = 0;
            while (loop < hierarchieObjekteArray.getLength()) {
                Data currentItem = hierarchieObjekteArray.getItem(loop);
                hoe.add(new HierarchieObjekteEintrag(currentItem, model));
                ++loop;
            }
            this.sortiereHierarchieObjektEintraege(hoe);
            for (HierarchieObjekteEintrag e : hoe) {
                SystemObjectType type = e.getObjektTyp();
                if (!currentObjects.contains(type)) {
                    currentObjects.add(type);
                }
                if ((type = e.getNachfolgerTyp()) == null || currentObjects.contains(type)) continue;
                currentObjects.add(type);
            }
            typVerwendungenInHierarchien.put(o, currentObjects);
            int currentObjectLoop = 0;
            while (currentObjectLoop < currentObjects.size() - 1) {
                Iterator virtualKeyType = (SystemObjectType)currentObjects.get(currentObjectLoop);
                LinkedHashSet<SystemObjectType> mappedRealTypes = new LinkedHashSet<SystemObjectType>();
                int mappedTypeLoop = currentObjectLoop + 1;
                while (mappedTypeLoop < currentObjects.size()) {
                    mappedRealTypes.add((SystemObjectType)currentObjects.get(mappedTypeLoop));
                    ++mappedTypeLoop;
                }
                this.hierarchieBeeinflussteTypen.put((SystemObjectType)virtualKeyType, (Set<SystemObjectType>)mappedRealTypes);
                ++currentObjectLoop;
            }
        }
        ArrayList<SystemObjectType> parametrierbareTypen = new ArrayList<SystemObjectType>();
        for (SystemObject o : alleTypen) {
            boolean typeHasParameter = false;
            SystemObjectType type = (SystemObjectType)o;
            ArrayList<AttributeGroup> localPAtgs = new ArrayList<AttributeGroup>();
            LinkedHashSet virtualAtgsOfType = new LinkedHashSet();
            virtualAtgsOfType.addAll(type.getAttributeGroups());
            for (Map.Entry entry : typVerwendungenInHierarchien.entrySet()) {
                SystemObject h = (SystemObject)entry.getKey();
                List typenInHierarchie = (List)entry.getValue();
                SystemObjectType t = (SystemObjectType)typenInHierarchie.get(0);
                if (!type.equals(t)) continue;
                int loop = 1;
                while (loop < typenInHierarchie.size()) {
                    SystemObjectType nachfolger = (SystemObjectType)typenInHierarchie.get(loop);
                    virtualAtgsOfType.addAll(nachfolger.getAttributeGroups());
                    ++loop;
                }
            }
            for (AttributeGroup atg : virtualAtgsOfType) {
                if (!atg.isParameter()) continue;
                if (!patgs.contains(atg)) {
                    patgs.add(atg);
                }
                localPAtgs.add(atg);
                typeHasParameter = true;
            }
            for (AttributeGroup atg : localPAtgs) {
                Set<SystemObjectType> localAtgParents = this.attributeGroupParents.get(atg);
                if (localAtgParents == null) {
                    localAtgParents = new LinkedHashSet<SystemObjectType>();
                    this.attributeGroupParents.put(atg, localAtgParents);
                }
                localAtgParents.add(type);
            }
            if (!typeHasParameter) continue;
            parametrierbareTypen.add(type);
            this.systemObjektParameterMap.put(type, localPAtgs);
            ConfigurationArea kb = type.getConfigurationArea();
            if (this.configAreaMap.containsKey(kb)) {
                this.configAreaMap.get(kb).add(type);
                continue;
            }
            ArrayList<SystemObjectType> kbSystemObjects = new ArrayList<SystemObjectType>();
            kbSystemObjects.add(type);
            this.configAreaMap.put(kb, kbSystemObjects);
        }
        Collections.sort(patgs, new SystemObjectComparatorAlphabetical(false));
        Collections.sort(parametrierbareTypen, new SystemObjectComparatorAlphabetical(false));
        this.parametrierbareSystemObjektTypen = parametrierbareTypen.toArray(new SystemObjectType[parametrierbareTypen.size()]);
        this.parametrierendeAttributGruppen = patgs.toArray(new AttributeGroup[patgs.size()]);
        String msg = String.valueOf(alleTypen.size()) + " Typen insgesamt, davon haben " + parametrierbareTypen.size() + " Typen Parameter in " + this.configAreaMap.keySet().size() + " Konfigurationsbereichen mit insgesamt " + patgs.size() + " parametrierende Attributgruppen";
        if (ParamPlugin.getDefault() == null) {
            Logger.getLogger(this.getClass().getName()).info(msg);
        } else {
            ParamPlugin.getDefault().getLogger().info(msg);
        }
    }

    private void sortiereHierarchieObjektEintraege(List<HierarchieObjekteEintrag> hoe) {
        int istIndes;
        if (hoe.size() <= 1) {
            return;
        }
        if (2 == hoe.size()) {
            if (hoe.get(0).getNachfolgerTyp().equals(hoe.get(1).getObjektTyp())) {
                return;
            }
            Collections.swap(hoe, 0, 1);
            return;
        }
        ArrayList<Integer> moeglicheEndeEntries = new ArrayList<Integer>();
        int loop = 0;
        while (loop < hoe.size()) {
            HierarchieObjekteEintrag e = hoe.get(loop);
            SystemObjectType n = e.getNachfolgerTyp();
            if (n == null) {
                moeglicheEndeEntries.add(loop);
            } else {
                boolean found = false;
                int innerLoop = 0;
                while (innerLoop < hoe.size()) {
                    if (innerLoop != loop && hoe.get(innerLoop).getObjektTyp().equals(n)) {
                        found = true;
                        break;
                    }
                    ++innerLoop;
                }
                if (!found) {
                    moeglicheEndeEntries.add(loop);
                }
            }
            ++loop;
        }
        PluginLogger plog = ParamPlugin.getDefault().getLogger();
        if (1 != moeglicheEndeEntries.size()) {
            plog.warning("Hierarchie ist nicht konsistent. Es gibt " + moeglicheEndeEntries.size() + " m\u00f6gliche Endeobjekte");
            return;
        }
        int endeIndex = hoe.size() - 1;
        if (endeIndex != (istIndes = ((Integer)moeglicheEndeEntries.get(0)).intValue())) {
            plog.info("Fixiere Endeelement von " + istIndes + " nach " + endeIndex);
            Collections.swap(hoe, endeIndex, istIndes);
        }
        loop = endeIndex;
        while (loop > 0) {
            int currentIdx = loop - 1;
            SystemObjectType gesuchterNachfolgerTyp = hoe.get(loop).getObjektTyp();
            boolean found = false;
            int innerLoop = 0;
            while (innerLoop < loop) {
                if (gesuchterNachfolgerTyp.equals(hoe.get(innerLoop).getNachfolgerTyp())) {
                    found = true;
                    break;
                }
                ++innerLoop;
            }
            if (!found) {
                plog.warning("Unterbrochene Hierarchie - Sortierung wird abgebrochen.");
                return;
            }
            if (innerLoop != currentIdx) {
                plog.info("Tausche Elemente " + currentIdx + " und " + innerLoop);
                Collections.swap(hoe, currentIdx, innerLoop);
            }
            --loop;
        }
    }

    public AttributeGroup[] getParametrierendeAttributGruppen() {
        return this.parametrierendeAttributGruppen;
    }

    public SystemObjectType[] getParametrierbareSystemObjektTypen() {
        return this.parametrierbareSystemObjektTypen;
    }

    public List<AttributeGroup> getAttributeGroups(SystemObjectType type) {
        return this.systemObjektParameterMap.get(type);
    }

    public Set<ConfigurationArea> getConfigurationAreas() {
        return this.configAreaMap.keySet();
    }

    public List<SystemObjectType> getSystemObjects(ConfigurationArea kb) {
        ArrayList<SystemObjectType> result = new ArrayList<SystemObjectType>();
        List<SystemObjectType> types = this.configAreaMap.get(kb);
        if (types != null) {
            result.addAll(types);
        }
        return result;
    }

    public Set<SystemObjectType> getParents(AttributeGroup atg) {
        LinkedHashSet<SystemObjectType> result = new LinkedHashSet<SystemObjectType>();
        Set<SystemObjectType> parents = this.attributeGroupParents.get(atg);
        if (parents != null) {
            result.addAll(parents);
        }
        return result;
    }

    public Set<SystemObjectType> getRealParents(AttributeGroup atg) {
        LinkedHashSet<SystemObjectType> result = new LinkedHashSet<SystemObjectType>();
        Set<SystemObjectType> parents = this.attributeGroupParents.get(atg);
        if (parents != null) {
            for (SystemObjectType t : parents) {
                if (!t.getAttributeGroups().contains(atg)) continue;
                result.add(t);
            }
        }
        return result;
    }

    public Set<SystemObjectType> getDirectParents(AttributeGroup atg) {
        LinkedHashSet<SystemObjectType> result = new LinkedHashSet<SystemObjectType>();
        Set<SystemObjectType> realParents = this.getRealParents(atg);
        result.addAll(realParents);
        for (SystemObjectType r : realParents) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                SystemObjectType t = (SystemObjectType)iter.next();
                if (!r.getSubTypes().contains(t)) continue;
                iter.remove();
            }
        }
        return result;
    }

    public Set<SystemObjectType> getMappedTypes(SystemObjectType virtualType) {
        LinkedHashSet<SystemObjectType> result = new LinkedHashSet<SystemObjectType>();
        Set<SystemObjectType> knownMappedTypes = this.hierarchieBeeinflussteTypen.get(virtualType);
        if (knownMappedTypes != null) {
            result.addAll(knownMappedTypes);
        }
        return result;
    }

    public static void erzeugeInstanz(ObjektFactory factory) {
        if (instanz == null && factory.isVerbunden()) {
            instanz = new ParametertypenCache(factory);
        }
    }

    public static ParametertypenCache getInstanz() {
        if (instanz == null) {
            throw new IllegalStateException("Das Singleton der Klasse " + ParametertypenCache.class.getSimpleName() + " muss zun\u00e4chst mit der Methode createInstanz erzeugt werden!");
        }
        return instanz;
    }
}

