/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors;

import de.bsvrz.buv.plugin.param.editors.IParameterFormPageFactory;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorLegendenAbschnitt;
import de.bsvrz.buv.plugin.param.editors.ParameterFormToolkit;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.rw.basislib.legende.ILegende;
import de.bsvrz.buv.rw.basislib.printing.RwPrintable;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterEditor
extends FormEditor
implements RwPrintable {
    public static final String EDITOR_ID = ParameterEditor.class.getName();
    public static final String HILFE_ID = "de.bsvrz.buv.plugin.param." + ParameterEditor.class.getSimpleName();
    public static final String PARAMETER_EDITOR_KONTEXT = "de.bsvrz.buv.plugin.param.editor.context";
    public static final int EDITED_INDEX = 0;
    public static final String[] VALID_INDICES = new String[]{"Vorgabe", "Soll", "Default", "Ist"};

    protected void addPages() {
        IParameterFormPageFactory selectedFactory;
        block13: {
            selectedFactory = this.getEditorInput().getSelectedFactory();
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            Cursor waitCursor = null;
            try {
                try {
                    if (shell != null) {
                        waitCursor = new Cursor((Device)Display.getDefault(), 1);
                        shell.setCursor(waitCursor);
                    }
                    int index = 0;
                    while (index < selectedFactory.getNumFormPages(this)) {
                        this.addPage(index, selectedFactory.createFormPage(this, index));
                        ++index;
                    }
                }
                catch (PartInitException e) {
                    ParamPlugin.getDefault().getLogger().error("Parametereditor konnte nicht ge\u00f6ffnet werden", (Throwable)e);
                    if (shell != null) {
                        shell.setCursor(null);
                    }
                    if (waitCursor != null) {
                        waitCursor.dispose();
                        waitCursor = null;
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (shell != null) {
                    shell.setCursor(null);
                }
                if (waitCursor != null) {
                    waitCursor.dispose();
                    waitCursor = null;
                }
                throw throwable;
            }
            if (shell != null) {
                shell.setCursor(null);
            }
            if (waitCursor != null) {
                waitCursor.dispose();
                waitCursor = null;
            }
        }
        this.setPartName(this.getEditorInput().getName());
        this.firePropertyChange(1);
        String helpContextId = selectedFactory.getHelpContextId();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getContainer(), helpContextId);
    }

    protected FormToolkit createToolkit(Display display) {
        int formStyleBits = this.getEditorInput() != null && this.getEditorInput().getSelectedFactory() != null ? this.getEditorInput().getSelectedFactory().getFormStyleBits() : 768;
        return new ParameterFormToolkit(display, formStyleBits);
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage editedFormPage = (IFormPage)this.pages.get(0);
        for (Object page : this.pages) {
            if (!(page instanceof IFormPage)) continue;
            IFormPage formPage = (IFormPage)page;
            if (editedFormPage == formPage) {
                this.handleSave(monitor, formPage);
                continue;
            }
            this.handleStaleAspects(editedFormPage, formPage);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("Das Abspeichern von Parametern an anderen Objekten wird momentan nicht unters\u00fctzt.");
    }

    public Object getAdapter(Class adapter) {
        Object legende = null;
        if (ILegende.class.isAssignableFrom(adapter)) {
            if (-1 == this.getActivePage()) {
                return null;
            }
            IFormPage activeFormPage = (IFormPage)this.pages.get(this.getActivePage());
            if (activeFormPage instanceof ILegende) {
                legende = (ILegende)activeFormPage;
            } else {
                Object o = activeFormPage.getAdapter(ILegende.class);
                if (o instanceof ILegende) {
                    legende = (ILegende)o;
                } else {
                    o = Platform.getAdapterManager().getAdapter((Object)activeFormPage, ILegende.class);
                    if (o instanceof ILegende) {
                        legende = (ILegende)o;
                    }
                }
            }
            if (legende == null) {
                legende = new ParameterEditorLegendenAbschnitt(this.getEditorInput());
            }
            return legende;
        }
        return super.getAdapter(adapter);
    }

    public String getDefaultHeader(boolean oneLine) {
        char lineBreak = oneLine ? (char)' ' : '\n';
        Parameter[] parameters = this.getEditorInput().getParameters();
        ParameterInfo info = parameters[0].getInfo();
        StringBuilder b = new StringBuilder("Parameter der Attributgruppe '");
        b.append(info.getAtg().toString());
        b.append("'");
        b.append(lineBreak);
        b.append("Aspekt: ");
        int activePageIndex = this.getActivePage();
        if (activePageIndex < 0 || activePageIndex >= VALID_INDICES.length) {
            b.append("Unbekannt");
        } else {
            b.append(VALID_INDICES[activePageIndex]);
        }
        b.append(lineBreak);
        b.append("Simulationsvariante ");
        b.append(info.getSim());
        b.append(" - ");
        b.append(RahmenwerkService.getService().getArtDesParametersatzesProvider().getSimulationsVarianteString(info.getSim()));
        if (1 < parameters.length) {
            b.append(lineBreak);
            b.append("Insgesamt ");
            b.append(parameters.length);
            b.append(" Objekte");
        }
        return b.toString();
    }

    public PagePrint getDruckAuftrag() {
        PagePrint druckAuftrag = null;
        if (-1 == this.getActivePage()) {
            return null;
        }
        IFormPage activeFormPage = (IFormPage)this.pages.get(this.getActivePage());
        if (activeFormPage instanceof RwPrintable) {
            druckAuftrag = ((RwPrintable)activeFormPage).getDruckAuftrag();
        }
        return druckAuftrag;
    }

    public ParameterEditorInput getEditorInput() {
        return (ParameterEditorInput)super.getEditorInput();
    }

    public String getTitel() {
        String specificTitel;
        IFormPage activeFormPage = (IFormPage)this.pages.get(this.getActivePage());
        if (activeFormPage instanceof RwPrintable && (specificTitel = ((RwPrintable)activeFormPage).getTitel()) != null) {
            return specificTitel;
        }
        return this.getDefaultHeader(true);
    }

    private void handleSave(IProgressMonitor monitor, IFormPage formPage) {
        AbstractParamPluginContentProvider contentProvider;
        formPage.doSave(monitor);
        if (!formPage.isDirty() && (contentProvider = this.getEditorInput().getContentProvider()) != null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell shell = display.getActiveShell();
            Cursor waitCursor = null;
            try {
                try {
                    if (shell != null) {
                        waitCursor = new Cursor((Device)Display.getDefault(), 1);
                        shell.setCursor(waitCursor);
                    }
                    contentProvider.reloadCurrentInput(true);
                }
                catch (ParameterClientException e) {
                    ParamPlugin.getDefault().getLogger().error("Fehler beim Aktualisieren der Ansicht", (Throwable)e);
                    if (shell != null) {
                        shell.setCursor(null);
                    }
                    if (waitCursor != null) {
                        waitCursor.dispose();
                        waitCursor = null;
                    }
                }
            }
            finally {
                if (shell != null) {
                    shell.setCursor(null);
                }
                if (waitCursor != null) {
                    waitCursor.dispose();
                    waitCursor = null;
                }
            }
        }
    }

    private void handleStaleAspects(IFormPage editedFormPage, IFormPage formPage) {
        block4: {
            block5: {
                if (editedFormPage.isDirty()) break block4;
                if (formPage.getManagedForm() == null) break block5;
                IFormPart[] iFormPartArray = formPage.getManagedForm().getParts();
                int n = iFormPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFormPart formPart = iFormPartArray[n2];
                    if (formPart instanceof AbstractFormPart) {
                        ((AbstractFormPart)formPart).markStale();
                    }
                    ++n2;
                }
                break block4;
            }
            if (1 != formPage.getIndex()) break block4;
            try {
                this.getEditorInput().sollParameterAbfragen();
                this.getEditorInput().copySollToVorgabe(null);
            }
            catch (ParameterClientException e) {
                ParamPlugin.getDefault().getLogger().error("Fehler beim Abfragen der aktualisierten Sollparameter", (Throwable)e);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void selectiveReload(Parameter[] parameters, boolean force) {
        boolean doReload;
        ArrayList<Parameter> availableParameters = new ArrayList<Parameter>();
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            Parameter[] parameterArray2 = this.getEditorInput().getParameters();
            int n3 = parameterArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Parameter editedParameter = parameterArray2[n4];
                if (editedParameter.getInfo().equals((Object)p.getInfo())) {
                    availableParameters.add(p);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        try {
            this.getEditorInput().sollParameterAbfragen();
        }
        catch (ParameterClientException e) {
            ParamPlugin.getDefault().getLogger().error("Fehler beim Abfragen der aktualisierten Sollparameter", (Throwable)e);
        }
        if (force) {
            doReload = true;
        } else {
            StringBuilder b = new StringBuilder("M\u00f6chten Sie die folgenden " + availableParameters.size() + " Parameter neu laden?\n");
            int maxObjects = 40;
            int loop = 0;
            for (Parameter parameter : availableParameters) {
                b.append('\n');
                b.append(parameter.getObjekt().toString());
                if (++loop < 40) continue;
                b.append(", ...");
                break;
            }
            doReload = MessageDialog.openQuestion(null, (String)"Parameter neu laden?", (String)b.toString());
        }
        if (doReload) {
            this.getEditorInput().copySollToVorgabe(availableParameters);
        }
        IFormPage vorgabeFormPage = (IFormPage)this.pages.get(0);
        IFormPart[] iFormPartArray = vorgabeFormPage.getManagedForm().getParts();
        int n5 = iFormPartArray.length;
        int n6 = 0;
        while (n6 < n5) {
            IFormPart formPart = iFormPartArray[n6];
            if (formPart instanceof AbstractFormPart) {
                ((AbstractFormPart)formPart).refresh();
            }
            ++n6;
        }
        this.getEditorInput().getSelectedParameters().clear();
    }

    public void setFocus() {
        this.getContainer().setFocus();
    }
}

