/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors;

import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.editors.IParameterFormPageFactory;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInfo;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ParameterEditorAuswahlDialog
extends TitleAreaDialog {
    private final List<IParameterFormPageFactory> factories;
    private IParameterFormPageFactory selectedFactory;

    public ParameterEditorAuswahlDialog(Shell parentShell, List<IParameterFormPageFactory> factories, IParameterFormPageFactory preSelectedFactory) {
        super(parentShell);
        this.factories = factories;
        Assert.isNotNull(factories);
        Assert.isTrue((factories.size() > 1 ? 1 : 0) != 0);
        this.selectedFactory = preSelectedFactory;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Auswahl des Parameter-Editors");
        parent.getShell().setImage(ParamSharedImage.QUESTION_MARK.getImage());
        this.setTitle("Es sind mehrere Parameter-Editoren verf\u00fcgbar");
        this.setMessage("Bitte w\u00e4hlen Sie den Editor aus!");
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(1, false);
        gl.marginLeft = 10;
        gl.marginRight = 10;
        gl.verticalSpacing = 10;
        panel.setLayout((Layout)gl);
        Group factoriesGroup = new Group(panel, 0);
        GridLayout factoriesGroupLayout = new GridLayout(1, false);
        factoriesGroup.setLayout((Layout)factoriesGroupLayout);
        factoriesGroup.setText("Verf\u00fcgbare Editoren");
        factoriesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int loop = 0;
        while (loop < this.factories.size()) {
            IParameterFormPageFactory factory = this.factories.get(loop);
            ParameterEditorInfo factoryInfo = factory.getEditorInfo();
            Button button = new Button((Composite)factoriesGroup, 80);
            button.setData((Object)factory);
            GridData gd = new GridData(16384, 128, false, false);
            gd.horizontalSpan = 1;
            gd.horizontalAlignment = 16384;
            button.setLayoutData((Object)gd);
            button.setSelection(factory == this.selectedFactory);
            button.setEnabled(true);
            button.setText(String.valueOf(factoryInfo.getName()) + " - " + factoryInfo.getManufacturer());
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.widget;
                    if (b.getSelection()) {
                        ParameterEditorAuswahlDialog.this.selectedFactory = (IParameterFormPageFactory)b.getData();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++loop;
        }
        return panel;
    }

    public IParameterFormPageFactory getSelectedFactory() {
        return this.selectedFactory;
    }
}

