/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors;

import java.text.SimpleDateFormat;
import java.util.Date;

public final class ParameterEditorInfo {
    private final String name;
    private final String manufacturer;
    private final String version;
    private final Date releaseDate;

    public ParameterEditorInfo(String name, String manufacturer, String version, Date releaseDate) {
        this.name = name == null || name.length() <= 0 ? "Unbekannter Editor" : name;
        this.manufacturer = manufacturer == null || manufacturer.length() <= 0 ? "unbekannt" : manufacturer;
        this.version = version == null || version.length() <= 0 ? "unbekannt" : version;
        this.releaseDate = releaseDate == null ? new Date() : releaseDate;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        return String.valueOf(this.getName()) + "\n\nHersteller: " + this.getManufacturer() + "\nVersion " + this.getVersion() + " (vom " + dateFormat.format(this.getReleaseDate()) + ")";
    }
}

