/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors;

import de.bsvrz.buv.plugin.param.editors.AttributePropagationMode;
import de.bsvrz.buv.plugin.param.editors.DataValueTextArrayMemberCombinator;
import de.bsvrz.buv.plugin.param.editors.IParameterFormPageFactory;
import de.bsvrz.buv.plugin.param.editors.InitialDirtyStateMode;
import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorSaveMode;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.lib.ParameterManagerAllgemein;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.ParameterManager;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ParameterEditorInput
implements IEditorInput {
    private static final Debug DEBUG = Debug.getLogger();
    private static final Map<List<Boolean>, Color> COLORS = new LinkedHashMap<List<Boolean>, Color>();
    private final Parameter[] parameters;
    private final Parameter[] sollParameters;
    private final Parameter[] defaultParameters;
    private final Parameter[] istParameters;
    private final Set<Integer> selectedParameters = new HashSet<Integer>();
    private final AbstractParamPluginContentProvider contentProvider;
    private AttributePropagationMode attributePropagationMode = AttributePropagationMode.ONLY_EDITED;
    private ParameterEditorSaveMode saveMode = ParameterEditorSaveMode.ONLY_MODIFIED;
    private IParameterFormPageFactory selectedFactory;
    private InitialDirtyStateMode initialDirtyStateMode = InitialDirtyStateMode.ONLY_ON_DIFFERENCES_TO_SOLL;

    static {
        ParameterEditorInput.setVorgabeColor(Arrays.asList(false, true, true), new Color((Device)Display.getDefault(), 255, 255, 0));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(true, false, true), new Color((Device)Display.getDefault(), 89, 131, 255));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(true, true, false), new Color((Device)Display.getDefault(), 255, 30, 30));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(false, true, false), new Color((Device)Display.getDefault(), 255, 128, 0));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(true, false, false), new Color((Device)Display.getDefault(), 244, 0, 244));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(false, false, true), new Color((Device)Display.getDefault(), 50, 230, 30));
        ParameterEditorInput.setVorgabeColor(Arrays.asList(false, false, false), new Color((Device)Display.getDefault(), 225, 80, 0));
    }

    public static String getPlainValueFromPlainData(Data plainData) {
        String value = "<Undefiniert>";
        String plainDataValueStr = plainData.valueToString();
        if (plainDataValueStr != null && !"<Undefiniert>".equals(plainDataValueStr)) {
            AttributeType attributeType = plainData.getAttributeType();
            if (attributeType instanceof StringAttributeType) {
                value = plainData.asTextValue().getValueText();
            } else if (attributeType instanceof IntegerAttributeType) {
                value = plainData.asUnscaledValue().getValueText();
            } else if (attributeType instanceof TimeAttributeType) {
                value = plainData.asTimeValue().getValueText();
            } else if (attributeType instanceof DoubleAttributeType) {
                value = plainData.asUnscaledValue().getValueText();
            } else if (attributeType instanceof ReferenceAttributeType) {
                SystemObject o = plainData.asReferenceValue().getSystemObject();
                value = o != null ? o.getPidOrId() : "undefiniert";
            }
        }
        return value;
    }

    public static Color getVorgabeColor(List<Boolean> key) {
        return COLORS.get(key);
    }

    public static void setVorgabeColor(List<Boolean> key, Color color) {
        Assert.isNotNull(key, (String)"Keine Kombination aus Unterschieden zu Aspekten \u00fcbergeben");
        Assert.isTrue((3 == key.size() ? 1 : 0) != 0, (String)"\u00dcbergebene Kombination aus Unterschieden zu Aspekten muss genau 3 Elemente enthalten");
        Color old = COLORS.get(key);
        if (old != null) {
            old.dispose();
            if (color == null) {
                COLORS.remove(key);
            }
        } else if (color != null) {
            COLORS.put(key, color);
        }
    }

    public ParameterEditorInput(Parameter[] parameters, AbstractParamPluginContentProvider contentProvider) throws ParameterClientException {
        this.parameters = ParameterManagerAllgemein.getFilledParameterArray(parameters);
        this.contentProvider = contentProvider;
        String message = "Es m\u00fcssen Parameter zur Bearbeitung \u00fcbergeben werden";
        Assert.isNotNull((Object)parameters, (String)"Es m\u00fcssen Parameter zur Bearbeitung \u00fcbergeben werden");
        Assert.isTrue((parameters.length > 0 ? 1 : 0) != 0, (String)"Es m\u00fcssen Parameter zur Bearbeitung \u00fcbergeben werden");
        Assert.isNotNull((Object)parameters[0], (String)"Es m\u00fcssen Parameter zur Bearbeitung \u00fcbergeben werden");
        ParameterInfo[] infos = new ParameterInfo[parameters.length];
        int loop = 0;
        while (loop < parameters.length) {
            infos[loop] = new ParameterInfo(parameters[loop].getObjekt(), parameters[loop].getTyp(), parameters[loop].getAtg(), parameters[loop].getSim());
            ++loop;
        }
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav());
        this.sollParameters = hierarchie.getParameter(infos);
        this.defaultParameters = ParameterManagerAllgemein.getInstanz().getDefaultParameter(infos);
        this.istParameters = ParameterManagerAllgemein.getInstanz().getIstParameter(infos);
    }

    public void copySollToVorgabe(List<Parameter> availableParameters) {
        this.selectedParameters.clear();
        int loop = 0;
        while (loop < this.parameters.length) {
            boolean doCopy = false;
            if (availableParameters == null) {
                doCopy = true;
            } else {
                for (Parameter availableParameter : availableParameters) {
                    if (!availableParameter.getInfo().equals((Object)this.parameters[loop].getInfo())) continue;
                    doCopy = true;
                    break;
                }
            }
            if (doCopy) {
                if (this.sollParameters[loop].getData() == null) {
                    ParamPlugin.getDefault().getLogger().warning("Parameter " + this.sollParameters[loop].getInfo() + " enth\u00e4lt keine Daten. \u00dcberpr\u00fcfen Sie die Parametrierung der Parametrierung.");
                } else {
                    this.parameters[loop].setDataWithTime(new DataWithTime(this.sollParameters[loop].getData().createModifiableCopy(), this.sollParameters[loop].getZeitpunkt()));
                    this.selectedParameters.add(loop);
                }
            }
            ++loop;
        }
    }

    public List<IParameterFormPageFactory> determineApplicableEditors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("de.bsvrz.buv.plugin.param.editoren");
        IConfigurationElement[] editors = point.getConfigurationElements();
        ArrayList<IParameterFormPageFactory> factories = new ArrayList<IParameterFormPageFactory>();
        IConfigurationElement[] iConfigurationElementArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement editor = iConfigurationElementArray[n2];
            String editorId = editor.getAttribute("editorId");
            if (editorId != null && editorId.equals(ParameterEditor.EDITOR_ID)) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray2 = configurationElements = editor.getChildren("parameterFormPageFactory");
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement page = iConfigurationElementArray2[n4];
                    try {
                        IParameterFormPageFactory factory = (IParameterFormPageFactory)page.createExecutableExtension("class");
                        if (factory.canEdit(this)) {
                            factories.add(factory);
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        ParamPlugin.getDefault().getLogger().error("Fehler beim Auslesen der Erweiterungspunkte f\u00fcr die Parameter-Editoren", (Throwable)e);
                    }
                    catch (CoreException e) {
                        ParamPlugin.getDefault().getLogger().error("Fehler beim Auslesen der Erweiterungspunkte f\u00fcr die Parameter-Editoren", (Throwable)e);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return factories;
    }

    public boolean equals(Object obj) {
        ParameterEditorInput otherInput;
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof ParameterEditorInput && this.parameters.length == (otherInput = (ParameterEditorInput)obj).getParameters().length) {
            HashSet<ParameterInfo> myInfos = new HashSet<ParameterInfo>();
            HashSet<ParameterInfo> otherInfos = new HashSet<ParameterInfo>();
            int loop = 0;
            while (loop < this.parameters.length) {
                myInfos.add(this.parameters[loop].getInfo());
                otherInfos.add(otherInput.getParameters()[loop].getInfo());
                ++loop;
            }
            result = myInfos.equals(otherInfos);
        }
        return result;
    }

    public boolean exists() {
        boolean result = true;
        Parameter[] parameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            if (!p.getObjekt().isValid()) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (AttributeGroup.class.equals((Object)adapter)) {
            return this.parameters[0].getAtg();
        }
        return null;
    }

    public AttributePropagationMode getAttributePropagationMode() {
        return this.attributePropagationMode;
    }

    public int getBestFactory(List<IParameterFormPageFactory> factories) {
        if (factories == null || factories.size() <= 0) {
            return -1;
        }
        int bestFactoryIdx = 0;
        int adequacy = factories.get(bestFactoryIdx).getAdequacy(this);
        int loop = 1;
        while (loop < factories.size()) {
            IParameterFormPageFactory currentFactory = factories.get(loop);
            int currentAadequacy = currentFactory.getAdequacy(this);
            if (currentAadequacy > adequacy) {
                adequacy = currentAadequacy;
                bestFactoryIdx = loop;
            }
            ++loop;
        }
        return bestFactoryIdx;
    }

    public AbstractParamPluginContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Parameter[] getDefaultParameters() {
        return this.defaultParameters;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public InitialDirtyStateMode getInitialDirtyStateMode() {
        return this.initialDirtyStateMode;
    }

    public Parameter[] getIstParameters() {
        return this.istParameters;
    }

    public String getName() {
        return this.parameters[0].getAtg().getName();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public ParameterEditorSaveMode getSaveMode() {
        return this.saveMode;
    }

    public IParameterFormPageFactory getSelectedFactory() {
        return this.selectedFactory;
    }

    public Set<Integer> getSelectedParameters() {
        return this.selectedParameters;
    }

    public String getShortText() {
        StringBuilder b = new StringBuilder("Auswahl aus ");
        b.append(this.parameters.length);
        b.append(" Parametern an Attributgruppe ");
        b.append(this.getName());
        b.append(".\n ");
        int maxCount = 10;
        int loop = 0;
        boolean ellipsis = false;
        Parameter[] parameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            b.append(p.getObjekt().toString());
            b.append("\n ");
            if (++loop > 10) {
                ellipsis = true;
                break;
            }
            ++n2;
        }
        if (ellipsis) {
            b.append(" ...");
        }
        return b.toString();
    }

    public Parameter[] getSollParameters() {
        return this.sollParameters;
    }

    public String getToolTipText() {
        return "Bearbeiten des Parameters '" + this.getName() + "'";
    }

    public Color getVorgabeColor(ParameterInfo info, String pathToPlainAttribute, String value) {
        Color color = null;
        if (pathToPlainAttribute != null && pathToPlainAttribute.length() > 0) {
            Parameter[] vergleichsParameter = new Parameter[4];
            String[] plainValues = new String[4];
            plainValues[0] = value;
            int loop = 0;
            while (loop < this.parameters.length) {
                if (this.parameters[loop].getInfo().equals((Object)info)) {
                    vergleichsParameter[0] = this.parameters[loop];
                    break;
                }
                ++loop;
            }
            if (loop < this.parameters.length) {
                vergleichsParameter[1] = this.sollParameters[loop];
                vergleichsParameter[2] = this.istParameters[loop];
                vergleichsParameter[3] = this.defaultParameters[loop];
                String[] splitPath = pathToPlainAttribute.split("\\.");
                int aspektLoop = 1;
                while (aspektLoop < 4) {
                    Data d = vergleichsParameter[aspektLoop].getData();
                    plainValues[aspektLoop] = null;
                    if (d != null) {
                        loop = 0;
                        while (loop < splitPath.length) {
                            if (d.isList()) {
                                d = d.getItem(splitPath[loop]);
                            } else if (d.isArray()) {
                                Data.Array array = d.asArray();
                                if ("Leer".equals(splitPath[loop])) {
                                    if (array.getLength() <= 0) {
                                        plainValues[aspektLoop] = plainValues[0];
                                        break;
                                    }
                                    d = array.getItem(0);
                                } else {
                                    try {
                                        int index = Integer.parseInt(splitPath[loop]);
                                        if (array.getLength() <= index) break;
                                        d = array.getItem(index);
                                    }
                                    catch (NumberFormatException e) {
                                        DEBUG.warning("Path-Data-Mismatch", (Throwable)e);
                                        break;
                                    }
                                }
                            }
                            if (d.isPlain()) {
                                plainValues[aspektLoop] = ParameterEditorInput.getPlainValueFromPlainData(d);
                                break;
                            }
                            ++loop;
                        }
                    }
                    ++aspektLoop;
                }
                DataValueTextArrayMemberCombinator kombinator = new DataValueTextArrayMemberCombinator(plainValues, true);
                kombinator.run();
                List outputs = kombinator.getOutputs();
                color = COLORS.get(outputs);
            }
        }
        return color;
    }

    public int hashCode() {
        return this.parameters[0].getObjekt().hashCode();
    }

    public void istParameterAbfragen() {
        ParameterInfo[] infos = new ParameterInfo[this.parameters.length];
        int loop = 0;
        while (loop < this.parameters.length) {
            infos[loop] = new ParameterInfo(this.parameters[loop].getObjekt(), this.parameters[loop].getTyp(), this.parameters[loop].getAtg(), this.parameters[loop].getSim());
            ++loop;
        }
        Parameter[] neueIstParameters = ParameterManagerAllgemein.getInstanz().getIstParameter(infos);
        loop = 0;
        while (loop < neueIstParameters.length) {
            this.istParameters[loop] = neueIstParameters[loop];
            ++loop;
        }
    }

    public void selectAll() {
        this.selectedParameters.clear();
        int loop = 0;
        while (loop < this.parameters.length) {
            this.selectedParameters.add(loop);
            ++loop;
        }
    }

    public void selectVorgabeParameterDifferringToSoll() {
        this.selectedParameters.clear();
        int loop = 0;
        while (loop < this.parameters.length) {
            Data sollData;
            Data vorgabeData = this.parameters[loop].getData();
            if (vorgabeData != (sollData = this.sollParameters[loop].getData())) {
                String sollDataString;
                String vorgabeDataString;
                if (vorgabeData != null && sollData == null || vorgabeData == null && sollData != null) {
                    this.selectedParameters.add(loop);
                } else if (vorgabeData != null && sollData != null && !(vorgabeDataString = vorgabeData.toString()).equals(sollDataString = sollData.toString())) {
                    this.selectedParameters.add(loop);
                }
            }
            ++loop;
        }
    }

    public void setAttributePropagationMode(AttributePropagationMode attributePropagationMode) {
        this.attributePropagationMode = attributePropagationMode;
    }

    public void setInitialDirtyStateMode(InitialDirtyStateMode initialDirtyStateMode) {
        this.initialDirtyStateMode = initialDirtyStateMode;
    }

    public void setSaveMode(ParameterEditorSaveMode saveMode) {
        this.saveMode = saveMode;
    }

    public void setSelectedFactory(IParameterFormPageFactory selectedFactory) {
        this.selectedFactory = selectedFactory;
    }

    public void sollParameterAbfragen() throws ParameterClientException {
        ParameterInfo[] infos = new ParameterInfo[this.parameters.length];
        int loop = 0;
        while (loop < this.parameters.length) {
            infos[loop] = new ParameterInfo(this.parameters[loop].getObjekt(), this.parameters[loop].getTyp(), this.parameters[loop].getAtg(), this.parameters[loop].getSim());
            ++loop;
        }
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav());
        Parameter[] neueSollParameters = hierarchie.getParameter(infos);
        Assert.isTrue((neueSollParameters.length == this.sollParameters.length ? 1 : 0) != 0);
        loop = 0;
        while (loop < neueSollParameters.length) {
            this.sollParameters[loop] = neueSollParameters[loop];
            ++loop;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append(", ");
        b.append(this.parameters.length);
        b.append(" Parameter.\n");
        Parameter[] parameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            b.append(p.getInfo().toString());
            ++n2;
        }
        b.append('\n');
        return b.toString();
    }
}

