/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors;

import de.bsvrz.buv.plugin.param.editors.ParameterSaveResultEnum;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.views.ObjektauswahlView;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenSender;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer;
import de.bsvrz.sys.funclib.debug.Debug;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public final class ParameterSaver {
    private static final Debug DEBUG = Debug.getLogger();
    private static String lastError = "";

    public static String buildDefaultUrsache(Parameter[] inputParameter, Parameter[] editedParameters, ParameterSaveUrsache saveUrsache) {
        if (editedParameters == null || editedParameters.length <= 0) {
            return "Keine Parameter zum Speichern ausgew\u00e4hlt!";
        }
        StringBuilder b = new StringBuilder();
        if (ParameterSaveUrsache.KOPIERT.equals((Object)saveUrsache)) {
            b.append("Daten der ");
        }
        b.append("Attributgruppe '");
        b.append(editedParameters[0].getAtg().getName());
        if (ParameterSaveUrsache.KOPIERT.equals((Object)saveUrsache)) {
            if (inputParameter != null && inputParameter.length > 0) {
                b.append("' von Objekt '");
                b.append(inputParameter[0].getObjekt().toString());
            }
            b.append("' auf ");
        } else {
            if (ParameterSaveUrsache.GETAUSCHT.equals((Object)saveUrsache)) {
                b.append("zwischen '");
                if (inputParameter != null && inputParameter.length > 0) {
                    b.append(inputParameter[0].getObjekt().toString());
                    b.append("' und '");
                } else {
                    b.append("einem Objekt");
                }
                b.append(editedParameters[0].getObjekt().toString());
                b.append("' getauscht");
                return b.toString();
            }
            b.append("' an ");
        }
        b.append(editedParameters.length);
        b.append(" Objekt");
        if (editedParameters.length > 1) {
            if (ParameterSaveUrsache.KOPIERT.equals((Object)saveUrsache)) {
                b.append('e');
            } else {
                b.append("en");
            }
        }
        b.append(' ');
        b.append(saveUrsache.toString());
        b.append(":\n ");
        int maxObjects = 3;
        int loop = 0;
        while (loop < Math.min(3, editedParameters.length)) {
            if (loop > 0) {
                b.append(",\n ");
            }
            b.append(editedParameters[loop].getObjekt().toString());
            ++loop;
        }
        if (editedParameters.length > 3) {
            b.append(", ...");
        }
        return b.toString();
    }

    public static synchronized ParameterSaveResultEnum saveParameters(Parameter[] editedParameters, String defaultUrsache) {
        ParameterSaveResultEnum saveResult = ParameterSaveResultEnum.PARAMETER_SAVE_CANCEL;
        Rahmenwerk rahmenwerk = RahmenwerkService.getService().getRahmenWerk();
        if (!rahmenwerk.isOnline()) {
            return ParameterSaveResultEnum.PARAMETER_SAVE_FAILURE;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(shell, new UrlasserInfoDatenSender(){

            public void execute(ClientDavInterface verbindung, UrlasserInfo urlasser) {
            }
        });
        dialog.setInitialBenutzer(rahmenwerk.getBenutzerName());
        dialog.setInitialUrsache(defaultUrsache);
        dialog.setInitialVeranlasser(rahmenwerk.getBenutzerName());
        if (dialog.open() == 0) {
            UrlasserInfo urlasserInfo = dialog.getUrlasserInfo();
            Benutzer benutzer = (Benutzer)RahmenwerkService.getService().getObjektFactory().getModellobjekt(urlasserInfo.getBenutzer());
            if (benutzer == null) {
                throw new IllegalArgumentException("Benutzer " + urlasserInfo.getBenutzer() + " nicht im System vorhanden");
            }
            SystemObject benutzerReferenz = benutzer.getSystemObject();
            Parameter[] parameterArray = editedParameters;
            int n = editedParameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter result = parameterArray[n2];
                Data data = result.getData();
                if (data != null) {
                    Data urlasserItem = data.getItem("Urlasser");
                    urlasserItem.getReferenceValue("BenutzerReferenz").setSystemObject(benutzerReferenz);
                    String ursache = urlasserInfo.getUrsache();
                    if (ursache == null) {
                        ursache = "(keine Angabe)";
                    }
                    urlasserItem.getTextValue("Ursache").setText(ursache);
                    urlasserItem.getTextValue("Veranlasser").setText(urlasserInfo.getVeranlasser());
                    if (!data.isDefined()) {
                        throw new IllegalStateException("Unvollst\u00e4ndiger Parametersatz f\u00fcr Objekt " + result.getObjekt().toString());
                    }
                }
                ++n2;
            }
            try {
                DEBUG.config("Schreibe " + editedParameters.length + " Parameter...");
                MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav()).setParameter(editedParameters);
                saveResult = ParameterSaveResultEnum.PARAMETER_SAVE_SUCCESS;
            }
            catch (ParameterClientException e) {
                ParamPlugin.getDefault().getLogger().error("Fehler beim Versand von Parametern", (Throwable)e);
                saveResult = ParameterSaveResultEnum.PARAMETER_SAVE_FAILURE;
                lastError = e.getLocalizedMessage();
            }
        }
        if (saveResult == ParameterSaveResultEnum.PARAMETER_SAVE_SUCCESS) {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewReferences.length;
            int n3 = 0;
            while (n3 < n) {
                IViewReference viewRef = iViewReferenceArray[n3];
                IViewPart view = viewRef.getView(false);
                if (view instanceof ObjektauswahlView) {
                    ((ObjektauswahlView)view).refresh();
                }
                ++n3;
            }
        }
        return saveResult;
    }

    public static String getLastError() {
        return lastError;
    }

    private ParameterSaver() {
    }

    public static enum ParameterSaveUrsache {
        PARAMETRIERT("parametriert"),
        KOPIERT("kopiert"),
        GELOESCHT("gel\u00f6scht"),
        GETAUSCHT("getauscht");

        private String userFriendlyName;

        private ParameterSaveUrsache(String s) {
            this.userFriendlyName = s;
        }

        public String toString() {
            return this.userFriendlyName;
        }
    }
}

