/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.attribut;

import de.bsvrz.buv.plugin.param.editors.attribut.DoubleAttributeEditor;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DoubleAttributDialog
extends TitleAreaDialog {
    private final DoubleAttributeType typ;
    private final double initialWert;
    private DoubleAttributeEditor editor;

    public DoubleAttributDialog(Shell parentShell, DoubleAttributeType typ, Double initialWert) {
        super(parentShell);
        Assert.isNotNull((Object)typ);
        if (initialWert == null) {
            Double defaultWertLong = null;
            String defaultWertString = typ.getDefaultAttributeValue();
            if (defaultWertString != null) {
                try {
                    defaultWertLong = Double.parseDouble(defaultWertString);
                }
                catch (NumberFormatException e) {
                    defaultWertLong = 0.0;
                }
            }
            if (defaultWertLong == null) {
                defaultWertLong = 0.0;
            }
            this.initialWert = defaultWertLong;
        } else {
            this.initialWert = initialWert;
        }
        this.typ = typ;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Auswahl eines Integer-Wertes oder -Zustands");
        this.setTitle("Wert oder Zustand zuweisen");
        this.setMessage("W\u00e4hlen Sie einen Zustand aus oder setzen Sie einen numerischen Wert");
        Composite panel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(panel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        this.editor = new DoubleAttributeEditor(panel, 2048, true, this.typ);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
        this.editor.setWert(this.initialWert);
        return panel;
    }

    public Double getWert() {
        return this.editor.getWert();
    }

    public String getTextValue() {
        return this.editor.getTextValue();
    }
}

