/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.attribut;

import de.bsvrz.buv.plugin.param.editors.attribut.AbstraktAttributEditor;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import java.util.EventObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DoubleAttributeEditor
extends AbstraktAttributEditor<Double> {
    private Double wert;
    private final Text wertFeld;
    private final byte genauigkeit;
    private String textValue = "0";

    public DoubleAttributeEditor(Composite parent, int stil, boolean editierbar, DoubleAttributeType attributeType) {
        super(parent);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.wert = 0.0;
        this.genauigkeit = attributeType.getAccuracy();
        this.wertFeld = new Text((Composite)this, stil);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.wertFeld);
        this.wertFeld.setEditable(editierbar);
        if (editierbar) {
            this.wertFeld.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    StringBuffer eingabe = new StringBuffer(DoubleAttributeEditor.this.wertFeld.getText().trim());
                    if (event.start == event.end) {
                        eingabe.insert(event.start, event.text);
                    } else {
                        eingabe.replace(event.start, event.end, event.text);
                    }
                    try {
                        double neuerWert = Double.valueOf(eingabe.toString());
                        if (DoubleAttributeEditor.this.genauigkeit == 0 && neuerWert > 3.4028234663852886E38) {
                            throw new NumberFormatException("Die angegebene Zahl " + neuerWert + " \u00fcberschreitet den zul\u00e4ssigen Wertebereich!");
                        }
                    }
                    catch (NumberFormatException e) {
                        event.doit = false;
                    }
                }
            });
            this.wertFeld.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    try {
                        String wertStr = DoubleAttributeEditor.this.wertFeld.getText();
                        DoubleAttributeEditor.this.wert = Double.valueOf(wertStr);
                        DoubleAttributeEditor.this.textValue = wertStr;
                    }
                    catch (NumberFormatException e) {
                        ParamPlugin.getDefault().getLogger().error("Texteingabe nicht in Double konvertierbar", (Throwable)e);
                    }
                }
            });
            this.wertFeld.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DoubleAttributeEditor.this.fireAenderungsListener(new EventObject((Object)DoubleAttributeEditor.this));
                }
            });
        }
    }

    @Override
    public Double getWert() {
        return this.wert;
    }

    @Override
    public void getWert(Data daten) {
        if (this.genauigkeit == 0) {
            daten.asUnscaledValue().set(this.wert.floatValue());
        } else {
            daten.asUnscaledValue().set(this.wert.doubleValue());
        }
    }

    @Override
    public void setWert(Data daten) {
        this.wert = this.genauigkeit == 0 ? Double.valueOf(daten.asUnscaledValue().floatValue()) : Double.valueOf(daten.asUnscaledValue().doubleValue());
        this.wertFeld.setText(Double.toString(this.wert));
    }

    @Override
    public void setWert(Double wert) {
        this.wert = wert;
    }

    public String getTextValue() {
        return this.textValue;
    }
}

