/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.attribut;

import com.bitctrl.math.SkalierungHelper;
import de.bsvrz.buv.plugin.param.editors.attribut.AbstraktAttributEditor;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.SystemObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class IntegerAttributeEditor
extends AbstraktAttributEditor<Long> {
    private Text wertEingabeFeld;
    private ComboViewer selektor;
    private final Map<Long, IntegerValueState> states = new HashMap<Long, IntegerValueState>();
    private final IntegerValueRange range;
    private final int byteCount;
    private double faktor = 1.0;
    private Long wert = 0L;
    private long minimum;
    private long maximum;
    private String textValue = "0";
    private String unit;

    public IntegerAttributeEditor(Composite parent, int stil, boolean editierbar, IntegerAttributeType typ) {
        super(parent);
        String lunit;
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this);
        if (typ.getStates() != null) {
            for (IntegerValueState state : typ.getStates()) {
                this.states.put(state.getValue(), state);
            }
        }
        this.range = typ.getRange();
        this.byteCount = typ.getByteCount();
        if (this.range == null) {
            switch (this.byteCount) {
                case 1: {
                    this.minimum = -128L;
                    this.maximum = 127L;
                    break;
                }
                case 4: {
                    this.minimum = Integer.MIN_VALUE;
                    this.maximum = Integer.MAX_VALUE;
                    break;
                }
                case 2: {
                    this.minimum = -32768L;
                    this.maximum = 32767L;
                    break;
                }
                default: {
                    this.minimum = Long.MIN_VALUE;
                    this.maximum = Long.MAX_VALUE;
                    break;
                }
            }
        } else {
            this.faktor = this.range.getConversionFactor();
            this.minimum = this.range.getMinimum();
            this.maximum = this.range.getMaximum();
            this.unit = this.range.getUnit();
        }
        this.wert = this.minimum;
        if (this.states.isEmpty()) {
            this.wertEingabeFeld = new Text((Composite)this, stil);
            this.wertEingabeFeld.setText("0");
            this.wertEingabeFeld.setLayoutData((Object)new GridData(768));
            this.wertEingabeFeld.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    StringBuffer derText = new StringBuffer(IntegerAttributeEditor.this.wertEingabeFeld.getText());
                    if (event.start == event.end) {
                        derText.insert(event.start, event.text);
                    } else {
                        derText.replace(event.start, event.end, event.text);
                    }
                    event.doit = IntegerAttributeEditor.this.aktualisiereWertVomText(derText.toString());
                    if (event.doit) {
                        IntegerAttributeEditor.this.fireAenderungsListener(new EventObject((Object)IntegerAttributeEditor.this));
                    }
                }
            });
        } else {
            CCombo combo = new CCombo((Composite)this, stil);
            combo.setVisibleItemCount(10);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)combo);
            this.selektor = new ComboViewer(combo);
            this.selektor.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.selektor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof SystemObject) {
                        return ((SystemObject)element).getNameOrPidOrId();
                    }
                    return super.getText(element);
                }
            });
            ArrayList<IntegerValueState> statusWerte = new ArrayList<IntegerValueState>(this.states.values());
            this.selektor.setInput(statusWerte);
            this.selektor.setSelection((ISelection)new StructuredSelection(statusWerte.get(0)));
            this.selektor.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    long alterWert = IntegerAttributeEditor.this.wert;
                    Object element = ((IStructuredSelection)IntegerAttributeEditor.this.selektor.getSelection()).getFirstElement();
                    if (element instanceof IntegerValueState) {
                        IntegerAttributeEditor.this.wert = ((IntegerValueState)element).getValue();
                    } else {
                        IntegerAttributeEditor.this.aktualisiereWertVomText(IntegerAttributeEditor.this.selektor.getCCombo().getText().trim());
                    }
                    if (IntegerAttributeEditor.this.wert != alterWert) {
                        IntegerAttributeEditor.this.aktualisiereWert();
                        IntegerAttributeEditor.this.fireAenderungsListener(new EventObject((Object)IntegerAttributeEditor.this));
                    }
                }
            });
            this.selektor.getCCombo().addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    StringBuffer derText = new StringBuffer(IntegerAttributeEditor.this.selektor.getCCombo().getText());
                    if (event.start == event.end) {
                        derText.insert(event.start, event.text);
                    } else {
                        derText.replace(event.start, event.end, event.text);
                    }
                    event.doit = IntegerAttributeEditor.this.aktualisiereWertVomText(derText.toString());
                    if (event.doit) {
                        IntegerAttributeEditor.this.fireAenderungsListener(new EventObject(this));
                    }
                }
            });
            this.selektor.getCCombo().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    IntegerAttributeEditor.this.aktualisiereWertVomText(IntegerAttributeEditor.this.selektor.getCCombo().getText().trim());
                    IntegerAttributeEditor.this.fireAenderungsListener(new EventObject((Object)IntegerAttributeEditor.this));
                }
            });
            if (this.range == null && !this.states.isEmpty()) {
                combo.setEditable(false);
            }
            this.selektor.getControl().setEnabled(editierbar);
        }
        if (this.range != null && (lunit = this.range.getUnit()) != null && lunit.length() > 0) {
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(lunit);
            GridDataFactory.swtDefaults().applyTo((Control)unitLabel);
        }
    }

    private void aktualisiereWert() {
        this.setzeAusgabestatus(false);
        if (this.wertEingabeFeld != null) {
            if (this.faktor == 1.0) {
                this.wertEingabeFeld.setText(Long.toString(this.wert));
            } else {
                this.wertEingabeFeld.setText(SkalierungHelper.getInstanz().format(this.wert.doubleValue(), this.faktor));
            }
        } else if (this.selektor != null) {
            IntegerValueState status = this.states.get(this.wert);
            if (status == null) {
                if (this.faktor == 1.0) {
                    this.selektor.getCCombo().setText(Long.toString(this.wert));
                } else {
                    this.selektor.getCCombo().setText(SkalierungHelper.getInstanz().format(this.wert.doubleValue(), this.faktor));
                }
            } else {
                this.selektor.setSelection((ISelection)new StructuredSelection((Object)status));
            }
        }
        this.setzeAusgabestatus(true);
    }

    private boolean aktualisiereWertVomText(String text) {
        double neuerWert = 0.0;
        boolean wertGesetzt = false;
        boolean result = true;
        for (IntegerValueState state : this.states.values()) {
            if (!state.getName().equals(text)) continue;
            this.wert = state.getValue();
            this.textValue = state.getName();
            wertGesetzt = true;
            break;
        }
        if (!wertGesetzt) {
            try {
                neuerWert = Long.valueOf(text).doubleValue();
            }
            catch (NumberFormatException e) {
                try {
                    neuerWert = Double.valueOf(text);
                }
                catch (NumberFormatException e1) {
                    result = false;
                }
            }
            if (result) {
                Double skaliert = neuerWert / this.faktor;
                if (skaliert.longValue() < this.minimum || skaliert.longValue() > this.maximum) {
                    result = false;
                } else {
                    this.wert = Math.round(skaliert);
                    IntegerValueState state = this.states.get(this.wert);
                    if (state == null) {
                        this.textValue = String.valueOf(neuerWert);
                        if (this.unit != null) {
                            this.textValue = String.valueOf(this.textValue) + " " + this.unit;
                        }
                    } else {
                        this.textValue = state.getName();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Long getWert() {
        return this.wert;
    }

    @Override
    public void getWert(Data daten) {
        switch (this.byteCount) {
            case 1: {
                daten.asUnscaledValue().set((int)this.wert.byteValue());
                break;
            }
            case 4: {
                daten.asUnscaledValue().set(this.wert.intValue());
                break;
            }
            case 2: {
                daten.asUnscaledValue().set((int)this.wert.shortValue());
                break;
            }
            default: {
                daten.asUnscaledValue().set(this.wert.longValue());
            }
        }
    }

    @Override
    public void setWert(Data daten) {
        long alterWert = this.wert;
        switch (this.byteCount) {
            case 1: {
                this.wert = daten.asUnscaledValue().byteValue();
                break;
            }
            case 4: {
                this.wert = daten.asUnscaledValue().intValue();
                break;
            }
            case 2: {
                this.wert = daten.asUnscaledValue().shortValue();
                break;
            }
            default: {
                this.wert = daten.asUnscaledValue().longValue();
            }
        }
        this.textValue = daten.valueToString();
        if (this.wert != alterWert) {
            this.aktualisiereWert();
        }
    }

    @Override
    public void setWert(Long wert) {
        long alterWert = this.wert;
        this.wert = wert;
        if (wert != alterWert) {
            this.aktualisiereWert();
        }
    }

    public String getTextValue() {
        return this.textValue;
    }
}

