/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.attribut;

import de.bsvrz.buv.plugin.param.editors.attribut.AbstraktAttributEditor;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import java.util.EventObject;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextAttributeEditor
extends AbstraktAttributEditor<String> {
    private final Text textFeld;
    private String text = "";
    private final int maximaleLaenge;

    public TextAttributeEditor(Composite parent, int stil, boolean editierbar, StringAttributeType typ) {
        super(parent);
        this.maximaleLaenge = typ.getMaxLength();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this.textFeld = new Text((Composite)this, stil);
        this.textFeld.setText("");
        this.textFeld.setLayoutData((Object)new GridData(768));
        this.textFeld.setEditable(editierbar);
        if (editierbar) {
            this.textFeld.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    StringBuffer derText = new StringBuffer(TextAttributeEditor.this.textFeld.getText());
                    if (event.start == event.end) {
                        derText.insert(event.start, event.text);
                    } else {
                        derText.replace(event.start, event.end, event.text);
                    }
                    if (TextAttributeEditor.this.maximaleLaenge > 0 && derText.length() > TextAttributeEditor.this.maximaleLaenge) {
                        event.doit = false;
                    }
                    if (event.doit) {
                        TextAttributeEditor.this.text = derText.toString();
                    }
                }
            });
            this.textFeld.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    TextAttributeEditor.this.fireAenderungsListener(new EventObject((Object)TextAttributeEditor.this));
                }
            });
        }
    }

    @Override
    public String getWert() {
        return this.text;
    }

    @Override
    public void getWert(Data daten) {
        daten.asTextValue().setText(this.text);
    }

    @Override
    public void setWert(Data daten) {
        this.text = daten.asTextValue().getText();
        this.textFeld.setText(this.text);
    }

    @Override
    public void setWert(String wert) {
        this.text = wert;
    }
}

