/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArrayObjectTransformer {
    private Data data;
    private Data.Array array;

    public ArrayObjectTransformer() {
    }

    public ArrayObjectTransformer(Data data) {
        this.setData(data);
    }

    private int getProperIntValue(Data valData) {
        int min = 0;
        AttributeType att = valData.getAttributeType();
        IntegerValueRange ivr = ((IntegerAttributeType)att).getRange();
        if (ivr != null) {
            min = (int)ivr.getMinimum();
        } else {
            List ivStates = ((IntegerAttributeType)att).getStates();
            if (ivStates != null && ivStates.size() > 0) {
                IntegerValueState state = (IntegerValueState)ivStates.get(0);
                min = (int)state.getValue();
            }
        }
        return min;
    }

    public Data addLineAbove(int location) {
        if (this.data == null) {
            return null;
        }
        if (this.array.getLength() + 1 > this.array.getMaxCount() && this.array.getMaxCount() != 0) {
            return null;
        }
        this.array.setLength(this.array.getLength() + 1);
        int i = this.array.getLength() - 1;
        while (i >= (location == 0 ? location + 1 : location)) {
            this.copyData(this.array.getItem(i - 1), this.array.getItem(i));
            --i;
        }
        this.copyData(null, this.array.getItem(location));
        return this.data;
    }

    public Data addLineBelow(int location) {
        if (this.data == null) {
            return null;
        }
        if (this.array.getLength() + 1 > this.array.getMaxCount() && this.array.getMaxCount() != 0) {
            return null;
        }
        this.array.setLength(this.array.getLength() + 1);
        int i = this.array.getLength() - 1;
        while (i > location) {
            this.copyData(this.array.getItem(i - 1), this.array.getItem(i));
            --i;
        }
        this.copyData(null, this.array.getItem(location + 1));
        return this.data;
    }

    public Data addLinesEnd(int size) {
        if (this.data == null) {
            return null;
        }
        if (this.array.getLength() + size > this.array.getMaxCount() && this.array.getMaxCount() != 0) {
            return null;
        }
        int len = this.array.getLength();
        this.array.setLength(this.array.getLength() + size);
        int i = len;
        while (i < this.array.getLength()) {
            this.copyData(null, this.array.getItem(i));
            ++i;
        }
        return this.data;
    }

    public Data addLinesBegin(int size) {
        if (this.data == null) {
            return null;
        }
        if (this.array.getLength() + size > this.array.getMaxCount() && this.array.getMaxCount() != 0) {
            return null;
        }
        int len = this.array.getLength();
        this.array.setLength(this.array.getLength() + size);
        if (len == 0) {
            this.copyData(null, this.array.getItem(0));
            return this.data;
        }
        int i = len - 1;
        while (i >= 0) {
            this.copyData(this.array.getItem(i), this.array.getItem(i + size));
            --i;
        }
        i = 0;
        while (i < size) {
            this.copyData(null, this.array.getItem(i));
            ++i;
        }
        return this.data;
    }

    public Data removeAllLines() {
        if (this.array == null) {
            return null;
        }
        this.array.setLength(0);
        return this.data;
    }

    public Data removeSingleLine(int location) {
        if (this.data == null) {
            return null;
        }
        int i = location + 1;
        while (i < this.array.getLength()) {
            this.copyData(this.array.getItem(i), this.array.getItem(i - 1));
            ++i;
        }
        this.array.setLength(this.array.getLength() - 1);
        return this.data;
    }

    public Data getTransformedData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
        if (data != null) {
            this.array = data.asArray();
        }
    }

    private void copyData(Data data1, Data data2) {
        if (data2.isArray()) {
            this.copyArrayData(data1 == null ? null : data1.asArray(), data2.asArray());
        } else if (data2.isList()) {
            this.copyAttributListData(data1, data2);
        } else if (data2.getAttributeType() instanceof StringAttributeType) {
            this.copyTextData(data1, data2);
        } else if (data2.getAttributeType() instanceof IntegerAttributeType) {
            this.copyIntegerData(data1 == null ? null : data1, data2);
        } else if (data2.getAttributeType() instanceof DoubleAttributeType) {
            this.copyDoubleData(data1 == null ? null : data1.asUnscaledValue(), data2.asUnscaledValue());
        } else if (data2.getAttributeType() instanceof TimeAttributeType) {
            this.copyTimeData(data1 == null ? null : data1.asTimeValue(), data2.asTimeValue());
        } else if (data2.getAttributeType() instanceof ReferenceAttributeType) {
            this.copyReferenceData(data1 == null ? null : data1.asReferenceValue(), data2.asReferenceValue());
        } else {
            Logger.getLogger(ArrayObjectTransformer.class.getName()).log(Level.INFO, "Fehler in ArrayObjectTransformer");
        }
    }

    private void copyAttributListData(Data data1, Data data2) {
        if (data1 == null) {
            Iterator it2 = data2.iterator();
            while (it2.hasNext()) {
                this.copyData(null, (Data)it2.next());
            }
        } else {
            Iterator it1 = data1.iterator();
            Iterator it2 = data2.iterator();
            while (it1.hasNext()) {
                this.copyData((Data)it1.next(), (Data)it2.next());
            }
        }
    }

    private void copyIntegerData(Data d1, Data d2) {
        Data.NumberValue data1 = null;
        Data.NumberValue data2 = null;
        if (d1 != null) {
            data1 = d1.asUnscaledValue();
        }
        if (d2 != null) {
            data2 = d2.asUnscaledValue();
        }
        if (data2 != null) {
            if (data1 == null) {
                if (!data2.isState()) {
                    int i = this.getProperIntValue(d2);
                    data2.set(i);
                }
            } else {
                try {
                    if (data1.isState()) {
                        data2.setState(data1.getState());
                    } else {
                        data2.set(data1.longValue());
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (!data2.isState()) {
                        data2.set(this.getProperIntValue(d2));
                    }
                    ParamPlugin.getDefault().getLogger().warning("Konvertierungsproblem in DAF-API#1704", (Throwable)e);
                }
            }
        }
    }

    private void copyDoubleData(Data.NumberValue data1, Data.NumberValue data2) {
        if (data1 == null) {
            data2.set(0);
        } else {
            data2.set(data1.doubleValue());
            data2.set(data1.floatValue());
        }
    }

    private void copyTextData(Data data1, Data data2) {
        if (data1 == null) {
            StringAttributeType strAttrType = (StringAttributeType)data2.getAttributeType();
            String defaultValue = strAttrType.getDefaultAttributeValue();
            if (defaultValue == null) {
                defaultValue = "";
            }
            data2.asTextValue().setText(defaultValue);
        } else {
            data2.asTextValue().setText(data1.asTextValue().getText());
        }
    }

    private void copyArrayData(Data.Array data1, Data.Array data2) {
        if (data1 == null) {
            data2.setLength(0);
        } else {
            data2.setLength(data1.getLength());
            int i = 0;
            while (i < data1.getLength()) {
                this.copyData(data1.getItem(i), data2.getItem(i));
                ++i;
            }
        }
    }

    private void copyTimeData(Data.TimeValue data1, Data.TimeValue data2) {
        if (data1 == null) {
            data2.setMillis(0L);
            data2.setSeconds(0L);
        } else {
            data2.setMillis(data1.getMillis());
            data2.setSeconds(data1.getSeconds());
            data2.setText(data1.getText());
        }
    }

    private void copyReferenceData(Data.ReferenceValue data1, Data.ReferenceValue data2) {
        if (data1 == null) {
            return;
        }
        data2.setSystemObject(data1.getSystemObject());
        data2.setText(data1.getText());
    }
}

