/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.editors.helper.IDCounter;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.List;

public class MyTreeObject
implements Comparable<MyTreeObject> {
    private static final Debug DEBUG = Debug.getLogger();
    private MyTreeObject root;
    private Object attribute;
    private Object data;
    private Object originalValue;
    private final List<MyTreeObject> children = new ArrayList<MyTreeObject>();
    private final long id;

    public MyTreeObject() {
        this.id = IDCounter.getId();
    }

    public MyTreeObject(Object attribute, Object data) {
        this.attribute = attribute;
        this.data = data;
        if (data instanceof Data && ((Data)data).isPlain()) {
            AttributeType attributeType = ((Data)data).getAttributeType();
            if (attributeType instanceof IntegerAttributeType) {
                this.originalValue = ((Data)data).asUnscaledValue().longValue();
            } else if (attributeType instanceof DoubleAttributeType) {
                this.originalValue = ((Data)data).asUnscaledValue().doubleValue();
            } else if (attributeType instanceof StringAttributeType) {
                this.originalValue = ((Data)data).asTextValue().getText();
            } else if (attributeType instanceof TimeAttributeType) {
                this.originalValue = ((Data)data).asTimeValue().getMillis();
            } else if (attributeType instanceof ReferenceAttributeType) {
                this.originalValue = ((Data)data).asReferenceValue().getSystemObject();
            }
        }
        this.id = IDCounter.getId();
        DEBUG.finer("Neues " + this.getClass().getSimpleName() + "-Objekt erzeugt", (Object)this);
    }

    public void add(MyTreeObject child) {
        this.children.add(child);
        child.setRoot(this);
    }

    public List<MyTreeObject> getChildren() {
        return this.children;
    }

    public void setRoot(MyTreeObject root) {
        this.root = root;
    }

    public MyTreeObject getRoot() {
        return this.root;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setAttribute(Object attribute) {
        this.attribute = attribute;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void showTree(int nest) {
        if (this.hasChildren()) {
            for (MyTreeObject obj : this.getChildren()) {
                obj.showTree(nest + 1);
            }
        }
    }

    public String getFullPath() {
        String path = "";
        if (this.getData() instanceof Data) {
            path = ((Data)this.getData()).getName();
            MyTreeObject rootTreeObject = this.getRoot();
            while (rootTreeObject != null && rootTreeObject.getData() instanceof Data) {
                Data rootData = (Data)rootTreeObject.getData();
                path = String.valueOf(rootData.getName()) + '.' + path;
                rootTreeObject = rootTreeObject.getRoot();
            }
        }
        return path;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("MyTreeObject Id=");
        b.append(this.id);
        b.append(", Attribut: ");
        if (this.attribute != null) {
            b.append(this.attribute.toString());
            b.append(" (Typ: ");
            if (this.data instanceof Data) {
                b.append(((Data)this.data).getAttributeType().toString());
            } else {
                b.append(this.attribute.getClass().getName());
            }
            b.append(")");
        } else {
            b.append("unbekannt");
        }
        b.append(", Aktuelle Daten: ");
        if (this.data != null) {
            b.append(this.data.toString());
        } else {
            b.append("Keine");
        }
        b.append(", Originale Daten: ");
        if (this.originalValue != null) {
            b.append(this.originalValue.toString());
        } else {
            b.append("Keine");
        }
        return b.toString();
    }

    public Object getOriginalValue() {
        return this.originalValue;
    }

    public boolean isDirty() {
        boolean result;
        block10: {
            block11: {
                result = false;
                if (!(this.data instanceof Data)) break block10;
                Data currentData = (Data)this.data;
                if (!currentData.isPlain() || this.getOriginalValue() == null) break block11;
                Object currentValue = null;
                AttributeType attributeType = currentData.getAttributeType();
                if (attributeType instanceof IntegerAttributeType) {
                    currentValue = currentData.asUnscaledValue().longValue();
                } else if (attributeType instanceof DoubleAttributeType) {
                    currentValue = currentData.asUnscaledValue().doubleValue();
                } else if (attributeType instanceof StringAttributeType) {
                    currentValue = currentData.asTextValue().getText();
                } else if (attributeType instanceof TimeAttributeType) {
                    currentValue = currentData.asTimeValue().getMillis();
                } else if (attributeType instanceof ReferenceAttributeType) {
                    currentValue = currentData.asReferenceValue().getSystemObject();
                }
                if (currentValue != null && this.getOriginalValue().equals(currentValue)) break block10;
                result = true;
                break block10;
            }
            for (MyTreeObject child : this.getChildren()) {
                if (!child.isDirty()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void commit() {
        if (this.data instanceof Data && ((Data)this.data).isPlain()) {
            AttributeType attributeType = ((Data)this.data).getAttributeType();
            if (attributeType instanceof IntegerAttributeType) {
                this.originalValue = ((Data)this.data).asUnscaledValue().longValue();
            } else if (attributeType instanceof DoubleAttributeType) {
                this.originalValue = ((Data)this.data).asUnscaledValue().doubleValue();
            } else if (attributeType instanceof StringAttributeType) {
                this.originalValue = ((Data)this.data).asTextValue().getText();
            } else if (attributeType instanceof TimeAttributeType) {
                this.originalValue = ((Data)this.data).asTimeValue().getMillis();
            } else if (attributeType instanceof ReferenceAttributeType) {
                this.originalValue = ((Data)this.data).asReferenceValue().getSystemObject();
            }
        }
        for (MyTreeObject child : this.getChildren()) {
            child.commit();
        }
    }

    public void revert() {
        if (this.data instanceof Data && ((Data)this.data).isPlain() && this.originalValue != null) {
            AttributeType attributeType = ((Data)this.data).getAttributeType();
            if (attributeType instanceof IntegerAttributeType) {
                ((Data)this.data).asUnscaledValue().set(((Long)this.originalValue).longValue());
            } else if (attributeType instanceof DoubleAttributeType) {
                ((Data)this.data).asUnscaledValue().set(((Double)this.originalValue).doubleValue());
            } else if (attributeType instanceof StringAttributeType) {
                ((Data)this.data).asTextValue().setText(String.valueOf(this.originalValue));
            } else if (attributeType instanceof TimeAttributeType) {
                ((Data)this.data).asTimeValue().setMillis(((Long)this.originalValue).longValue());
            } else if (attributeType instanceof ReferenceAttributeType) {
                ((Data)this.data).asReferenceValue().setSystemObject((SystemObject)this.originalValue);
            }
        }
        for (MyTreeObject child : this.getChildren()) {
            child.revert();
        }
    }

    @Override
    public int compareTo(MyTreeObject o) {
        int result = 0;
        if (this.data instanceof Data && o != null && o.getData() instanceof Data) {
            Data currentData = (Data)this.data;
            Data otherData = (Data)o.getData();
            if (currentData.isPlain() && otherData.isPlain()) {
                Object currentValue = null;
                Object otherValue = null;
                AttributeType attributeType = currentData.getAttributeType();
                if (attributeType instanceof IntegerAttributeType) {
                    currentValue = currentData.asUnscaledValue().longValue();
                    otherValue = otherData.asUnscaledValue().longValue();
                } else if (attributeType instanceof DoubleAttributeType) {
                    currentValue = new Double(currentData.asUnscaledValue().doubleValue());
                    otherValue = otherData.asUnscaledValue().doubleValue();
                } else if (attributeType instanceof StringAttributeType) {
                    currentValue = currentData.asTextValue().getText();
                    otherValue = otherData.asTextValue().getText();
                } else if (attributeType instanceof TimeAttributeType) {
                    currentValue = currentData.asTimeValue().getMillis();
                    otherValue = otherData.asTimeValue().getMillis();
                } else if (attributeType instanceof ReferenceAttributeType) {
                    currentValue = currentData.asReferenceValue().getSystemObject();
                    otherValue = otherData.asReferenceValue().getSystemObject();
                }
                if (currentValue == null || !currentValue.equals(otherValue)) {
                    result = 1;
                }
            }
        }
        return result;
    }

    public long getId() {
        return this.id;
    }
}

