/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.editors.helper.ArrayObjectTransformer;
import de.bsvrz.buv.plugin.param.editors.helper.DecoratableString;
import de.bsvrz.buv.plugin.param.editors.helper.ExpandState;
import de.bsvrz.buv.plugin.param.editors.helper.HeadLineMouseAdapter;
import de.bsvrz.buv.plugin.param.editors.helper.IParaEditCompositeContainer;
import de.bsvrz.buv.plugin.param.editors.helper.MyDataObject;
import de.bsvrz.buv.plugin.param.editors.helper.MyTreeObject;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditCompositeDoubleClickListener;
import de.bsvrz.buv.plugin.param.editors.helper.PureComboBoxSelector;
import de.bsvrz.buv.plugin.param.editors.helper.TableSelectionAction;
import de.bsvrz.buv.plugin.param.editors.helper.TableTreeContentProvider;
import de.bsvrz.buv.plugin.param.editors.helper.TableTreeLabelProvider;
import de.bsvrz.buv.plugin.param.editors.helper.TextModifier;
import de.bsvrz.buv.plugin.param.editors.helper.UzVerifyListener;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectComparatorAlphabetical;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeListDefinition;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.ParameterManager;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class ParaEditComposite {
    private static final Debug DEBUG = Debug.getLogger();
    private static final int MAX_LEN_URSACHE_TEXT = 100;
    private String errorMessage;
    private MyTreeObject dataObject;
    private MyDataObject mediatorDataObject;
    private final MyTreeObject[] shadowDataObjects;
    private final Map<MyTreeObject, MyTreeObject[]> shadowDataObjectMap = new LinkedHashMap<MyTreeObject, MyTreeObject[]>();
    private final Parameter[] parameters;
    private TableSelectionListener currentTL;
    private final List<Integer> newItems = new ArrayList<Integer>();
    private static Color alertColor;
    private static Color messageColor;
    private Label infoLine;
    private Label headLine;
    private final String[] properties;
    private TreeViewer treeViewer;
    private Tree tree;
    private MenuManager contextMenuManager;
    private MenuManager lineAdd;
    private MenuManager addOne;
    private MenuManager addMore;
    private TextCellEditor doubleEdit;
    private TextCellEditor refEdit;
    private TextCellEditor integerEdit;
    private TextCellEditor stringEdit;
    private TextCellEditor timeEdit;
    private ComboBoxCellEditor stateEdit;
    private final CellEditor[] editors;
    private AddRowAction lineAddAbove;
    private AddRowAction lineAddBelow;
    private LineRemoveAction lineRemove;
    private AddRowAction arrayAddOneLast;
    private AddRowAction arrayAddOneFirst;
    private AddRowAction arrayAddMoreLast;
    private AddRowAction arrayAddMoreFirst;
    private RemoveAllAction arrayRemoveAll;
    private ExpandState treeState;
    private final TextModifier textModifier;
    private final StateModifier stateModifier = new StateModifier();
    private final ReferenceModifier referenceModifier = new ReferenceModifier();
    private final SystemObjectComparatorAlphabetical systemObjectComparator = new SystemObjectComparatorAlphabetical(true);
    private final DecoratableString additionalText;
    private Label additionalTextLabel;
    private final Composite sectionClient;
    private final FormToolkit toolkit;
    private boolean dirty;
    private final IParaEditCompositeContainer container;
    private AbstractFormPart formPart;
    private final ParameterInfo[] patameterInfos;
    private DataWithTime workingCopy;
    private final boolean readOnly;

    public ParaEditComposite(FormToolkit toolkit, Section sektion, Parameter[] parameters, DecoratableString additionalText, IParaEditCompositeContainer container, boolean readOnly) {
        this.readOnly = readOnly;
        this.toolkit = toolkit;
        this.container = container;
        this.sectionClient = toolkit.createComposite((Composite)sektion);
        this.sectionClient.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(16384, 128, true, false);
        gd.heightHint = this.calculateOptimalHeight();
        this.sectionClient.setLayoutData((Object)gd);
        this.additionalText = additionalText;
        ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
        Data data = parameters[0].getData() == null ? davIf.createData(parameters[0].getAtg()) : (this.isReadOnly() ? parameters[0].getData() : parameters[0].getData().createModifiableCopy());
        this.workingCopy = new DataWithTime(data, System.currentTimeMillis());
        this.parameters = parameters;
        this.patameterInfos = new ParameterInfo[this.parameters.length];
        int infoLoop = 0;
        while (infoLoop < this.parameters.length) {
            this.patameterInfos[infoLoop] = new ParameterInfo(this.parameters[infoLoop].getObjekt(), this.parameters[infoLoop].getTyp(), this.parameters[infoLoop].getAtg(), this.parameters[infoLoop].getSim());
            ++infoLoop;
        }
        this.editors = new CellEditor[1 + parameters.length];
        ArrayList<String> columnPropertiesList = new ArrayList<String>();
        columnPropertiesList.add("Attribut");
        if (this.parameters.length > 1) {
            columnPropertiesList.add("Vorgabe");
            columnPropertiesList.add("Soll");
        } else {
            columnPropertiesList.add("Wert");
        }
        this.properties = columnPropertiesList.toArray(new String[columnPropertiesList.size()]);
        this.textModifier = new TextModifier(this, this.properties[0]);
        this.shadowDataObjects = new MyTreeObject[this.parameters.length - 1];
        this.createPartControl();
        this.showData(this.parameters, false);
        sektion.setClient((Control)this.sectionClient);
    }

    int innerCheck(MyTreeObject root) {
        if (root == null) {
            return 0;
        }
        if (root.hasChildren()) {
            int dummy = 0;
            for (MyTreeObject treeObj : root.getChildren()) {
                dummy += this.innerCheck(treeObj);
            }
            return dummy;
        }
        Data data = (Data)root.getData();
        if (data.valueToString().contains("<<null>>")) {
            return 1;
        }
        return 0;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isReadyForFinish() {
        return this.innerCheck(this.dataObject) == 0;
    }

    public boolean isReadyForNext() {
        return this.innerCheck(this.dataObject) > 0;
    }

    int getLocation(MyTreeObject myTreeObject) {
        MyTreeObject root = myTreeObject.getRoot();
        int i = 0;
        for (MyTreeObject obj : root.getChildren()) {
            if (obj.getId() == myTreeObject.getId()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createContextMenu() {
        this.lineAddAbove = new AddRowAction("\u00fcber diesem Element", 0);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.lineAddAbove);
        this.lineAddBelow = new AddRowAction("unter diesem Element", 1);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.lineAddBelow);
        this.lineRemove = new LineRemoveAction("dieses Element l\u00f6schen");
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.lineRemove);
        this.arrayAddOneLast = new AddRowAction("am Ende des Feldes", 2);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.arrayAddOneLast);
        this.arrayAddOneFirst = new AddRowAction("am Anfang des Feldes", 4);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.arrayAddOneFirst);
        this.arrayAddMoreLast = new AddRowAction("am Ende des Feldes", 8);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.arrayAddMoreLast);
        this.arrayAddMoreFirst = new AddRowAction("am Anfang des Feldes", 16);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.arrayAddMoreFirst);
        this.arrayRemoveAll = new RemoveAllAction("alle Elemente l\u00f6schen");
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.arrayRemoveAll);
        this.lineAdd = new MenuManager("Element einf\u00fcgen");
        this.addOne = new MenuManager("ein Element einf\u00fcgen");
        this.addMore = new MenuManager("mehrere Elemente einf\u00fcgen");
        this.lineAdd.add((IAction)this.lineAddAbove);
        this.lineAdd.add((IAction)this.lineAddBelow);
        this.addOne.add((IAction)this.arrayAddOneFirst);
        this.addOne.add((IAction)this.arrayAddOneLast);
        this.addMore.add((IAction)this.arrayAddMoreFirst);
        this.addMore.add((IAction)this.arrayAddMoreLast);
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ParaEditComposite.this.fillContextMenu(mgr);
            }
        });
        Menu menu = this.contextMenuManager.createContextMenu(this.treeViewer.getControl());
        this.tree.setMenu(menu);
    }

    void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof MyTreeObject)) {
            return;
        }
        MyTreeObject myTreeObject = (MyTreeObject)selectedObject;
        if (myTreeObject.getData() instanceof Data) {
            Data data = (Data)myTreeObject.getData();
            boolean filled = false;
            if (data.isArray()) {
                this.contextMenuManager.add((IContributionItem)this.addOne);
                this.contextMenuManager.add((IAction)this.arrayRemoveAll);
                filled = true;
            } else {
                if (myTreeObject.getRoot() == null) {
                    return;
                }
                data = (Data)(myTreeObject = myTreeObject.getRoot()).getData();
                if (data != null && data.isArray()) {
                    this.contextMenuManager.add((IContributionItem)this.lineAdd);
                    this.contextMenuManager.add((IAction)this.lineRemove);
                    filled = true;
                }
            }
            mgr.setVisible(filled);
        }
    }

    public int calculateOptimalHeight() {
        int heightHint = 400;
        if (this.mediatorDataObject != null) {
            int systemFontHeight = this.treeViewer.getTree().getDisplay().getSystemFont().getFontData()[0].getHeight();
            int numNodes = this.mediatorDataObject.getFlatList().size();
            heightHint = Math.min(400, (2 + numNodes) * 2 * systemFontHeight);
            heightHint = Math.max(80, heightHint);
            DEBUG.finer("numNodes=" + numNodes + ", heightHint=" + heightHint);
        }
        return heightHint;
    }

    private void resizeControl() {
        int heightHint;
        GridData gd = (GridData)this.tree.getLayoutData();
        gd.heightHint = heightHint = this.calculateOptimalHeight();
        gd = (GridData)this.sectionClient.getLayoutData();
        gd.heightHint = heightHint;
        SharedScrolledComposite f = null;
        Composite currentParent = this.sectionClient.getParent();
        while (currentParent != null && !(currentParent instanceof SharedScrolledComposite)) {
            currentParent = currentParent.getParent();
        }
        if (currentParent != null) {
            f = (SharedScrolledComposite)currentParent;
            f.reflow(true);
        } else {
            this.sectionClient.getParent().layout();
        }
    }

    private void initEditors() {
        if (this.doubleEdit != null) {
            this.doubleEdit.dispose();
        }
        this.doubleEdit = new TextCellEditor((Composite)this.tree);
        ((Text)this.doubleEdit.getControl()).addVerifyListener((VerifyListener)new UzVerifyListener(2));
        if (this.integerEdit != null) {
            this.integerEdit.dispose();
        }
        this.integerEdit = new TextCellEditor((Composite)this.tree);
        ((Text)this.integerEdit.getControl()).addVerifyListener((VerifyListener)new UzVerifyListener(2));
        if (this.timeEdit != null) {
            this.timeEdit.dispose();
        }
        this.timeEdit = new TextCellEditor((Composite)this.tree);
        ((Text)this.timeEdit.getControl()).addVerifyListener((VerifyListener)new UzVerifyListener(4));
        if (this.stringEdit != null) {
            this.stringEdit.dispose();
        }
        this.stringEdit = new TextCellEditor((Composite)this.tree);
        if (this.refEdit != null) {
            this.refEdit.dispose();
        }
        this.refEdit = new TextCellEditor((Composite)this.tree);
        if (this.stateEdit != null) {
            this.stateEdit.dispose();
        }
        this.stateEdit = new PureComboBoxSelector(this.tree);
    }

    public void setDoubleEditor(Data data) {
        String info = "DoubleAttributeType";
        if (data.isArray()) {
            info = String.valueOf(info) + " - Array";
        }
        this.initEditors();
        this.editors[1] = this.doubleEdit;
        if (!this.isReadOnly()) {
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.textModifier);
        }
        this.doAdvice(info, 1);
    }

    public void setIntegerEditor(IntegerAttributeType attType, Data data) {
        this.initEditors();
        if (!this.isReadOnly()) {
            this.editors[1] = this.integerEdit;
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.textModifier);
        }
        this.doAdvice(TableTreeLabelProvider.getIntegerInfo(attType, data), 1);
    }

    public void setStringEditor(StringAttributeType attType, Data data) {
        this.initEditors();
        if (attType.isLengthLimited()) {
            ((Text)this.stringEdit.getControl()).setTextLimit(attType.getMaxLength());
        }
        if (!this.isReadOnly()) {
            this.editors[1] = null;
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.textModifier);
        }
        this.doAdvice(TableTreeLabelProvider.getStringInfo(attType, data), 1);
    }

    public void setTimeEditor(TimeAttributeType attType, Data data) {
        String info = TableTreeLabelProvider.getTimeInfo(attType, data);
        this.initEditors();
        info = String.valueOf(info) + " - Doppelklick zum \u00d6ffnen des Eingabedialogs";
        if (!this.isReadOnly()) {
            this.editors[1] = null;
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.textModifier);
        }
        this.doAdvice(info, 1);
    }

    public void setReferenceEditor(ReferenceAttributeType attType, Data data) {
        String info = "ReferenceAttributeType ";
        info = data.isArray() ? String.valueOf(info) + "- Array" : String.valueOf(info) + "- Doppelklick zum \u00d6ffnen des Auswahldialogs";
        this.initEditors();
        if (attType.getReferencedObjectType() == null) {
            if (!this.isReadOnly()) {
                this.editors[1] = null;
                this.treeViewer.setCellEditors(this.editors);
                this.treeViewer.setCellModifier((ICellModifier)this.textModifier);
            }
            this.doAdvice(info, 1);
            return;
        }
        ArrayList objList = new ArrayList();
        objList.addAll(attType.getReferencedObjectType().getElements());
        Collections.sort(objList, this.systemObjectComparator);
        String[] values = new String[objList.size()];
        int i = 0;
        for (SystemObject obj : objList) {
            values[i] = obj.toString();
            ++i;
        }
        this.stateEdit.setItems(values);
        if (!this.isReadOnly()) {
            this.editors[1] = null;
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.referenceModifier);
        }
        this.doAdvice(info, 1);
    }

    public void setStateEditor(IntegerAttributeType attType, Data data) {
        String info = "IntegerAttributeType";
        int i = 0;
        this.initEditors();
        ArrayList<String> types = new ArrayList<String>();
        for (IntegerValueState state : attType.getStates()) {
            ++i;
            types.add(state.getName());
        }
        if (data.isArray()) {
            info = String.valueOf(info) + " - Array";
        }
        info = String.valueOf(info) + " - mit " + i + " diskreten Zust\u00e4nden (siehe Auswahlbox)";
        String[] values = new String[types.size()];
        i = 0;
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            String str;
            values[i] = str = (String)iterator.next();
            ++i;
        }
        this.stateEdit.setItems(values);
        if (!this.isReadOnly()) {
            this.editors[1] = this.stateEdit;
            this.treeViewer.setCellEditors(this.editors);
            this.treeViewer.setCellModifier((ICellModifier)this.stateModifier);
        }
        this.doAdvice(info, 1);
    }

    public void createPartControl() {
        this.sectionClient.setLayout((Layout)new GridLayout(1, false));
        this.headLine = this.toolkit.createLabel(this.sectionClient, "Benutzer:\nUrsache:\nVeranlasser:");
        GridData headLineGridData = new GridData(16384, 128, true, false);
        headLineGridData.widthHint = 1050;
        this.headLine.setLayoutData((Object)headLineGridData);
        this.headLine.setBackground(Display.getDefault().getSystemColor(1));
        this.headLine.addMouseListener((MouseListener)new HeadLineMouseAdapter(this));
        if (this.additionalText != null) {
            this.additionalTextLabel = this.toolkit.createLabel(this.sectionClient, this.additionalText.getText());
            this.additionalTextLabel.setLayoutData((Object)new GridData(769));
            this.additionalTextLabel.setText(this.additionalText.getText());
            this.additionalTextLabel.setBackground(this.additionalText.getBackgroundColor());
            this.additionalTextLabel.setForeground(this.additionalText.getForegroundColor());
            this.additionalTextLabel.setFont(this.additionalText.getFont());
        }
        this.tree = this.toolkit.createTree(this.sectionClient, 67584);
        this.tree.setLayout((Layout)new FillLayout());
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.heightHint = this.calculateOptimalHeight();
        this.tree.setLayoutData((Object)layoutData);
        this.treeViewer = new TreeViewer(this.tree);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.setVisible(true);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new ParaEditCompositeDoubleClickListener(this));
        if (alertColor == null) {
            alertColor = new Color((Device)this.sectionClient.getDisplay(), 250, 100, 100);
        }
        if (messageColor == null) {
            messageColor = new Color((Device)this.sectionClient.getDisplay(), 200, 200, 230);
        }
        this.infoLine = this.toolkit.createLabel(this.sectionClient, "");
        this.infoLine.setLayoutData((Object)new GridData(768));
        this.doAdvice("Informationsleiste", 1);
        TreeColumn col = new TreeColumn(this.tree, 0);
        col.setText(this.properties[0]);
        col.setWidth(150);
        col = new TreeColumn(this.tree, 0);
        col.setText(this.properties[1]);
        col.setWidth(300);
        if (this.parameters.length > 1) {
            col = new TreeColumn(this.tree, 0);
            col.setText(this.properties[2]);
            col.setWidth(300);
        }
        col = new TreeColumn(this.tree, 0);
        col.setText("Wertebereich");
        col.setWidth(600);
        this.initEditors();
        this.treeViewer.setColumnProperties(this.properties);
        this.treeState = new ExpandState(this.treeViewer, this);
        if (!this.isReadOnly()) {
            this.createContextMenu();
        }
        this.currentTL = new TableSelectionListener();
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.currentTL);
    }

    String getUrlasserInfosAsSingleString(boolean lang) {
        String benutzerStr = "unbekannt";
        String ursacheLang = "unbekannt";
        String ursacheBearbeitet = "unbekannt";
        String veranlasser = "unbekannt";
        if (this.workingCopy != null) {
            Data atlUrlasserItem = this.workingCopy.getData().getItem("Urlasser");
            SystemObject o = atlUrlasserItem.getReferenceValue("BenutzerReferenz").getSystemObject();
            benutzerStr = o == null ? "undefiniert" : o.toString();
            veranlasser = atlUrlasserItem.getTextValue("Veranlasser").getText();
            ursacheLang = atlUrlasserItem.getTextValue("Ursache").getText();
            int firstNl = ursacheLang.indexOf(10);
            if (-1 == firstNl) {
                firstNl = ursacheLang.indexOf(13);
            }
            boolean needEllipsis = false;
            if (!lang && -1 != firstNl) {
                ursacheBearbeitet = ursacheLang.substring(0, firstNl - 1);
                needEllipsis = true;
            } else {
                ursacheBearbeitet = ursacheLang;
            }
            if (!lang && ursacheBearbeitet.length() > 100) {
                ursacheBearbeitet = ursacheBearbeitet.substring(0, 100);
                needEllipsis = true;
            }
            if (needEllipsis) {
                ursacheBearbeitet = String.valueOf(ursacheBearbeitet) + "...";
            }
        }
        StringBuilder b = new StringBuilder(100);
        b.append("Benutzer: ");
        b.append(benutzerStr);
        b.append("\nUrsache: ");
        b.append(ursacheBearbeitet);
        b.append("\nVeranlasser: ");
        b.append(veranlasser);
        return b.toString();
    }

    private void updateUrlasserInfos() {
        String ursacheLang = "unbekannt";
        if (this.workingCopy != null) {
            Data atlUrlasserItem = this.workingCopy.getData().getItem("Urlasser");
            ursacheLang = atlUrlasserItem.getTextValue("Ursache").getText();
        }
        this.headLine.setText(this.getUrlasserInfosAsSingleString(false));
        this.headLine.setToolTipText("Ursache: " + ursacheLang);
    }

    public final void showData(Parameter[] parameterToShow, boolean updateWorkingCopy) {
        this.treeViewer.setColumnProperties(this.properties);
        if (!(this.treeViewer.getLabelProvider() instanceof TableTreeLabelProvider)) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new TableTreeLabelProvider(this));
        }
        if (!(this.treeViewer.getContentProvider() instanceof TableTreeContentProvider)) {
            this.treeViewer.setContentProvider((IContentProvider)new TableTreeContentProvider());
        }
        if (this.isReadOnly() || updateWorkingCopy) {
            Data data;
            if (parameterToShow[0].getData() == null) {
                ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
                data = davIf.createData(this.parameters[0].getAtg());
            } else {
                data = parameterToShow[0].getData();
            }
            this.workingCopy = new DataWithTime(data, System.currentTimeMillis());
            this.mediatorDataObject = new MyDataObject(parameterToShow[0]);
            this.dataObject = (MyTreeObject)this.mediatorDataObject.getContent();
        } else {
            DataWithTime saveData = parameterToShow[0].getDataWithTime();
            parameterToShow[0].setDataWithTime(this.workingCopy);
            this.mediatorDataObject = new MyDataObject(parameterToShow[0]);
            this.dataObject = (MyTreeObject)this.mediatorDataObject.getContent();
            parameterToShow[0].setDataWithTime(saveData);
        }
        if (updateWorkingCopy) {
            this.dirty = false;
        }
        int shadowLoop = 1;
        while (shadowLoop < parameterToShow.length) {
            this.shadowDataObjects[shadowLoop - 1] = (MyTreeObject)new MyDataObject(parameterToShow[shadowLoop]).getContent();
            ++shadowLoop;
        }
        this.updateUrlasserInfos();
        this.treeViewer.setInput((Object)this.dataObject);
        this.resizeControl();
    }

    public void doAdvice(String info, int state) {
        this.infoLine.setBackground(state == 0 ? alertColor : messageColor);
        this.infoLine.setText(" " + info);
    }

    public void fireExternalModificationEvent() {
        this.dirty = true;
        this.refreshViewer();
    }

    private void refreshViewer() {
        if (!this.sectionClient.getDisplay().isDisposed()) {
            this.sectionClient.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ParaEditComposite.this.treeViewer.getControl().isDisposed()) {
                        ParaEditComposite.this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.additionalText != null) {
            this.additionalText.dispose();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.container != null) {
                this.container.dirtyStateChanged(this, this.dirty);
            }
            if (this.formPart != null) {
                this.formPart.markDirty();
            }
        }
    }

    public void markSaved() {
        if (this.dirty) {
            this.dirty = false;
            if (this.container != null) {
                this.container.dirtyStateChanged(this, this.dirty);
            }
            this.dataObject.commit();
            this.updateSollParameter();
            this.updateUrlasserInfos();
            this.refreshViewer();
        }
    }

    public void setFormPart(AbstractFormPart formPart) {
        this.formPart = formPart;
    }

    public Parameter getEditedParameter() {
        return new Parameter(this.patameterInfos[0], this.workingCopy);
    }

    private void findAndAddMyTreeItemLeaves(MyTreeObject myTreeObject, List<MyTreeObject> leaves) {
        for (MyTreeObject child : myTreeObject.getChildren()) {
            if (child.hasChildren()) {
                this.findAndAddMyTreeItemLeaves(child, leaves);
                continue;
            }
            leaves.add(child);
        }
    }

    public MyTreeObject getMyTreeObjectForPath(String path) {
        MyTreeObject o = this.dataObject;
        if (path != null && path.length() > 0) {
            ArrayList<MyTreeObject> leaves = new ArrayList<MyTreeObject>();
            this.findAndAddMyTreeItemLeaves(this.dataObject, leaves);
            for (MyTreeObject leaf : leaves) {
                if (!path.equals(leaf.getFullPath())) continue;
                o = leaf;
                break;
            }
        }
        return o;
    }

    private MyTreeObject matchPath(String path, MyTreeObject myTreeObject) {
        MyTreeObject match = null;
        if (path.equals(myTreeObject.getFullPath())) {
            match = myTreeObject;
        } else if (myTreeObject.hasChildren()) {
            for (MyTreeObject child : myTreeObject.getChildren()) {
                match = this.matchPath(path, child);
                if (match != null) break;
            }
        }
        return match;
    }

    public MyTreeObject getShadowObject(MyTreeObject myTreeObject, int shadowIndex) {
        if (shadowIndex < 0 || shadowIndex >= this.shadowDataObjects.length) {
            return null;
        }
        MyTreeObject o = this.shadowDataObjects[shadowIndex];
        MyTreeObject[] shadowList = this.shadowDataObjectMap.get(myTreeObject);
        MyTreeObject match = null;
        if (shadowList != null) {
            match = shadowList[shadowIndex];
            if (match != null) {
                DEBUG.finest("Cache Hit");
            }
        } else {
            shadowList = new MyTreeObject[this.shadowDataObjects.length];
            this.shadowDataObjectMap.put(myTreeObject, shadowList);
        }
        if (match == null) {
            shadowList[shadowIndex] = match = this.matchPath(myTreeObject.getFullPath(), o);
            DEBUG.finest("Cache Miss");
        }
        return match;
    }

    private void updateSollParameter() {
        if (this.patameterInfos.length > 1) {
            boolean shadowIndex = true;
            ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
            ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)davIf);
            try {
                this.parameters[1] = hierarchie.getParameter(new ParameterInfo[]{this.patameterInfos[1]})[0];
                this.shadowDataObjects[0] = (MyTreeObject)new MyDataObject(this.parameters[1]).getContent();
                for (MyTreeObject[] array : this.shadowDataObjectMap.values()) {
                    if (array.length < 1) continue;
                    array[0] = null;
                }
            }
            catch (ParameterClientException e) {
                ParamPlugin.getDefault().getLogger().error("Fehler bei Abfrage der gespeicherten Parameter f\u00fcr " + this.patameterInfos[1].toString(), (Throwable)e);
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public MyTreeObject getDataObject() {
        return this.dataObject;
    }

    public final TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public MyDataObject getMediatorDataObject() {
        return this.mediatorDataObject;
    }

    public IParaEditCompositeContainer getContainer() {
        return this.container;
    }

    public ParameterInfo getVorgabeParameterInfo() {
        return this.patameterInfos[0];
    }

    public void refreshPreservingExpandState(MyTreeObject myTreeObject) {
        this.treeState.push();
        if (myTreeObject == null) {
            this.treeViewer.refresh();
        } else {
            this.treeViewer.refresh((Object)myTreeObject);
        }
        this.treeState.pop();
        this.setDirty();
    }

    private class AddRowAction
    extends TableSelectionAction {
        private int op;

        public AddRowAction(String str, int op) {
            super(str);
            this.op = -1;
            this.op = op;
        }

        public void run() {
            MyTreeObject parent = null;
            Data root = null;
            if (this.getSelectedObject() == null) {
                ParaEditComposite.this.doAdvice("Fehler: kein Element ausgew\u00e4hlt", 0);
                return;
            }
            MyTreeObject myTreeObject = (MyTreeObject)this.getSelectedObject();
            Data data = (Data)myTreeObject.getData();
            if (this.op != 0 && this.op != 1) {
                DEBUG.info("Weder ABOVE noch BELOW!");
            } else {
                parent = ((MyTreeObject)this.getSelectedObject()).getRoot();
                root = (Data)parent.getData();
            }
            switch (this.op) {
                case 0: {
                    data = new ArrayObjectTransformer(root).addLineAbove(ParaEditComposite.this.getLocation(myTreeObject));
                    ParaEditComposite.this.newItems.add(ParaEditComposite.this.getLocation(myTreeObject));
                    if (data == null) {
                        ParaEditComposite.this.doAdvice("Fehler: \u00dcberpr\u00fcfen Sie, ob Ihre Eingabe den Wertebereich verletzt.", 0);
                        break;
                    }
                    myTreeObject.setData(data);
                    break;
                }
                case 1: {
                    data = new ArrayObjectTransformer(root).addLineBelow(ParaEditComposite.this.getLocation(myTreeObject));
                    ParaEditComposite.this.newItems.add(ParaEditComposite.this.getLocation(myTreeObject));
                    if (data == null) {
                        ParaEditComposite.this.doAdvice("Fehler: \u00dcberpr\u00fcfen Sie, ob Ihre Eingabe den Wertebereich verletzt.", 0);
                        break;
                    }
                    myTreeObject.setData(data);
                    break;
                }
                case 2: {
                    data = new ArrayObjectTransformer(data).addLinesEnd(1);
                    if (data == null) {
                        ParaEditComposite.this.doAdvice("Fehler: \u00dcberpr\u00fcfen Sie, ob Ihre Eingabe den Wertebereich verletzt.", 0);
                        break;
                    }
                    myTreeObject.setData(data);
                    break;
                }
                case 4: {
                    data = new ArrayObjectTransformer(data).addLinesBegin(1);
                    if (data == null) {
                        ParaEditComposite.this.doAdvice("Fehler: \u00dcberpr\u00fcfen Sie, ob Ihre Eingabe den Wertebereich verletzt.", 0);
                        break;
                    }
                    myTreeObject.setData(data);
                    break;
                }
                default: {
                    ParaEditComposite.this.doAdvice("Fehler: unerwarteter Fehler", 0);
                }
            }
            ParaEditComposite.this.treeState.push();
            ParaEditComposite.this.showData(ParaEditComposite.this.parameters, false);
            ParaEditComposite.this.treeState.pop();
            ParaEditComposite.this.setDirty();
        }
    }

    private class LineRemoveAction
    extends TableSelectionAction {
        public LineRemoveAction(String alert) {
            super(alert);
        }

        public void run() {
            if (this.getSelectedObject() == null) {
                ParaEditComposite.this.doAdvice("Fehler: kein Element ausgew\u00e4hlt", 0);
                return;
            }
            MessageBox alert = new MessageBox(ParaEditComposite.this.treeViewer.getControl().getShell(), 200);
            alert.setText("Warnung");
            alert.setMessage("M\u00f6chten Sie dieses Element wirklich l\u00f6schen?");
            if (128 != alert.open()) {
                MyTreeObject myTreeObject = (MyTreeObject)this.getSelectedObject();
                MyTreeObject myTreeObjectRoot = myTreeObject.getRoot();
                Data parent = (Data)myTreeObjectRoot.getData();
                int selectedChildIdx = ParaEditComposite.this.getLocation(myTreeObject);
                new ArrayObjectTransformer(parent).removeSingleLine(selectedChildIdx);
                int lastChildIdx = myTreeObjectRoot.getChildren().size() - 1;
                myTreeObjectRoot.getChildren().remove(lastChildIdx);
                ParaEditComposite.this.treeState.push();
                ParaEditComposite.this.showData(ParaEditComposite.this.parameters, false);
                ParaEditComposite.this.treeState.pop();
                ParaEditComposite.this.setDirty();
            }
        }
    }

    public class ReferenceModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            if (property.equals(ParaEditComposite.this.properties[0])) {
                return false;
            }
            MyTreeObject myTreeObject = (MyTreeObject)element;
            Data data = (Data)myTreeObject.getData();
            return data.isPlain();
        }

        public Object getValue(Object element, String property) {
            MyTreeObject myTreeObject = (MyTreeObject)element;
            Data data = (Data)myTreeObject.getData();
            try {
                ReferenceAttributeType attType = (ReferenceAttributeType)data.getAttributeType();
                String valueText = data.asReferenceValue().getValueText();
                if ("<<null>>".equals(valueText) || "undefiniert".equals(valueText)) {
                    return 0;
                }
                SystemObject obj = data.asReferenceValue().getSystemObject();
                if (obj == null) {
                    return 0;
                }
                int i = 0;
                for (SystemObject listState : attType.getReferencedObjectType().getElements()) {
                    if (listState.equals(obj)) {
                        return i;
                    }
                    ++i;
                }
            }
            catch (NullPointerException e) {
                ParaEditComposite.this.doAdvice("Unerwarteter Fehler", 0);
                Logger.getLogger(ParaEditComposite.class.getName()).log(Level.INFO, "", e);
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            TreeItem tti = (TreeItem)element;
            MyTreeObject myTreeObject = (MyTreeObject)tti.getData();
            Data data = (Data)myTreeObject.getData();
            ReferenceAttributeType attType = (ReferenceAttributeType)data.getAttributeType();
            ArrayList list = new ArrayList();
            list.addAll(attType.getReferencedObjectType().getElements());
            Collections.sort(list, ParaEditComposite.this.systemObjectComparator);
            SystemObject newValue = (SystemObject)list.get((Integer)value);
            SystemObject oldValue = data.asReferenceValue().getSystemObject();
            if (oldValue.equals(newValue)) {
                return;
            }
            data.asReferenceValue().setSystemObject(newValue);
            if (ParaEditComposite.this.container != null) {
                ParaEditComposite.this.container.valueModified(ParaEditComposite.this, myTreeObject, oldValue, newValue, data.getAttributeType());
            }
            ParaEditComposite.this.treeState.push();
            ParaEditComposite.this.treeViewer.refresh((Object)myTreeObject);
            ParaEditComposite.this.treeState.pop();
            ParaEditComposite.this.setDirty();
        }
    }

    private class RemoveAllAction
    extends TableSelectionAction {
        public RemoveAllAction(String alert) {
            super(alert);
        }

        private void collectChildrenRekursiv(List<MyTreeObject> collectorList, MyTreeObject myTreeObject) {
            collectorList.addAll(myTreeObject.getChildren());
            for (MyTreeObject o : myTreeObject.getChildren()) {
                this.collectChildrenRekursiv(collectorList, o);
            }
        }

        public void run() {
            if (this.getSelectedObject() == null) {
                ParaEditComposite.this.doAdvice("Fehler: kein Element ausgew\u00e4hlt", 0);
                return;
            }
            MessageBox alert = new MessageBox(ParaEditComposite.this.treeViewer.getControl().getShell(), 200);
            alert.setText("Warnung");
            alert.setMessage("M\u00f6chten Sie wirklich alle Elemente dieses Arrays l\u00f6schen?");
            if (128 != alert.open()) {
                MyTreeObject myTreeObject = (MyTreeObject)this.getSelectedObject();
                Data data = (Data)myTreeObject.getData();
                data = new ArrayObjectTransformer(data).removeAllLines();
                this.clearMyTreeObjectsInMediatorObject(myTreeObject);
                myTreeObject.getChildren().clear();
                ParaEditComposite.this.setDirty();
                myTreeObject.setData(data);
                ParaEditComposite.this.treeState.push();
                ParaEditComposite.this.treeViewer.refresh();
                ParaEditComposite.this.treeState.pop();
                ParaEditComposite.this.resizeControl();
            }
        }

        private void clearMyTreeObjectsInMediatorObject(MyTreeObject myTreeObject) {
            ArrayList<MyTreeObject> childrenToBeRemoved = new ArrayList<MyTreeObject>();
            this.collectChildrenRekursiv(childrenToBeRemoved, myTreeObject);
            ArrayList<Integer> childrenSindices = new ArrayList<Integer>(childrenToBeRemoved.size());
            int loop = 0;
            while (loop < ParaEditComposite.this.mediatorDataObject.getFlatList().size()) {
                MyTreeObject flatObject = ParaEditComposite.this.mediatorDataObject.getFlatList().get(loop);
                boolean found = false;
                for (MyTreeObject candidate : childrenToBeRemoved) {
                    if (flatObject != candidate) continue;
                    found = true;
                    break;
                }
                if (found) {
                    childrenSindices.add(loop);
                }
                ++loop;
            }
            Collections.sort(childrenSindices);
            int removerLoop = childrenSindices.size() - 1;
            while (removerLoop >= 0) {
                int currentlyRemovedIndex = (Integer)childrenSindices.get(removerLoop);
                ParaEditComposite.this.mediatorDataObject.getFlatList().remove(currentlyRemovedIndex);
                ParaEditComposite.this.mediatorDataObject.getEbeneList().remove(currentlyRemovedIndex);
                --removerLoop;
            }
        }
    }

    public class StateModifier
    implements ICellModifier {
        public boolean canModify(Object object, String property) {
            if (property.equals(ParaEditComposite.this.properties[0])) {
                return false;
            }
            MyTreeObject myTreeObject = (MyTreeObject)object;
            Data data = (Data)myTreeObject.getData();
            return data.isPlain();
        }

        public Object getValue(Object element, String property) {
            MyTreeObject myTreeObject = (MyTreeObject)element;
            Data data = (Data)myTreeObject.getData();
            String valueAsText = "";
            if (data.getAttributeType() instanceof StringAttributeType) {
                String text = data.asTextValue().getText();
                if (text != null) {
                    valueAsText = text;
                }
            } else if (data.getAttributeType() instanceof IntegerAttributeType) {
                Integer valueAsInt = 0;
                if (data.asUnscaledValue().getState() != null) {
                    IntegerValueState state = data.asUnscaledValue().getState();
                    IntegerAttributeType attType = (IntegerAttributeType)data.getAttributeType();
                    int i = 0;
                    for (IntegerValueState listState : attType.getStates()) {
                        if (listState.getValue() == state.getValue()) {
                            valueAsInt = i;
                        }
                        ++i;
                    }
                }
                return valueAsInt;
            }
            return valueAsText;
        }

        public void modify(Object element, String property, Object value) {
            TreeItem tti = (TreeItem)element;
            MyTreeObject myTreeObject = (MyTreeObject)tti.getData();
            Data data = (Data)myTreeObject.getData();
            IntegerAttributeType attType = (IntegerAttributeType)data.getAttributeType();
            List list = null;
            list = attType.getStates();
            IntegerValueState oldValue = data.asUnscaledValue().getState();
            long oldValueLong = oldValue == null ? 0L : oldValue.getValue();
            String newState = ((IntegerValueState)list.get((Integer)value)).getName();
            for (IntegerValueState ivs : attType.getStates()) {
                if (!ivs.getName().equals(newState)) continue;
                data.asUnscaledValue().setState(ivs);
                if (ParaEditComposite.this.container != null) {
                    ParaEditComposite.this.container.valueModified(ParaEditComposite.this, myTreeObject, oldValueLong, ivs.getValue(), data.getAttributeType());
                }
                ParaEditComposite.this.treeState.push();
                ParaEditComposite.this.treeViewer.refresh((Object)myTreeObject);
                ParaEditComposite.this.treeState.pop();
                ParaEditComposite.this.setDirty();
                return;
            }
        }
    }

    public class TableSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            Object elem = ((StructuredSelection)event.getSelection()).getFirstElement();
            ParaEditComposite.this.treeViewer.cancelEditing();
            if (elem == null) {
                return;
            }
            if (elem instanceof MyTreeObject) {
                MyTreeObject myTreeObject = (MyTreeObject)elem;
                if (myTreeObject.getData() instanceof Data) {
                    Data data = (Data)myTreeObject.getData();
                    AttributeType attType = data.getAttributeType();
                    if (attType instanceof StringAttributeType) {
                        ParaEditComposite.this.setStringEditor((StringAttributeType)attType, data);
                        this.cleanEditors(myTreeObject);
                    } else if (attType instanceof IntegerAttributeType) {
                        IntegerValueRange range = ((IntegerAttributeType)attType).getRange();
                        if (range != null) {
                            ParaEditComposite.this.setIntegerEditor((IntegerAttributeType)attType, data);
                            this.cleanEditors(myTreeObject);
                        } else if (((IntegerAttributeType)attType).getStates() != null) {
                            ParaEditComposite.this.setStateEditor((IntegerAttributeType)attType, data);
                            this.cleanEditors(myTreeObject);
                        }
                    } else if (attType instanceof DoubleAttributeType) {
                        ParaEditComposite.this.setDoubleEditor(data);
                        this.cleanEditors(myTreeObject);
                    } else if (attType instanceof AttributeListDefinition) {
                        ParaEditComposite.this.doAdvice("AttributeListDefinition", 1);
                    } else if (attType instanceof TimeAttributeType) {
                        ParaEditComposite.this.setTimeEditor((TimeAttributeType)attType, data);
                        this.cleanEditors(myTreeObject);
                    } else if (attType instanceof ReferenceAttributeType) {
                        ParaEditComposite.this.setReferenceEditor((ReferenceAttributeType)attType, data);
                        this.cleanEditors(myTreeObject);
                    } else {
                        ParaEditComposite.this.doAdvice("Unerwarteter Fehler in TableSelectionListener(1)", 0);
                    }
                }
            } else {
                ParaEditComposite.this.doAdvice("???Unerwarteter Fehler in TableSelectionListener(3)", 0);
            }
        }

        private void cleanEditors(MyTreeObject myTreeObject) {
            ParaEditComposite.this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)ParaEditComposite.this.currentTL);
            ParaEditComposite.this.treeViewer.editElement((Object)myTreeObject, 1);
            ParaEditComposite.this.currentTL = new TableSelectionListener();
            ParaEditComposite.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)ParaEditComposite.this.currentTL);
        }
    }
}

