/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.helper.MyTreeObject;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditComposite;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TableTreeLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final ParaEditComposite pec;

    public static final String getDoubleInfo(DoubleAttributeType attType, Data data) {
        String info = "DoubleAttributeType";
        if (data.isArray()) {
            info = String.valueOf(info) + " - Array";
        } else {
            info = String.valueOf(info) + "Genauigkeit: ";
            info = 1 == attType.getAccuracy() ? String.valueOf(info) + " doppelt" : String.valueOf(info) + " einfach";
        }
        return info;
    }

    public static final String getTimeInfo(TimeAttributeType attType, Data data) {
        String info = "";
        if (data.isArray()) {
            info = String.valueOf(info) + "Zeitangaben - Array";
            return info;
        }
        info = attType.isRelative() ? String.valueOf(info) + "relative Zeitangabe" : String.valueOf(info) + "absolute Zeitangabe";
        if (attType.getAccuracy() == 1) {
            info = String.valueOf(info) + ", millisekundengenau";
        } else if (attType.getAccuracy() == 0) {
            info = String.valueOf(info) + ", sekundengenau";
        }
        return info;
    }

    public static final String getStringInfo(StringAttributeType attType, Data data) {
        String info = "Text";
        info = data.isArray() ? String.valueOf(info) + " - Array" : String.valueOf(info) + " - L\u00e4ngenbegrenzung " + attType.getMaxLength() + " Zeichen";
        return info;
    }

    public static final String getReferenceInfo(ReferenceAttributeType attType, Data data) {
        String info = "Objektreferenz ";
        if (data.isArray()) {
            info = String.valueOf(info) + "- Array";
        } else {
            info = String.valueOf(info) + "auf ";
            if (attType.getReferencedObjectType() == null) {
                info = String.valueOf(info) + "beliebigen Typ";
            } else {
                info = String.valueOf(info) + "Typ ";
                info = String.valueOf(info) + attType.getReferencedObjectType().toString();
            }
        }
        return info;
    }

    public static String getIntegerInfo(IntegerAttributeType attType, Data data) {
        String info = attType.getNameOrPidOrId();
        if (data.isArray()) {
            info = String.valueOf(info) + " - Array";
            return info;
        }
        IntegerValueRange range = attType.getRange();
        if (range != null) {
            info = String.valueOf(info) + " - min=" + (double)range.getMinimum() * range.getConversionFactor() + " max=" + (double)range.getMaximum() * range.getConversionFactor();
        }
        info = String.valueOf(info) + "; Zust\u00e4nde: ";
        List states = attType.getStates();
        if (states == null || states.isEmpty()) {
            info = String.valueOf(info) + "keine.";
        } else {
            int stateLoop = 0;
            for (IntegerValueState state : states) {
                if (stateLoop > 0) {
                    info = String.valueOf(info) + ", ";
                }
                info = String.valueOf(info) + state.getValue() + " (" + state.getName() + ")";
                if (stateLoop > 4) {
                    info = String.valueOf(info) + " ...";
                    break;
                }
                ++stateLoop;
            }
        }
        return info;
    }

    public static String getAttributInfo(Data data) {
        String info = "";
        AttributeType attrType = data.getAttributeType();
        if (attrType instanceof IntegerAttributeType) {
            info = TableTreeLabelProvider.getIntegerInfo((IntegerAttributeType)attrType, data);
        } else if (attrType instanceof ReferenceAttributeType) {
            info = TableTreeLabelProvider.getReferenceInfo((ReferenceAttributeType)attrType, data);
        } else if (attrType instanceof StringAttributeType) {
            info = TableTreeLabelProvider.getStringInfo((StringAttributeType)attrType, data);
        } else if (attrType instanceof TimeAttributeType) {
            info = TableTreeLabelProvider.getTimeInfo((TimeAttributeType)attrType, data);
        } else if (attrType instanceof DoubleAttributeType) {
            info = TableTreeLabelProvider.getDoubleInfo((DoubleAttributeType)attrType, data);
        }
        return info;
    }

    public TableTreeLabelProvider(ParaEditComposite pec) {
        this.pec = pec;
    }

    public Image getColumnImage(Object arg0, int arg1) {
        MyTreeObject myTreeObject = (MyTreeObject)arg0;
        if (!(myTreeObject.getData() instanceof Data)) {
            return null;
        }
        Data data = (Data)myTreeObject.getData();
        String valueString = data.valueToString();
        int werteBereichsColumn = this.pec.getTreeViewer().getTree().getColumnCount() - 1;
        if (arg1 != werteBereichsColumn && (valueString == null || valueString.contains("<<null>>") || valueString.contains("ndefiniert"))) {
            return ParamSharedImage.ERROR_NULL.getImage();
        }
        return null;
    }

    public String getColumnText(Object arg0, int arg1) {
        MyTreeObject myTreeObject = (MyTreeObject)arg0;
        if (!(myTreeObject.getData() instanceof Data)) {
            return "Keine Daten!";
        }
        Data data = (Data)myTreeObject.getData();
        if (arg1 == 0) {
            String columnText = "";
            if (myTreeObject.isDirty()) {
                columnText = "*";
            }
            return String.valueOf(columnText) + data.getName();
        }
        if (arg1 == 1) {
            data = (Data)myTreeObject.getData();
        } else if (2 == arg1) {
            MyTreeObject myShadowObject = this.pec.getShadowObject(myTreeObject, arg1 - 2);
            if (myShadowObject == null || !(myShadowObject.getData() instanceof Data)) {
                return TableTreeLabelProvider.getAttributInfo(data);
            }
            data = (Data)myShadowObject.getData();
        } else if (3 == arg1) {
            return TableTreeLabelProvider.getAttributInfo(data);
        }
        if (data != null) {
            if (data.isArray() || data.isList()) {
                String output = data.toString();
                output = output.substring(data.getName().length() + 1, output.length());
                return output;
            }
            if (data.valueToString() == null || data.valueToString().startsWith("<<null>>")) {
                return "leer";
            }
            if (data.getAttributeType() instanceof ReferenceAttributeType) {
                SystemObject o = data.asReferenceValue().getSystemObject();
                if (o != null) {
                    String name = o.getName();
                    if (name.isEmpty()) {
                        name = "(" + o.getPidOrId() + ")";
                    }
                    return String.valueOf(name) + " [Doppelklick zum \u00c4ndern]";
                }
                return "Doppelklick zum Zuweisen";
            }
            return data.valueToString();
        }
        return "FEHLER: unerwarteter Datentyp";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object obj, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex) {
        Color background = null;
        MyTreeObject myTreeObject = (MyTreeObject)element;
        if (!this.pec.isReadOnly() && 1 == columnIndex && this.pec.getContainer() != null && myTreeObject.getData() instanceof Data && ((Data)myTreeObject.getData()).isPlain()) {
            Data data = (Data)myTreeObject.getData();
            String value = ParameterEditorInput.getPlainValueFromPlainData(data);
            background = this.pec.getContainer().getParameterEditorInput().getVorgabeColor(this.pec.getVorgabeParameterInfo(), myTreeObject.getFullPath(), value);
        }
        return background;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }
}

