/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.editors.helper;

import de.bsvrz.buv.plugin.param.editors.helper.MyTreeObject;
import de.bsvrz.buv.plugin.param.editors.helper.ParaEditComposite;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TreeItem;

public class TextModifier
implements ICellModifier {
    private final ParaEditComposite pec;
    private final String properties0;

    public TextModifier(ParaEditComposite pec, String properties0) {
        this.pec = pec;
        this.properties0 = properties0;
    }

    public boolean canModify(Object object, String property) {
        if (property.equals(this.properties0)) {
            return false;
        }
        MyTreeObject myTreeObject = (MyTreeObject)object;
        Data data = (Data)myTreeObject.getData();
        return data.isPlain();
    }

    public String getValue(Object element, String property) {
        MyTreeObject myTreeObject = (MyTreeObject)element;
        Data data = (Data)myTreeObject.getData();
        AttributeType attType = data.getAttributeType();
        String str = " ";
        if (attType instanceof ReferenceAttributeType) {
            return " ";
        }
        str = data.valueToString().startsWith("<<null>>") ? " " : data.valueToString();
        this.pec.innerCheck(this.pec.getDataObject());
        return str;
    }

    public void modify(Object element, String property, Object value) {
        TreeItem tto = (TreeItem)element;
        MyTreeObject myTreeObject = (MyTreeObject)tto.getData();
        Data data = (Data)myTreeObject.getData();
        boolean reallyModified = false;
        if (value == null) {
            return;
        }
        if (data.getAttributeType() instanceof ReferenceAttributeType) {
            ReferenceAttributeType ref = (ReferenceAttributeType)data.getAttributeType();
            ClientDavInterface davIf = RahmenwerkService.getService().getObjektFactory().getDav();
            SystemObject oldValue = data.asReferenceValue().getSystemObject();
            SystemObject newValue = davIf.getDataModel().getObject((String)value);
            if (newValue == null) {
                this.pec.doAdvice("Fehler: Referenz-Object konnte nicht identifiziert werden.", 0);
            } else {
                SystemObjectType referencedType = ref.getReferencedObjectType();
                if (referencedType == null || newValue.isOfType(referencedType)) {
                    if (!newValue.equals(oldValue)) {
                        data.asReferenceValue().setSystemObject(newValue);
                        reallyModified = true;
                        if (this.pec.getContainer() != null) {
                            this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                        }
                    }
                } else {
                    this.pec.doAdvice("Fehler: Referenz-Object ist kein Element von " + referencedType.getName(), 0);
                }
            }
        } else if (data.getAttributeType() instanceof IntegerAttributeType && ((String)value).length() > 0) {
            List states;
            long unscaledValue;
            long oldValue = data.asUnscaledValue().longValue();
            Double newDoubleValue = Double.valueOf(((String)value).replaceAll(",", "."));
            long newValue = newDoubleValue.longValue();
            IntegerAttributeType attrType = (IntegerAttributeType)data.getAttributeType();
            IntegerValueRange range = attrType.getRange();
            boolean valueSetViaRange = false;
            if (range != null && (unscaledValue = Math.round(newDoubleValue / range.getConversionFactor())) >= range.getMinimum() && unscaledValue <= range.getMaximum() && oldValue != unscaledValue) {
                data.asUnscaledValue().set(unscaledValue);
                reallyModified = true;
                if (this.pec.getContainer() != null) {
                    this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, unscaledValue, data.getAttributeType());
                }
                valueSetViaRange = true;
            }
            if (!valueSetViaRange && (states = attrType.getStates()) != null && !states.isEmpty()) {
                for (IntegerValueState state : states) {
                    if (state.getValue() != newValue || oldValue == newValue) continue;
                    data.asUnscaledValue().set(newValue);
                    reallyModified = true;
                    if (this.pec.getContainer() != null) {
                        this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                    }
                    break;
                }
            }
        } else if (data.getAttributeType() instanceof DoubleAttributeType) {
            double oldValue = data.asUnscaledValue().doubleValue();
            double newValue = Double.valueOf(((String)value).replaceAll(",", "."));
            if (newValue != oldValue) {
                data.asUnscaledValue().set(newValue);
                reallyModified = true;
                if (this.pec.getContainer() != null) {
                    this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                }
            }
        } else if (data.getAttributeType() instanceof StringAttributeType) {
            String newValue;
            String oldValue = data.asTextValue().getText();
            if (!oldValue.equals(newValue = (String)value)) {
                data.asTextValue().setText(newValue);
                reallyModified = true;
                if (this.pec.getContainer() != null) {
                    this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                }
            }
        } else if (data.getAttributeType() instanceof TimeAttributeType) {
            TimeAttributeType tat = (TimeAttributeType)data.getAttributeType();
            String v = (String)value;
            long oldValue = data.asTimeValue().getMillis();
            if (tat.isRelative()) {
                String[] parts = v.split(":");
                long id = Long.parseLong(parts[0]);
                long ih = Long.parseLong(parts[1]);
                long imin = Long.parseLong(parts[2]);
                long isec = Long.parseLong(parts[3]);
                long ims = Long.parseLong(parts[4]);
                long newValue = ims += isec * 1000L + imin * 60L * 1000L + ih * 60L * 60L * 1000L + id * 24L * 60L * 60L * 1000L;
                if (oldValue != newValue) {
                    data.asTimeValue().setMillis(newValue);
                    reallyModified = true;
                    if (this.pec.getContainer() != null) {
                        this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                    }
                }
            } else {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss:SS");
                try {
                    Date date = format.parse(v);
                    long newValue = date.getTime();
                    if (oldValue != newValue) {
                        data.asTimeValue().setMillis(newValue);
                        reallyModified = true;
                        if (this.pec.getContainer() != null) {
                            this.pec.getContainer().valueModified(this.pec, myTreeObject, oldValue, newValue, data.getAttributeType());
                        }
                    }
                }
                catch (ParseException e) {
                    this.pec.doAdvice("Fehler: Bitte halten Sie folgendes Eingabeformat ein: tt:mm:jjjj, hh:mm:ss:ms.", 0);
                }
            }
        } else {
            this.pec.doAdvice("Unbekannter Attributtyp", 0);
        }
        if (reallyModified) {
            this.pec.refreshPreservingExpandState(null);
        }
    }
}

