/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.handler;

import de.bsvrz.buv.plugin.param.editors.ParameterEditor;
import de.bsvrz.buv.plugin.param.editors.ParameterEditorInput;
import de.bsvrz.buv.plugin.param.editors.ParameterSaveResultEnum;
import de.bsvrz.buv.plugin.param.editors.ParameterSaver;
import de.bsvrz.buv.plugin.param.handler.AbstractParameterModifizierenHandler;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.jobs.ParameterEntfernenJob;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class ParameterEntfernenHandler
extends AbstractParameterModifizierenHandler {
    public static final String COMMAND_ID = "de.bsvrz.buv.plugin.param.actions.ParameterEntfernenAktion";

    private void doDeleteParameters(List<ParameterEditor> inputsContainingParameters, Parameter[] parameters) {
        ParameterEntfernenJob job = new ParameterEntfernenJob(this.findContentProvider(), parameters);
        if (ParamPlugin.getDefault().isUsingReloadJobs()) {
            job.schedule();
        } else {
            Cursor waitCursor = null;
            Shell shell = Display.getDefault().getActiveShell();
            if (shell != null) {
                waitCursor = new Cursor((Device)Display.getDefault(), 1);
                shell.setCursor(waitCursor);
            }
            IStatus status = job.run((IProgressMonitor)new NullProgressMonitor());
            if (shell != null) {
                shell.setCursor(null);
            }
            if (waitCursor != null) {
                waitCursor.dispose();
            }
            if (!status.isOK()) {
                MessageDialog.openError(null, (String)"Fehler beim L\u00f6schen von Parametern", (String)status.getMessage());
            } else {
                this.handleEditorsContainingDeletedParameter(inputsContainingParameters, parameters);
            }
        }
    }

    private void handleEditorsContainingDeletedParameter(List<ParameterEditor> editorsContainingParameters, Parameter[] parameters) {
        if (editorsContainingParameters == null || editorsContainingParameters.isEmpty()) {
            return;
        }
        for (ParameterEditor editor : editorsContainingParameters) {
            editor.selectiveReload(parameters, false);
            this.applyInitialDirtyState(editor.getEditorInput(), editor);
        }
    }

    private List<ParameterEditor> getEditorsContainingDeletedParameter(Parameter[] parameters) {
        IEditorReference[] refs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditors(null, ParameterEditor.EDITOR_ID, 2);
        if (refs == null || refs.length <= 0) {
            return null;
        }
        ArrayList<ParameterEditor> editorsContainingParameters = new ArrayList<ParameterEditor>();
        IEditorReference[] iEditorReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            ParameterEditor editor = (ParameterEditor)ref.getEditor(false);
            ParameterEditorInput pei = editor.getEditorInput();
            boolean editorAdded = false;
            Parameter[] parameterArray = pei.getParameters();
            int n3 = parameterArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Parameter editedParameter = parameterArray[n4];
                ParameterInfo editedParameterInfo = editedParameter.getInfo();
                Parameter[] parameterArray2 = parameters;
                int n5 = parameters.length;
                int n6 = 0;
                while (n6 < n5) {
                    Parameter deleteParameter = parameterArray2[n6];
                    if (editedParameterInfo.equals((Object)deleteParameter.getInfo())) {
                        editorsContainingParameters.add(editor);
                        editorAdded = true;
                        break;
                    }
                    ++n6;
                }
                if (editorAdded) break;
                ++n4;
            }
            ++n2;
        }
        return editorsContainingParameters;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Parameter[] parameters = this.getParameters(event);
        if (parameters == null || parameters.length <= 0) {
            return null;
        }
        List<ParameterEditor> editorsContainingParameters = this.getEditorsContainingDeletedParameter(parameters);
        ParameterSaveResultEnum saveResult = ParameterSaver.saveParameters(parameters, ParameterSaver.buildDefaultUrsache(parameters, parameters, ParameterSaver.ParameterSaveUrsache.GELOESCHT));
        switch (saveResult) {
            case PARAMETER_SAVE_FAILURE: {
                MessageDialog md = new MessageDialog(null, "Fehler beim Speichern von Parametern", null, ParameterSaver.getLastError(), 1, new String[]{"OK"}, 0);
                md.open();
                break;
            }
            case PARAMETER_SAVE_CANCEL: {
                break;
            }
            case PARAMETER_SAVE_SUCCESS: {
                this.doDeleteParameters(editorsContainingParameters, parameters);
                break;
            }
        }
        return null;
    }
}

