/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.internal;

import de.bsvrz.buv.plugin.param.ArtDesParametersatzesCache;
import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.lib.ParameterManagerAllgemein;
import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.einstellungen.Einstellungen;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.util.KappichModellUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RahmenwerkService {
    private static RahmenwerkService service;
    private Rahmenwerk rahmenWerk;
    private Berechtigungen berechtigungen;
    private Einstellungen einstellungen;
    private ObjektFactory objektFactory;
    private IArtDesParametersatzesProvider artDesParametersatzesProvider;

    public static RahmenwerkService getService() {
        return service;
    }

    protected void activate() {
        service = this;
        this.artDesParametersatzesProvider = new ArtDesParametersatzesCache();
        if (this.objektFactory.isVerbunden()) {
            this.startOnline();
        } else {
            this.startOffline();
        }
        this.objektFactory.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("verbunden".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        RahmenwerkService.this.startOnline();
                    } else {
                        RahmenwerkService.this.startOffline();
                    }
                }
            }
        });
    }

    protected void deactivate() {
        service = null;
    }

    protected void bindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = newRahmenWerk;
    }

    protected void unbindRahmenwerk(Rahmenwerk newRahmenWerk) {
        this.rahmenWerk = null;
    }

    public Rahmenwerk getRahmenWerk() {
        return this.rahmenWerk;
    }

    protected void bindObjektFactory(ObjektFactory newObjektFactory) {
        this.objektFactory = newObjektFactory;
    }

    protected void unbindObjektFactory(ObjektFactory oldObjektFactory) {
        this.objektFactory = null;
    }

    public ObjektFactory getObjektFactory() {
        return this.objektFactory;
    }

    protected void bindBerechtigungen(Berechtigungen newBerechtigungen) {
        this.berechtigungen = newBerechtigungen;
    }

    protected void unbindBerechtigungen(Berechtigungen newBerechtigungen) {
        this.berechtigungen = null;
    }

    public Berechtigungen getBerechtigungen() {
        return this.berechtigungen;
    }

    protected void bindEinstellungen(Einstellungen newEinstellungen) {
        this.einstellungen = newEinstellungen;
    }

    protected void unbindEinstellungen(Einstellungen newEinstellungen) {
        this.einstellungen = null;
    }

    public Einstellungen getEinstellungen() {
        return this.einstellungen;
    }

    private void startOnline() {
        KappichModellUtil.getAOE((ObjektFactory)this.getObjektFactory());
        ParameterManagerAllgemein.getInstanz().setVerbindung(this.getObjektFactory().getDav());
        ArchiveRequestManager archiv = this.getObjektFactory().getDav().getArchive();
        int waitLoop = 10;
        while (!archiv.isArchiveAvailable() && waitLoop-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (ParamPlugin.getDefault() == null) continue;
                ParamPlugin.getDefault().getLogger().warning("Unterbrechung beim Warten auf Verf\u00fcgbarkeit des Archivs", (Throwable)e);
            }
        }
        if (waitLoop <= 0 && ParamPlugin.getDefault() != null) {
            ParamPlugin.getDefault().getLogger().warning("Archiv ist nicht verf\u00fcgbar! Das Feature zum Abfragen historischer Parameter wird m\u00f6glicherweise nicht funktionieren!");
        }
        this.getArtDesParametersatzesProvider().setArchivAvailable(archiv.isArchiveAvailable());
        ParametertypenCache.erzeugeInstanz(this.getObjektFactory());
        if (ParamPlugin.getDefault() != null) {
            ParamPlugin.getDefault().getLogger().info("Initialisiere die Berechtigungsverwaltung des Plug-in Parametrierung");
        }
    }

    private void startOffline() {
        ParameterManagerAllgemein.getInstanz().setVerbindung(null);
        this.getArtDesParametersatzesProvider().setArchivAvailable(false);
    }

    public IArtDesParametersatzesProvider getArtDesParametersatzesProvider() {
        return this.artDesParametersatzesProvider;
    }
}

