/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.jobs;

import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.puk.param.lib.ParameterClientException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ContentViewer;

public class ReloadCurrentInputJob
extends Job {
    private final AbstractParamPluginContentProvider contentProvider;
    private final boolean doRefreshViewer;

    public ReloadCurrentInputJob(AbstractParamPluginView paramPluginView, boolean doRefreshViewer) {
        super("Ansicht '" + paramPluginView.getPartName() + "' aktualisieren");
        Assert.isTrue((boolean)(paramPluginView.getSite().getSelectionProvider() instanceof ContentViewer));
        ContentViewer viewer = (ContentViewer)paramPluginView.getSite().getSelectionProvider();
        Assert.isTrue((boolean)(viewer.getContentProvider() instanceof AbstractParamPluginContentProvider));
        this.contentProvider = (AbstractParamPluginContentProvider)viewer.getContentProvider();
        this.doRefreshViewer = doRefreshViewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            this.contentProvider.reloadCurrentInput(this.doRefreshViewer);
        }
        catch (ParameterClientException e) {
            String msg = String.valueOf(this.getName()) + " ist fehlgeschlagen";
            ParamPlugin.getDefault().getLogger().error(msg, (Throwable)e);
            status = new Status(4, "de.bsvrz.buv.plugin.param", msg, (Throwable)e);
        }
        catch (IllegalStateException e) {
            String msg = String.valueOf(this.getName()) + " ist fehlgeschlagen";
            ParamPlugin.getDefault().getLogger().error(msg, (Throwable)e);
            status = new Status(4, "de.bsvrz.buv.plugin.param", msg, (Throwable)e);
        }
        return status;
    }
}

