/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.lib;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.dataSerializer.Deserializer;
import de.bsvrz.sys.funclib.dataSerializer.NoSuchVersionException;
import de.bsvrz.sys.funclib.dataSerializer.SerializingFactory;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class DefaultParameterProvider {
    private static final Debug LOGGER = Debug.getLogger();
    private final AttributeGroup defaultParameterAtg;
    private final DataModel dataModel;

    DefaultParameterProvider(ClientDavInterface verbindung, boolean preload) {
        LOGGER.info("Standardparameter-Provider wird gestartet");
        this.dataModel = verbindung.getDataModel();
        LOGGER.info("Ermittle die Attributgruppe zur Definition der Standardparameter");
        this.defaultParameterAtg = this.dataModel.getAttributeGroup("atg.defaultParameterdatens\u00e4tze");
        if (preload) {
            LOGGER.info("Ermittle alle g\u00fcltigen Objekte");
            Collection objekte = this.dataModel.getObjects(null, null, ObjectTimeSpecification.valid());
            LOGGER.info("Lies die konfigurierenden Daten f\u00fcr alle Standardparameter");
            this.dataModel.getConfigurationData(objekte, this.defaultParameterAtg);
        }
    }

    private Set<SystemObjectType> expandTypListe(Set<SystemObjectType> typen) {
        HashSet<SystemObjectType> neueListe = new HashSet<SystemObjectType>();
        for (SystemObjectType type : typen) {
            neueListe.addAll(type.getSuperTypes());
        }
        return neueListe;
    }

    Parameter getDefaultParameter(ParameterInfo info) {
        Parameter[] definitionen;
        LOGGER.finer("Ermittle DefaultParameter f\u00fcr: ", (Object)info);
        Parameter result = null;
        Parameter[] parameterArray = definitionen = this.getDefinitionen(info.getObjekt());
        int n = definitionen.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            Set<SystemObjectType> typen = new HashSet<SystemObjectType>();
            typen.add(info.getTyp());
            while (typen.size() > 0) {
                if (typen.contains(parameter.getTyp()) && parameter.getAtg().equals(info.getAtg())) {
                    result = parameter;
                    break;
                }
                typen = this.expandTypListe(typen);
            }
            if (result != null) break;
            ++n2;
        }
        return result;
    }

    private Parameter[] getDefinitionen(SystemObject objekt) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Data daten = objekt.getConfigurationData(this.defaultParameterAtg);
        if (daten != null) {
            LOGGER.finer("Standardparameterdatens\u00e4tze ermittelt", (Object)objekt);
            Data.Array array = daten.getArray("Default-Parameterdatensatz");
            int idx = 0;
            while (idx < array.getLength()) {
                Data eintrag = array.getItem(idx);
                SystemObjectType typ = (SystemObjectType)eintrag.getReferenceValue("typ").getSystemObject();
                if (typ == null) {
                    typ = objekt.getType();
                }
                AttributeGroup attributGruppe = (AttributeGroup)eintrag.getReferenceValue("attributgruppe").getSystemObject();
                int serialisiererVersion = eintrag.getUnscaledValue("serialisierer").intValue();
                byte[] datenBytes = eintrag.getUnscaledArray("datensatz").getByteArray();
                if (datenBytes != null) {
                    try {
                        Deserializer deserializer = SerializingFactory.createDeserializer((int)serialisiererVersion, (InputStream)new ByteArrayInputStream(datenBytes));
                        Data parameterDaten = deserializer.readData(attributGruppe, (ObjectLookup)this.dataModel);
                        Parameter parameter = new Parameter(new ParameterInfo(objekt, typ, attributGruppe, 0));
                        parameter.setDataWithTime(new DataWithTime(parameterDaten, System.currentTimeMillis()));
                        result.add(parameter);
                        LOGGER.finest("Daten ermittelt", (Object)parameter);
                    }
                    catch (NoSuchVersionException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++idx;
            }
        } else {
            LOGGER.finer("Keine Standarddaten konfiguriert", (Object)objekt);
        }
        return result.toArray(new Parameter[result.size()]);
    }
}

