/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.lib;

import de.bsvrz.buv.plugin.param.ModifiableParameterInfo;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.lib.DefaultParameterProvider;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.archive.ArchiveData;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.archive.ArchiveDataQueryResult;
import de.bsvrz.dav.daf.main.archive.ArchiveDataSpecification;
import de.bsvrz.dav.daf.main.archive.ArchiveDataStream;
import de.bsvrz.dav.daf.main.archive.ArchiveOrder;
import de.bsvrz.dav.daf.main.archive.ArchiveQueryPriority;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestOption;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;
import de.bsvrz.dav.daf.main.archive.TimingType;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.ParameterManager;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ParameterManagerAllgemein {
    private static final Debug DEBUG = Debug.getLogger();
    private DefaultParameterProvider defaultParameterProvider;
    private static ParameterManagerAllgemein instanz;
    private ClientDavInterface verbindung;

    public static Parameter[] getFilledParameterArray(Parameter[] parameters) throws ParameterClientException {
        Parameter[] result = null;
        if (parameters != null) {
            result = new Parameter[parameters.length];
            int idx = 0;
            ArrayList<ParameterInfo> reqList = new ArrayList<ParameterInfo>();
            ArrayList<Integer> idxList = new ArrayList<Integer>();
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter parameter = parameterArray[n2];
                if (parameter.getData() == null && parameter.isDataAvailable()) {
                    reqList.add(parameter.getInfo());
                    idxList.add(idx);
                } else {
                    result[idx] = parameter;
                }
                ++idx;
                ++n2;
            }
            Parameter[] parameterResults = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getRahmenWerk().getDavVerbindung()).getParameter(reqList.toArray(new ParameterInfo[reqList.size()]));
            idx = 0;
            Parameter[] parameterArray2 = parameterResults;
            int n3 = parameterResults.length;
            n = 0;
            while (n < n3) {
                Parameter parameterResult = parameterArray2[n];
                result[((Integer)idxList.get((int)idx++)).intValue()] = parameterResult;
                ++n;
            }
        }
        return result;
    }

    public static ParameterManagerAllgemein getInstanz() {
        if (instanz == null) {
            instanz = new ParameterManagerAllgemein();
        }
        return instanz;
    }

    public static String getParameterDataSafeOhneUrlasserListe(Parameter p) {
        String text;
        Data data = p.getData();
        if (data == null) {
            text = p.isDataAvailable() ? "Daten nicht abgerufen" : "Keine Daten oder keine Quelle";
        } else if (data.isPlain()) {
            text = p.getData().toString();
        } else {
            StringBuilder b = new StringBuilder();
            Iterator iterator = data.iterator();
            int loop = 0;
            while (iterator.hasNext()) {
                Data next = (Data)iterator.next();
                if ("Urlasser".equals(next.getName())) continue;
                if (loop > 0) {
                    b.append(", ");
                }
                b.append(next.toString());
                ++loop;
            }
            text = b.toString();
        }
        return text;
    }

    public static boolean parameterEquals(Parameter p1, Parameter p2) {
        boolean result = true;
        if (p1.getSim() != p2.getSim()) {
            result = false;
        } else if (!p1.getAtg().equals(p2.getAtg())) {
            result = false;
        } else if (!p1.getObjekt().equals(p2.getObjekt())) {
            result = false;
        } else if (!p1.getTyp().equals(p2.getTyp())) {
            result = false;
        }
        return result;
    }

    public Collection<SystemObject> getAenderbareObjekteAllgemein(ModifiableParameterInfo resolvedMpi) {
        if (this.verbindung == null) {
            throw new IllegalStateException("Keine Verbindung zum Datenverteiler");
        }
        ParameterInfo info = resolvedMpi.toParameterInfos()[0];
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)this.verbindung);
        DEBUG.config("Erfrage \u00e4nderbare Objekte f\u00fcr", (Object)info);
        Collection aenderbareObjekte = hierarchie.getAenderbareObjekte(info);
        if (aenderbareObjekte == null) {
            throw new IllegalStateException("\u00c4nderbare Objekte nicht ermittelbar");
        }
        DEBUG.config("Ermittelte " + aenderbareObjekte.size() + " \u00e4nderbare Objekte f\u00fcr", (Object)info);
        if (aenderbareObjekte.isEmpty() && !(info.getObjekt() instanceof SystemObjectType)) {
            ArrayList<SystemObject> aenderbareObjektePatched = new ArrayList<SystemObject>();
            aenderbareObjektePatched.add(info.getObjekt());
            DEBUG.config("PATCHED mit self");
            return aenderbareObjektePatched;
        }
        return aenderbareObjekte;
    }

    public Parameter[] getDefaultParameter(ParameterInfo ... infos) {
        Parameter[] parameters = new Parameter[infos.length];
        if (this.verbindung == null) {
            throw new IllegalStateException("Keine Verbindung zum Datenverteiler");
        }
        if (this.defaultParameterProvider == null) {
            this.defaultParameterProvider = new DefaultParameterProvider(this.verbindung, false);
        }
        int loop = 0;
        while (loop < infos.length) {
            Parameter p = this.defaultParameterProvider.getDefaultParameter(infos[loop]);
            if (p == null) {
                p = new Parameter(infos[loop]);
                Data data = this.verbindung.createData(infos[loop].getAtg());
                p.setDataWithTime(new DataWithTime(data, System.currentTimeMillis()));
            }
            parameters[loop] = p;
            ++loop;
        }
        return parameters;
    }

    public Parameter[] getIstParameter(ParameterInfo ... infos) {
        Parameter[] parameters = new Parameter[infos.length];
        if (this.verbindung == null) {
            throw new IllegalStateException("Keine Verbindung zum Datenverteiler");
        }
        Aspect istAspect = this.verbindung.getDataModel().getAspect("asp.parameterIst");
        int loop = 0;
        while (loop < infos.length) {
            ParameterInfo info = infos[loop];
            Set<SystemObjectType> realParents = ParametertypenCache.getInstanz().getRealParents(info.getAtg());
            Data istData = null;
            if (info.getAtg().getAspects().contains(istAspect) && realParents.contains(info.getObjekt().getType())) {
                DataDescription dataDescription = new DataDescription(info.getAtg(), istAspect, info.getSim());
                ResultData result = this.verbindung.getData(info.getObjekt(), dataDescription, 60000L);
                istData = result.getData();
            }
            if (istData == null) {
                istData = this.verbindung.createData(info.getAtg());
            }
            parameters[loop] = new Parameter(info, new DataWithTime(istData, System.currentTimeMillis()));
            ++loop;
        }
        return parameters;
    }

    public Parameter[] getParameterAllgemein(ModifiableParameterInfo resolvedMpi, Collection<SystemObject> aenderbareObjekte, boolean readData) throws ParameterClientException {
        Parameter[] einzelParameterIst;
        if (this.verbindung == null) {
            throw new IllegalStateException("Keine Verbindung zum Datenverteiler");
        }
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)this.verbindung);
        if (resolvedMpi.isHistorisch()) {
            ArchiveRequestManager archiv = this.verbindung.getArchive();
            if (!archiv.isArchiveAvailable()) {
                throw new IllegalStateException("Archivsystem ist nicht verf\u00fcgbar!");
            }
            DataDescription dataDescription = new DataDescription(resolvedMpi.getAtg(), this.verbindung.getDataModel().getAspect("asp.parameterSoll"));
            ArchiveTimeSpecification timeSpec = new ArchiveTimeSpecification(TimingType.DATA_TIME, true, 1L, RahmenwerkService.getService().getArtDesParametersatzesProvider().getZeitpunkt());
            ArchiveDataKindCombination dataKinds = new ArchiveDataKindCombination(ArchiveDataKind.ONLINE);
            ArchiveRequestOption requestOption = ArchiveRequestOption.NORMAL;
            ArrayList<ArchiveDataSpecification> specs = new ArrayList<ArchiveDataSpecification>(aenderbareObjekte.size());
            for (SystemObject o : aenderbareObjekte) {
                ArchiveDataSpecification spec = new ArchiveDataSpecification(timeSpec, dataKinds, ArchiveOrder.BY_DATA_TIME, requestOption, dataDescription, o);
                specs.add(spec);
            }
            ArchiveDataQueryResult antwort = archiv.request(ArchiveQueryPriority.MEDIUM, specs);
            ArrayList<Parameter> abgerufeneParameter = new ArrayList<Parameter>(aenderbareObjekte.size());
            try {
                ArchiveDataStream[] archiveDataStreamArray = antwort.getStreams();
                int n = archiveDataStreamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArchiveDataStream strom = archiveDataStreamArray[n2];
                    ArchiveData archivData = strom.take();
                    ParameterInfo einzelInfo = new ParameterInfo(strom.getDataSpecification().getObject(), resolvedMpi.getAtg(), resolvedMpi.getSim());
                    Parameter p = new Parameter(einzelInfo);
                    abgerufeneParameter.add(p);
                    while (archivData != null && archivData.getData() != null && archivData.getDataTime() <= timeSpec.getIntervalEnd()) {
                        p.setDataWithTime(new DataWithTime(archivData.getData(), archivData.getDataTime()));
                        archivData = strom.take();
                    }
                    ++n2;
                }
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            einzelParameterIst = abgerufeneParameter.toArray(new Parameter[abgerufeneParameter.size()]);
        } else {
            ParameterInfo[] einzelInfos = new ParameterInfo[aenderbareObjekte.size()];
            int einzelInfosLoop = 0;
            for (SystemObject o : aenderbareObjekte) {
                einzelInfos[einzelInfosLoop++] = new ParameterInfo(o, resolvedMpi.getAtg(), resolvedMpi.getSim());
            }
            einzelParameterIst = hierarchie.getParameter(readData, einzelInfos);
        }
        return einzelParameterIst;
    }

    public ClientDavInterface getVerbindung() {
        return this.verbindung;
    }

    public void setVerbindung(ClientDavInterface verbindung) {
        this.verbindung = verbindung;
    }
}

