/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.provider;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginLabelProvider;
import de.bsvrz.puk.param.lib.Parameter;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractParamPluginTableLabelProvider
extends AbstractParamPluginLabelProvider
implements ITableLabelProvider {
    public static final String COLUMNID_OBJECT_NAME = "Objekt";
    public static final String COLUMNID_OBJECT_PID = "Objekt-PID";
    public static final String COLUMNID_ATG_NAME = "Attributgruppe";
    public static final String COLUMNID_ATG_PID = "Attributgruppen-PID";
    public static final String COLUMNID_TYP_NAME = "Typ";
    public static final String COLUMNID_TYP_PID = "Typ-PID";
    public static final String COLUMNID_SIM = "Simulationsvariante";
    public static final String COLUMNID_QUELLE = "Parameterquelle";
    public static final String COLUMNID_QUELLTYP = "Typ der Quelle";
    private static final int PREFERRED_COLUMN_WIDTH_OBJECT_NAME = 250;

    public abstract String getColumnId(int var1);

    public abstract int getNumColumns();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "unbekannt";
        if (!(element instanceof Parameter)) {
            text = columnIndex == 0 ? (element == null ? String.valueOf(text) + ": kein Objekt \u00fcbergeben" : String.valueOf(text) + "er Typ: " + element.getClass().getName()) : "";
        } else {
            Parameter p = (Parameter)element;
            String columnId = this.getColumnId(columnIndex);
            if (COLUMNID_OBJECT_NAME.equals(columnId)) {
                text = p.getObjekt().toString();
            } else if (COLUMNID_OBJECT_PID.equals(columnId)) {
                text = p.getObjekt().getPidOrId();
            } else if (COLUMNID_ATG_NAME.equals(columnId)) {
                text = p.getAtg().toString();
            } else if (COLUMNID_ATG_PID.equals(columnId)) {
                text = p.getAtg().getPidOrId();
            } else if (COLUMNID_TYP_NAME.equals(columnId)) {
                text = p.getTyp().toString();
            } else if (COLUMNID_TYP_PID.equals(columnId)) {
                text = p.getTyp().getPidOrId();
            } else if (COLUMNID_SIM.equals(columnId)) {
                IArtDesParametersatzesProvider backend = RahmenwerkService.getService().getArtDesParametersatzesProvider();
                text = backend.getSimulationsVarianteString(p.getSim());
            } else if (COLUMNID_QUELLE.equals(columnId)) {
                text = p.getQuelle().getObjekt().toString();
            } else if (COLUMNID_QUELLTYP.equals(columnId)) {
                text = p.getQuelle().getTyp().toString();
            }
        }
        return text;
    }

    public int getPreferredColumnWidth(String columnId) {
        int text = 250;
        if (COLUMNID_OBJECT_PID.equals(columnId)) {
            text = 200;
        } else if (COLUMNID_ATG_PID.equals(columnId)) {
            text = 150;
        } else if (COLUMNID_TYP_NAME.equals(columnId)) {
            text = 180;
        } else if (COLUMNID_TYP_PID.equals(columnId)) {
            text = 140;
        } else if (COLUMNID_SIM.equals(columnId)) {
            text = 150;
        } else if (COLUMNID_QUELLTYP.equals(columnId)) {
            text = 100;
        }
        return text;
    }
}

