/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.provider;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.dav.daf.main.archive.ArchiveAvailabilityListener;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ArtDesParametersatzesContentProvider
extends AbstractParamPluginContentProvider
implements PropertyChangeListener,
ArchiveAvailabilityListener {
    private IArtDesParametersatzesProvider currentInput;

    public ArtDesParametersatzesContentProvider(AbstractParamPluginView paramPluginView) {
        super(paramPluginView);
        this.setKurzinfo("Hier wird bestimmt, ob aktuelle oder historische Parameter angezeigt\nwerden sollen. Weiterhin wird gew\u00e4hlt, ob die Parameter des Echtsystems\noder die einer Simulation angezeigt werden sollen");
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (IArtDesParametersatzesProvider.ART_SIMULATION.equals(inputElement)) {
            if (this.currentInput != null) {
                List<Short> validSimulationVariants = this.currentInput.getValidSimlationsVarianten();
                validSimulationVariants.remove((Object)0);
                validSimulationVariants.remove((Object)-1);
                elements = validSimulationVariants.toArray();
            } else {
                elements = new Object[]{};
            }
        }
        return elements;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        ObjektFactory factory = RahmenwerkService.getService().getObjektFactory();
        if (oldInput instanceof IArtDesParametersatzesProvider) {
            ((IArtDesParametersatzesProvider)oldInput).removePropertyChangeListener(this);
        }
        if (newInput instanceof IArtDesParametersatzesProvider) {
            ((IArtDesParametersatzesProvider)newInput).addPropertyChangeListener(this);
            this.currentInput = (IArtDesParametersatzesProvider)newInput;
            if (factory.isVerbunden()) {
                factory.getDav().getArchive().addArchiveAvailabilityListener((ArchiveAvailabilityListener)this);
            }
        } else {
            this.currentInput = null;
            if (factory.isVerbunden()) {
                factory.getDav().getArchive().addArchiveAvailabilityListener((ArchiveAvailabilityListener)this);
            }
        }
        this.refreshViewer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty() && this.currentInput != null) {
            IStructuredSelection s = (IStructuredSelection)event.getSelection();
            Iterator iterator = s.iterator();
            String art = (String)iterator.next();
            if (IArtDesParametersatzesProvider.ART_SIMULATION.equals(art) && iterator.hasNext()) {
                this.currentInput.setArtDesParametersatzes(art);
                Short selectedSimulationsVariante = (Short)iterator.next();
                this.currentInput.setSelectedSimulationsVariante(selectedSimulationsVariante);
            } else if (IArtDesParametersatzesProvider.ART_HISTORISCH.equals(art) && iterator.hasNext()) {
                this.currentInput.setArtDesParametersatzes(art);
                this.currentInput.setSelectedSimulationsVariante((short)-1);
                Timestamp timestamp = (Timestamp)iterator.next();
                this.currentInput.setZeitpunkt(timestamp.getTime());
            } else if (IArtDesParametersatzesProvider.ART_ORIGINAL.equals(art)) {
                this.currentInput.setArtDesParametersatzes(art);
                this.currentInput.setSelectedSimulationsVariante((short)-1);
            }
        }
    }

    @Override
    public void reloadCurrentInput(boolean doRefreshViewer) throws ParameterClientException {
        if (doRefreshViewer) {
            this.refreshViewer();
        }
    }

    private void archiveAvailabilityChangedUI(ArchiveRequestManager archive, Display display) {
        Shell shell = display.getActiveShell();
        Cursor waitCursor = null;
        try {
            try {
                if (this.currentInput != null) {
                    if (shell != null) {
                        waitCursor = new Cursor((Device)Display.getDefault(), 1);
                        shell.setCursor(waitCursor);
                    }
                    this.currentInput.setArchivAvailable(archive.isArchiveAvailable());
                    this.reloadCurrentInput(true);
                }
            }
            catch (ParameterClientException e) {
                ParamPlugin.getDefault().getLogger().error(e.getLocalizedMessage(), (Throwable)e);
                if (this.currentInput != null && shell != null) {
                    shell.setCursor(null);
                }
                if (waitCursor != null) {
                    waitCursor.dispose();
                    waitCursor = null;
                }
            }
        }
        finally {
            if (this.currentInput != null && shell != null) {
                shell.setCursor(null);
            }
            if (waitCursor != null) {
                waitCursor.dispose();
                waitCursor = null;
            }
        }
    }

    public void archiveAvailabilityChanged(final ArchiveRequestManager archive) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ArtDesParametersatzesContentProvider.this.archiveAvailabilityChangedUI(archive, display);
            }
        });
    }
}

