/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.provider;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ModifiableParameterInfo;
import de.bsvrz.buv.plugin.param.ObjektAuswahlEnum;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.jobs.AnsichtAktualisierenViaReloadCurrentInputJobRule;
import de.bsvrz.buv.plugin.param.jobs.ReloadCurrentInputJob;
import de.bsvrz.buv.plugin.param.lib.ParameterManagerAllgemein;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.sys.funclib.debug.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BetroffeneObjekteContentProvider
extends AbstractParamPluginContentProvider
implements PropertyChangeListener {
    private static final String DEFAULT_KURZINFO = "Betroffene Objekte: Keine.";
    private ModifiableParameterInfo[] currentInput;
    private final Map<Parameter, ParameterInfo> betroffeneEinzelParameter = new LinkedHashMap<Parameter, ParameterInfo>();
    private final Map<Parameter, ParameterInfo> nichtAenderbareEinzelParameter = new LinkedHashMap<Parameter, ParameterInfo>();
    private boolean betroffeneObjekteZeigen = true;
    private boolean nichtAenderbareObjekteZeigen = true;
    private final Debug debug = Debug.getLogger();

    public BetroffeneObjekteContentProvider(AbstractParamPluginView paramPluginView) {
        super(paramPluginView);
        this.setKurzinfo(DEFAULT_KURZINFO);
        RahmenwerkService.getService().getArtDesParametersatzesProvider().addPropertyChangeListener(this);
        this.debug.config("Contentprovider initialisiert");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof ModifiableParameterInfo[] && newInput != oldInput) {
            this.currentInput = (ModifiableParameterInfo[])newInput;
            if (ParamPlugin.getDefault().isUsingReloadJobs()) {
                ReloadCurrentInputJob job = new ReloadCurrentInputJob(this.getParamPluginView(), true);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (!event.getResult().isOK()) {
                            BetroffeneObjekteContentProvider.this.currentInput = null;
                            BetroffeneObjekteContentProvider.this.clearDerivedContainers();
                        }
                    }
                });
                job.schedule();
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell shell = display.getActiveShell();
            Cursor waitCursor = null;
            try {
                try {
                    if (shell != null) {
                        waitCursor = new Cursor((Device)Display.getDefault(), 1);
                        shell.setCursor(waitCursor);
                    }
                    this.reloadCurrentInput(true);
                    return;
                }
                catch (ParameterClientException e) {
                    ParamPlugin.getDefault().getLogger().error("Laden des neuen Datensatzes fehlgeschlagen", (Throwable)e);
                    this.currentInput = null;
                    this.clearDerivedContainers();
                    throw new IllegalStateException(e);
                }
            }
            finally {
                if (shell != null) {
                    shell.setCursor(null);
                }
                if (waitCursor != null) {
                    waitCursor.dispose();
                    waitCursor = null;
                }
            }
        }
        this.currentInput = null;
        this.clearDerivedContainers();
    }

    @Override
    public void dispose() {
        RahmenwerkService.getService().getArtDesParametersatzesProvider().removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void reloadCurrentInput(boolean doRefreshViewer) throws ParameterClientException {
        block5: {
            if (this.currentInput == null) {
                if (doRefreshViewer) {
                    this.setKurzinfo(DEFAULT_KURZINFO);
                }
                return;
            }
            try {
                this.clearDerivedContainers();
                this.updateDerivedContainers();
                this.updateKurzinfoFromContainers();
                if (doRefreshViewer) {
                    this.refreshViewer();
                }
            }
            catch (IllegalStateException e) {
                final Display display = PlatformUI.getWorkbench().getDisplay();
                if (display == null || display.isDisposed()) break block5;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog md = new MessageDialog(display.getActiveShell(), "Fehler bei Aktualisierung", null, "Ansicht '" + BetroffeneObjekteContentProvider.this.getParamPluginView().getPartName() + "' konnte nicht aktualisiert werden: " + e.getLocalizedMessage(), 1, new String[]{"OK"}, 0);
                        md.open();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDerivedContainers() throws ParameterClientException {
        ModifiableParameterInfo[] modifiableParameterInfoArray = this.currentInput;
        int n = this.currentInput.length;
        int n2 = 0;
        while (n2 < n) {
            ModifiableParameterInfo[] resolvedMpis;
            ModifiableParameterInfo mpi = modifiableParameterInfoArray[n2];
            ObjektAuswahlEnum objektAuswahlArt = mpi.autoFillTypes();
            ModifiableParameterInfo[] modifiableParameterInfoArray2 = resolvedMpis = mpi.resolve();
            int n3 = resolvedMpis.length;
            int n4 = 0;
            while (n4 < n3) {
                ModifiableParameterInfo resolvedMpi = modifiableParameterInfoArray2[n4];
                ParameterInfo info = resolvedMpi.toParameterInfos()[0];
                Collection<SystemObject> aenderbareObjekte = ParameterManagerAllgemein.getInstanz().getAenderbareObjekteAllgemein(resolvedMpi);
                if (!aenderbareObjekte.isEmpty()) {
                    Parameter[] einzelParameterIst;
                    Parameter[] parameterArray = einzelParameterIst = ParameterManagerAllgemein.getInstanz().getParameterAllgemein(resolvedMpi, aenderbareObjekte, false);
                    int n5 = einzelParameterIst.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Map<Parameter, ParameterInfo> map;
                        Parameter p = parameterArray[n6];
                        boolean aenderbar = true;
                        if (!ObjektAuswahlEnum.INSTANZ_ECHT.equals((Object)objektAuswahlArt)) {
                            switch (p.getQuelle().getTyp()) {
                                case LOKAL_OBJEKT: {
                                    aenderbar = false;
                                    break;
                                }
                            }
                        }
                        if (aenderbar) {
                            map = this.betroffeneEinzelParameter;
                            synchronized (map) {
                                this.betroffeneEinzelParameter.put(p, info);
                            }
                        }
                        map = this.nichtAenderbareEinzelParameter;
                        synchronized (map) {
                            this.nichtAenderbareEinzelParameter.put(p, info);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKurzinfoFromContainers() {
        if (this.currentInput == null) {
            this.setKurzinfo(DEFAULT_KURZINFO);
            return;
        }
        StringBuilder b = new StringBuilder("Betroffene Objekte");
        b.append(": ");
        int sum = 0;
        Map<Parameter, ParameterInfo> map = this.betroffeneEinzelParameter;
        synchronized (map) {
        }
        b.append(sum += this.betroffeneEinzelParameter.size());
        b.append(" von ");
        map = this.nichtAenderbareEinzelParameter;
        synchronized (map) {
        }
        b.append(sum += this.nichtAenderbareEinzelParameter.size());
        this.setKurzinfo(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDerivedContainers() {
        Map<Parameter, ParameterInfo> map = this.betroffeneEinzelParameter;
        synchronized (map) {
            this.betroffeneEinzelParameter.clear();
        }
        map = this.nichtAenderbareEinzelParameter;
        synchronized (map) {
            this.nichtAenderbareEinzelParameter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        Map<Parameter, ParameterInfo> map;
        HashSet<Parameter> elements = new HashSet<Parameter>();
        if (this.isBetroffeneObjekteZeigen()) {
            map = this.betroffeneEinzelParameter;
            synchronized (map) {
                elements.addAll(this.betroffeneEinzelParameter.keySet());
            }
        }
        if (this.isNichtAenderbareObjekteZeigen()) {
            map = this.nichtAenderbareEinzelParameter;
            synchronized (map) {
                elements.addAll(this.nichtAenderbareEinzelParameter.keySet());
            }
        }
        return elements.toArray();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public boolean isBetroffeneObjekteZeigen() {
        return this.betroffeneObjekteZeigen;
    }

    public void setBetroffeneObjekteZeigen(boolean betroffeneObjekteZeigen) {
        this.betroffeneObjekteZeigen = betroffeneObjekteZeigen;
        this.refreshViewer();
    }

    public boolean isNichtAenderbareObjekteZeigen() {
        return this.nichtAenderbareObjekteZeigen;
    }

    public void setNichtAenderbareObjekteZeigen(boolean nichtAenderbareObjekteZeigen) {
        this.nichtAenderbareObjekteZeigen = nichtAenderbareObjekteZeigen;
        this.refreshViewer();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ModifiableParameterInfo mpi;
        int n;
        int n2;
        ModifiableParameterInfo[] modifiableParameterInfoArray;
        if (this.currentInput == null) {
            return;
        }
        if (evt.getOldValue().equals(evt.getNewValue())) {
            return;
        }
        boolean mustReload = true;
        IArtDesParametersatzesProvider artProvider = RahmenwerkService.getService().getArtDesParametersatzesProvider();
        if ("artDesParametersatzes".equals(evt.getPropertyName())) {
            if (IArtDesParametersatzesProvider.ART_ORIGINAL.equals(evt.getNewValue())) {
                modifiableParameterInfoArray = this.currentInput;
                n2 = this.currentInput.length;
                n = 0;
                while (n < n2) {
                    mpi = modifiableParameterInfoArray[n];
                    mpi.setSim((short)-1);
                    mpi.setHistorisch(false);
                    ++n;
                }
                if (-1 != artProvider.getSelectedSimulationsVariante()) {
                    mustReload = false;
                }
            } else if (IArtDesParametersatzesProvider.ART_HISTORISCH.equals(evt.getNewValue())) {
                modifiableParameterInfoArray = this.currentInput;
                n2 = this.currentInput.length;
                n = 0;
                while (n < n2) {
                    mpi = modifiableParameterInfoArray[n];
                    mpi.setHistorisch(true);
                    ++n;
                }
                mustReload = false;
            } else if (IArtDesParametersatzesProvider.ART_SIMULATION.equals(evt.getNewValue())) {
                modifiableParameterInfoArray = this.currentInput;
                n2 = this.currentInput.length;
                n = 0;
                while (n < n2) {
                    mpi = modifiableParameterInfoArray[n];
                    mpi.setHistorisch(false);
                    ++n;
                }
                mustReload = false;
            }
        } else if ("selectedSimulationsVariante".equals(evt.getPropertyName())) {
            modifiableParameterInfoArray = this.currentInput;
            n2 = this.currentInput.length;
            n = 0;
            while (n < n2) {
                mpi = modifiableParameterInfoArray[n];
                mpi.setSim(RahmenwerkService.getService().getArtDesParametersatzesProvider().getSelectedSimulationsVariante());
                ++n;
            }
        } else if ("zeitpunkt".equals(evt.getPropertyName())) {
            modifiableParameterInfoArray = this.currentInput;
            n2 = this.currentInput.length;
            n = 0;
            while (n < n2) {
                mpi = modifiableParameterInfoArray[n];
                mpi.setZeitpunkt(RahmenwerkService.getService().getArtDesParametersatzesProvider().getZeitpunkt());
                ++n;
            }
        }
        this.debug.config("PropertyChange", new Object[]{this.getClass().getSimpleName(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue(), mustReload});
        if (mustReload) {
            this.debug.config(RahmenwerkService.getService().getArtDesParametersatzesProvider().toString());
            if (ParamPlugin.getDefault().isUsingReloadJobs()) {
                ReloadCurrentInputJob job = new ReloadCurrentInputJob(this.getParamPluginView(), true);
                job.setRule(new AnsichtAktualisierenViaReloadCurrentInputJobRule());
                job.schedule();
            } else {
                ContentViewer viewer = (ContentViewer)this.getParamPluginView().getSite().getSelectionProvider();
                AbstractParamPluginContentProvider contentProvider = (AbstractParamPluginContentProvider)viewer.getContentProvider();
                Display display = PlatformUI.getWorkbench().getDisplay();
                Shell shell = display.getActiveShell();
                Cursor waitCursor = null;
                try {
                    try {
                        if (shell != null) {
                            waitCursor = new Cursor((Device)Display.getDefault(), 1);
                            shell.setCursor(waitCursor);
                        }
                        contentProvider.reloadCurrentInput(true);
                    }
                    catch (ParameterClientException e) {
                        ParamPlugin.getDefault().getLogger().error("Laden des neuen Datensatzes fehlgeschlagen", (Throwable)e);
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    if (shell != null) {
                        shell.setCursor(null);
                    }
                    if (waitCursor != null) {
                        waitCursor.dispose();
                        waitCursor = null;
                    }
                }
            }
        }
    }
}

