/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.provider;

import com.bitctrl.lib.eclipse.wizards.ComposedWizardDialog;
import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ModifiableParameterInfo;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.plugin.param.internal.ParamPlugin;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.lib.ParameterManagerAllgemein;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginContentProvider;
import de.bsvrz.buv.plugin.param.provider.helper.MehrfachauswahlDialog;
import de.bsvrz.buv.plugin.param.views.AbstractParamPluginView;
import de.bsvrz.buv.plugin.param.views.BetroffeneObjekteView;
import de.bsvrz.buv.plugin.param.views.ObjektauswahlView;
import de.bsvrz.buv.rw.bitctrl.eclipse.MultipleSelection;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectAuswahlType;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.SystemObjectAuswahlWizardPage;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterClientException;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.ParameterManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ObjektauswahlContentProvider
extends AbstractParamPluginContentProvider
implements ITreeContentProvider {
    private static final String DEFAULT_KURZINFO = "Objektauswahl: Bitte einen Parametertypen (=Attributgruppe)\nin der Ansicht 'Parameter Allgemein' ausw\u00e4hlen";
    private AttributeGroup currentInput;
    private final Map<SystemObjectType, Parameter> parametersOnTypes = new LinkedHashMap<SystemObjectType, Parameter>();
    private final Map<SystemObject, Parameter> parametersOnVirtualInstances = new LinkedHashMap<SystemObject, Parameter>();

    public ObjektauswahlContentProvider(AbstractParamPluginView paramPluginView) {
        super(paramPluginView);
        this.setKurzinfo(DEFAULT_KURZINFO);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result = null;
        result = inputElement instanceof AttributeGroup ? this.parametersOnTypes.values().toArray() : new Object[]{};
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput instanceof AttributeGroup) {
            this.currentInput = (AttributeGroup)newInput;
            Display display = PlatformUI.getWorkbench().getDisplay();
            Shell shell = display.getActiveShell();
            Cursor waitCursor = null;
            try {
                try {
                    if (shell != null) {
                        waitCursor = new Cursor((Device)Display.getDefault(), 1);
                        shell.setCursor(waitCursor);
                    }
                    this.reloadCurrentInput(false);
                    return;
                }
                catch (ParameterClientException e) {
                    ParamPlugin.getDefault().getLogger().warning("Fehler beim Lesen der Parameter", (Throwable)e);
                    if (shell != null) {
                        shell.setCursor(null);
                    }
                    if (waitCursor == null) return;
                    waitCursor.dispose();
                    waitCursor = null;
                }
                return;
            }
            finally {
                if (shell != null) {
                    shell.setCursor(null);
                }
                if (waitCursor != null) {
                    waitCursor.dispose();
                    waitCursor = null;
                }
            }
        } else {
            this.currentInput = null;
            this.clearDerivedContainers();
        }
    }

    @Override
    public void reloadCurrentInput(boolean doRefreshViewer) throws ParameterClientException {
        Parameter[] parameters;
        if (this.currentInput == null) {
            this.setKurzinfo(DEFAULT_KURZINFO);
            return;
        }
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav());
        this.clearDerivedContainers();
        Set<SystemObjectType> parents = ParametertypenCache.getInstanz().getParents(this.currentInput);
        ParameterInfo[] infos = new ParameterInfo[parents.size()];
        int loop = 0;
        for (SystemObjectType t : parents) {
            infos[loop] = new ParameterInfo((SystemObject)t, t, this.currentInput, RahmenwerkService.getService().getArtDesParametersatzesProvider().getSelectedSimulationsVariante());
            ++loop;
        }
        Parameter[] parameterArray = parameters = hierarchie.getParameter(infos);
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            if (p.getObjekt() instanceof SystemObjectType) {
                this.parametersOnTypes.put((SystemObjectType)p.getObjekt(), p);
            }
            ++n2;
        }
        this.updateKurzinfoFromContainers();
        if (doRefreshViewer) {
            if (this.getContentViewer() != null && !this.getContentViewer().getControl().isDisposed() && !this.getContentViewer().getControl().getDisplay().isDisposed()) {
                this.getContentViewer().getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ObjektauswahlContentProvider.this.getContentViewer().getControl().isDisposed() && !ObjektauswahlContentProvider.this.getContentViewer().getControl().getDisplay().isDisposed() && ObjektauswahlContentProvider.this.getContentViewer().getInput() != null) {
                            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)ObjektauswahlContentProvider.this.getContentViewer(), ObjektauswahlContentProvider.this.getContentViewer().getSelection());
                            ObjektauswahlContentProvider.this.selectionChanged(event);
                        }
                    }
                });
            }
            this.refreshViewer();
        }
    }

    private void updateKurzinfoFromContainers() {
        if (this.currentInput == null) {
            this.setKurzinfo(DEFAULT_KURZINFO);
            return;
        }
        StringBuilder b = new StringBuilder(this.currentInput.getNameOrPidOrId());
        b.append(":\n");
        int numRealTypes = 0;
        int numVirtualTypes = 0;
        Set<SystemObjectType> directParents = ParametertypenCache.getInstanz().getRealParents(this.currentInput);
        for (Map.Entry<SystemObjectType, Parameter> entry : this.parametersOnTypes.entrySet()) {
            Parameter p = entry.getValue();
            if (!p.isDataAvailable()) continue;
            if (directParents.contains(entry.getKey())) {
                ++numRealTypes;
                continue;
            }
            ++numVirtualTypes;
        }
        b.append(numRealTypes);
        if (numRealTypes == 1) {
            b.append(" parametrierter echter Typ, ");
        } else {
            b.append(" parametrierte echte Typen, ");
        }
        b.append(numVirtualTypes);
        if (numVirtualTypes == 1) {
            b.append(" parametrierter virtueller Typ\n");
        } else {
            b.append(" parametrierte virtuelle Typen\n");
        }
        this.setKurzinfo(b.toString());
    }

    private void clearDerivedContainers() {
        this.parametersOnTypes.clear();
        this.parametersOnVirtualInstances.clear();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = null;
        SystemObject instanz = null;
        if (parentElement instanceof SystemObjectType) {
            SystemObjectType type = (SystemObjectType)parentElement;
            result = type.getElements().toArray();
        } else if (parentElement instanceof Parameter) {
            Parameter p = (Parameter)parentElement;
            if (p.getObjekt() instanceof SystemObjectType) {
                SystemObjectType type = (SystemObjectType)p.getObjekt();
                List vis = type.getElements();
                if (type.getAttributeGroups().contains(this.currentInput)) {
                    ModifiableParameterInfo mpi = new ModifiableParameterInfo();
                    mpi.setObjekt(p.getObjekt());
                    mpi.addTyp(p.getTyp());
                    mpi.setAtg(p.getAtg());
                    mpi.setSim(p.getSim());
                    try {
                        Parameter[] einzelParameterIst = ParameterManagerAllgemein.getInstanz().getParameterAllgemein(mpi, vis, false);
                        result = einzelParameterIst;
                    }
                    catch (ParameterClientException e) {
                        ParamPlugin.getDefault().getLogger().error("Fehler bei Bereitstellung der Kinder zu " + type.toString(), (Throwable)e);
                        result = new Object[]{};
                    }
                } else {
                    ArrayList<Parameter> parameterListe = new ArrayList<Parameter>(vis.size());
                    ArrayList<SystemObject> missingParameters = new ArrayList<SystemObject>();
                    ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav());
                    for (SystemObject o : vis) {
                        Parameter currentParameter = this.parametersOnVirtualInstances.get(o);
                        if (currentParameter == null) {
                            missingParameters.add(o);
                            continue;
                        }
                        parameterListe.add(currentParameter);
                    }
                    if (!missingParameters.isEmpty()) {
                        try {
                            int loop = 0;
                            ParameterInfo[] parameterInfoArray = new ParameterInfo[missingParameters.size()];
                            Set<SystemObjectType> directParents = ParametertypenCache.getInstanz().getDirectParents(this.currentInput);
                            if (directParents.isEmpty()) {
                                throw new IllegalStateException("Es konnte kein Typ ermittelt werden, an dem die Attributgruppe " + this.currentInput.toString() + " definiert ist.");
                            }
                            SystemObjectType directParent = (SystemObjectType)directParents.iterator().next();
                            if (directParents.size() > 1) {
                                String[] rootTypes = new String[directParents.size()];
                                int tLoop = 0;
                                Iterator iterator = directParents.iterator();
                                while (iterator.hasNext()) {
                                    SystemObjectType t = (SystemObjectType)iterator.next();
                                    rootTypes[tLoop] = t.getPid();
                                    ++tLoop;
                                }
                                SystemObjectAuswahlWizardPage auswahlPage = new SystemObjectAuswahlWizardPage("Mehrfachvererbung!", MultipleSelection.Single, SystemObjectAuswahlType.OnlyTypes, new ArrayList(), rootTypes);
                                String desc = "Die Attributgruppe " + this.currentInput.toString() + " hat mehr als ein direktes Elternobjekt";
                                ParamPlugin.getDefault().getLogger().warning(desc);
                                auswahlPage.setDescription(desc);
                                ComposedWizardDialog wizardDialog = new ComposedWizardDialog("Mehrfachvererbung!", new IWizardPage[]{auswahlPage});
                                if (wizardDialog.open() == 0) {
                                    directParent = (SystemObjectType)auswahlPage.getAuswahl().get(0);
                                } else {
                                    throw new IllegalStateException("Mehrdeutige Auswahl: " + desc + "\nKeine Entscheidung durch den Nutzer!");
                                }
                            }
                            for (SystemObject o : missingParameters) {
                                parameterInfoArray[loop] = new ParameterInfo(o, directParent, this.currentInput, RahmenwerkService.getService().getArtDesParametersatzesProvider().getSelectedSimulationsVariante());
                                ++loop;
                            }
                            Parameter[] parameters = hierarchie.getParameter(parameterInfoArray);
                            if (parameters != null) {
                                Parameter[] parameterArray = parameters;
                                int n = parameters.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Parameter parameter = parameterArray[n2];
                                    this.parametersOnVirtualInstances.put(parameter.getObjekt(), parameter);
                                    parameterListe.add(parameter);
                                    ++n2;
                                }
                            } else {
                                ParamPlugin.getDefault().getLogger().warning("Fehler beim Auslesen der Parameter f\u00fcr Kindobjekte zu " + type.toString() + ": Funktion liefert null");
                            }
                        }
                        catch (ParameterClientException e) {
                            ParamPlugin.getDefault().getLogger().warning(0, "Fehler beim Auslesen der Parameter f\u00fcr Kindobjekte zu " + type.toString(), (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            ParamPlugin.getDefault().getLogger().warning(0, e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    result = parameterListe.toArray();
                }
            } else {
                instanz = p.getObjekt();
            }
        } else if (parentElement instanceof SystemObject) {
            instanz = (SystemObject)parentElement;
        }
        if (instanz != null) {
            Set<SystemObjectType> mappedTypes = ParametertypenCache.getInstanz().getMappedTypes(instanz.getType());
            mappedTypes.removeAll(ParametertypenCache.getInstanz().getDirectParents(this.currentInput));
            ArrayList<Parameter> parameterListe = new ArrayList<Parameter>(mappedTypes.size());
            ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)RahmenwerkService.getService().getObjektFactory().getDav());
            try {
                int loop = 0;
                ParameterInfo[] infos = new ParameterInfo[mappedTypes.size()];
                Set<SystemObjectType> directParents = ParametertypenCache.getInstanz().getDirectParents(this.currentInput);
                if (directParents.isEmpty()) {
                    throw new IllegalStateException("Es konnte kein Typ ermittelt werden, an dem die Attributgruppe " + this.currentInput.toString() + " definiert ist.");
                }
                if (directParents.size() > 1) {
                    ParamPlugin.getDefault().getLogger().warning("Die Attributgruppe " + this.currentInput.toString() + " hat mehr als ein direktes Elternobjekt");
                }
                SystemObjectType directParent = directParents.iterator().next();
                for (SystemObject systemObject : mappedTypes) {
                    infos[loop] = new ParameterInfo(systemObject, directParent, this.currentInput, RahmenwerkService.getService().getArtDesParametersatzesProvider().getSelectedSimulationsVariante());
                    ++loop;
                }
                Parameter[] parameterArray = hierarchie.getParameter(infos);
                if (parameterArray != null) {
                    Parameter[] parameterArray2 = parameterArray;
                    int n = parameterArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Parameter parameter = parameterArray2[n3];
                        this.parametersOnVirtualInstances.put(parameter.getObjekt(), parameter);
                        parameterListe.add(parameter);
                        ++n3;
                    }
                } else {
                    ParamPlugin.getDefault().getLogger().warning("Fehler beim Auslesen der Parameter f\u00fcr Kindobjekte zu " + instanz.toString() + ": Funktion liefert null");
                }
            }
            catch (ParameterClientException e) {
                ParamPlugin.getDefault().getLogger().warning(0, "Fehler beim Auslesen der Parameter f\u00fcr Kindobjekte zu " + instanz.toString(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                ParamPlugin.getDefault().getLogger().warning(0, e.getLocalizedMessage(), (Throwable)e);
            }
            result = parameterListe.toArray();
        }
        return result;
    }

    public Object getParent(Object element) {
        ConfigurationArea parent = null;
        if (element instanceof SystemObjectType) {
            SystemObjectType type = (SystemObjectType)element;
            parent = type.getConfigurationArea();
        } else if (element instanceof SystemObject) {
            SystemObject object = (SystemObject)element;
            parent = object.getType();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        SystemObject o = null;
        if (element instanceof SystemObjectType) {
            SystemObjectType type = (SystemObjectType)element;
            result = !type.getElements().isEmpty();
        } else if (element instanceof Parameter) {
            Parameter p = (Parameter)element;
            if (p.getObjekt() instanceof SystemObjectType) {
                SystemObjectType type = (SystemObjectType)p.getObjekt();
                result = !type.getElements().isEmpty();
            } else {
                o = p.getObjekt();
            }
        } else if (element instanceof SystemObject) {
            o = (SystemObject)element;
        }
        if (o != null) {
            Set<SystemObjectType> mappedTypes = ParametertypenCache.getInstanz().getMappedTypes(o.getType());
            result = !mappedTypes.isEmpty();
        }
        return result;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
            IViewPart betroffeneObjekteView;
            MehrfachauswahlDialog mad;
            IStructuredSelection s = (IStructuredSelection)event.getSelection();
            if (s.size() > 1 && MehrfachauswahlDialog.isEnabled() && (mad = new MehrfachauswahlDialog(null, ObjektauswahlView.HILFE_ID)).open() != 0) {
                return;
            }
            if ((s.getFirstElement() instanceof SystemObject || s.getFirstElement() instanceof Parameter) && (betroffeneObjekteView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(BetroffeneObjekteView.ID)) != null) {
                ArrayList<ModifiableParameterInfo> modifiableInfos = new ArrayList<ModifiableParameterInfo>(2);
                Iterator selectionIterator = s.iterator();
                IArtDesParametersatzesProvider artProvider = RahmenwerkService.getService().getArtDesParametersatzesProvider();
                while (selectionIterator.hasNext()) {
                    Object next = selectionIterator.next();
                    ModifiableParameterInfo mpi = new ModifiableParameterInfo();
                    mpi.setAtg(this.currentInput);
                    if (next instanceof SystemObject) {
                        SystemObject element = (SystemObject)next;
                        mpi.setObjekt(element);
                    } else if (next instanceof Parameter) {
                        Parameter p = (Parameter)next;
                        mpi.setObjekt(p.getObjekt());
                    }
                    mpi.setHistorisch(IArtDesParametersatzesProvider.ART_HISTORISCH.equals(artProvider.getArtDesParametersatzes()));
                    mpi.setSim(artProvider.getSelectedSimulationsVariante());
                    mpi.setZeitpunkt(artProvider.getZeitpunkt());
                    modifiableInfos.add(mpi);
                }
                ISelectionProvider p = betroffeneObjekteView.getSite().getSelectionProvider();
                if (p instanceof ContentViewer) {
                    ContentViewer viewer = (ContentViewer)p;
                    viewer.setInput((Object)modifiableInfos.toArray(new ModifiableParameterInfo[modifiableInfos.size()]));
                }
            }
        }
    }
}

