/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.testprogramme;

import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectComparatorAlphabetical;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.Hierarchie;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class ParametertypenFinder
implements StandardApplication {
    private String selectedAtgPid;
    private String selectedTypePid;

    public void initialize(ClientDavInterface connection) throws Exception {
        ObjektFactory factory = DefaultObjektFactory.getInstanz();
        factory.setDav(connection);
        ParametertypenCache.erzeugeInstanz(factory);
        SystemObjectType selectedType = null;
        AttributeGroup selectedAttributeGroup = null;
        SystemObject selectedObj = null;
        ParametertypenCache ptypcache = ParametertypenCache.getInstanz();
        int kbLoop = 1;
        for (ConfigurationArea kb : ptypcache.getConfigurationAreas()) {
            System.out.println(String.valueOf(kbLoop) + ": Konfigurationsbereich " + kb.getName());
            int typeLoop = 1;
            for (SystemObjectType type : ptypcache.getSystemObjects(kb)) {
                System.out.println("   " + kbLoop + '.' + typeLoop + ": Typ " + type.getName());
                int atgLoop = 1;
                for (AttributeGroup atg : ptypcache.getAttributeGroups(type)) {
                    System.out.println("      " + kbLoop + '.' + typeLoop + '.' + atgLoop + ": Attributgruppe " + atg.toString());
                    if (atg.getPid().equals(this.selectedAtgPid)) {
                        selectedAttributeGroup = atg;
                    }
                    ++atgLoop;
                }
                if (type.getPid().equals(this.selectedTypePid)) {
                    selectedType = type;
                }
                ++typeLoop;
            }
            ++kbLoop;
        }
        if (selectedAttributeGroup == null) {
            Logger.getLogger(this.getClass().getName()).warning("Gew\u00fcnschte Attributgruppe " + this.selectedAtgPid + " nicht gefunden");
            System.exit(1);
        }
        if (selectedType == null) {
            Logger.getLogger(this.getClass().getName()).warning("Gew\u00fcnschter Typ " + this.selectedTypePid + " nicht gefunden, suche Objekte...");
            selectedObj = connection.getDataModel().getObject(this.selectedTypePid);
            if (selectedObj == null) {
                Logger.getLogger(this.getClass().getName()).warning("Gew\u00fcnschtes Objekt " + this.selectedTypePid + " nicht gefunden");
                System.exit(1);
            }
        }
        ParameterInfo info = selectedType == null ? new ParameterInfo(selectedObj, selectedAttributeGroup) : new ParameterInfo(selectedType, selectedAttributeGroup);
        Hierarchie hierarchie = MethodenBibliothek.getHierarchie((ClientDavInterface)connection);
        Thread.sleep(2000L);
        SystemObject wurzel = hierarchie.getParameterWurzel(info);
        if (wurzel == null) {
            Logger.getLogger(this.getClass().getName()).warning("F\u00fcr ParameterInfo:\n" + info.toString() + "\nkonnte kein Wurzelelement ermittelt werden");
        } else {
            Logger.getLogger(this.getClass().getName()).info("F\u00fcr ParameterInfo:\n" + info.toString() + "\nwurde als Wurzelelement ermittelt:\n" + wurzel.toString());
        }
        Collection aenderbareObjekte = hierarchie.getAenderbareObjekte(info);
        if (aenderbareObjekte == null) {
            Logger.getLogger(this.getClass().getName()).warning("F\u00fcr ParameterInfo:\n" + info.toString() + "\nkonnten die betroffenen Objekte nicht ermittelt werden");
        } else if (aenderbareObjekte.isEmpty()) {
            Logger.getLogger(this.getClass().getName()).info("F\u00fcr ParameterInfo:\n" + info.toString() + "\nsind keine Objekte betroffen");
        } else {
            ArrayList<SystemObject> aenderbareObjekteListe = new ArrayList<SystemObject>(aenderbareObjekte.size());
            aenderbareObjekteListe.addAll(aenderbareObjekte);
            Collections.sort(aenderbareObjekteListe, new SystemObjectComparatorAlphabetical(true));
            StringBuilder b = new StringBuilder("F\u00fcr ParameterInfo:\n");
            b.append(info.toString());
            b.append("\nsind folgende ");
            b.append(aenderbareObjekteListe.size());
            b.append(" Objekte potentiell betroffen:\n");
            for (SystemObject o : aenderbareObjekteListe) {
                b.append(o.toString());
                b.append('\n');
            }
            Logger.getLogger(this.getClass().getName()).info(b.toString());
            this.purgeAenderbareMenge(hierarchie, wurzel, info.getAtg(), aenderbareObjekteListe);
            Logger.getLogger(this.getClass().getName()).info("Zusammenfassung:\n  Potentiell betroffen: " + aenderbareObjekte.size() + " Objekte.\n  Wirklich betroffen: " + aenderbareObjekteListe.size() + " Objekte.");
        }
        System.exit(0);
    }

    private void purgeAenderbareMenge(Hierarchie hierarchie, SystemObject wurzel, AttributeGroup atg, List<SystemObject> aenderbareObjekteListe) {
        Object[] info = new ParameterInfo[aenderbareObjekteListe.size()];
        int loop = 0;
        while (loop < aenderbareObjekteListe.size()) {
            info[loop] = new ParameterInfo(aenderbareObjekteListe.get(loop), atg);
            ++loop;
        }
        SystemObject[] wurzeln = hierarchie.getParameterWurzel((ParameterInfo[])info);
        if (wurzeln == null) {
            Logger.getLogger(this.getClass().getName()).warning("F\u00fcr ParameterInfo:\n" + Arrays.toString(info) + "\nkonnten keine Wurzelelemente ermittelt werden");
            return;
        }
        if (wurzel == null) {
            loop = 0;
            while (loop < aenderbareObjekteListe.size()) {
                if (info[loop].getObjekt().equals(wurzeln[loop])) {
                    Logger.getLogger(this.getClass().getName()).info("Objekt '" + info[loop].getObjekt().toString() + "' wird entfernt");
                    aenderbareObjekteListe.remove(loop);
                }
                ++loop;
            }
        } else {
            loop = 0;
            while (loop < aenderbareObjekteListe.size()) {
                if (!wurzeln[loop].equals(wurzel)) {
                    Logger.getLogger(this.getClass().getName()).info("Objekt '" + info[loop].getObjekt().toString() + "' wird entfernt");
                    aenderbareObjekteListe.remove(loop);
                }
                ++loop;
            }
        }
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        this.selectedAtgPid = argumentList.fetchArgument("-selectedAtgPid").asString();
        this.selectedTypePid = argumentList.fetchArgument("-selectedTypePid").asString();
    }

    public static void main(String[] args) {
        StandardApplicationRunner.run((StandardApplication)new ParametertypenFinder(), (String)"typ.applikation", (String[])args);
    }
}

