/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.testprogramme;

import de.bsvrz.buv.plugin.param.ObjektAuswahlEnum;
import de.bsvrz.buv.plugin.param.ParametertypenCache;
import de.bsvrz.buv.rw.bitctrl.eclipse.SystemObjectComparatorAlphabetical;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.param.lib.MethodenBibliothek;
import de.bsvrz.puk.param.lib.Parameter;
import de.bsvrz.puk.param.lib.ParameterInfo;
import de.bsvrz.puk.param.lib.ParameterManager;
import de.bsvrz.puk.param.lib.daten.DataWithTime;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Logger;

public class VerkehrslageVerfahren1Parametrierer
implements StandardApplication {
    private final String selectedAtgPid = "atg.verkehrsLageVerfahren1";
    private String selectedObjectPid;
    private int v1;
    private int v2;
    private int k1;
    private int k2;
    private String ursache;
    private boolean delete;
    private boolean deleteNichtAenderbare;
    private boolean setzen;

    public void initialize(ClientDavInterface connection) throws Exception {
        Parameter p;
        ParameterInfo info;
        ObjektAuswahlEnum objektAuswahlArt;
        SystemObjectType selectedType;
        ObjektFactory factory = DefaultObjektFactory.getInstanz();
        factory.setDav(connection);
        ParametertypenCache.erzeugeInstanz(factory);
        AttributeGroup atgVerkehrsLageVerfahren1 = connection.getDataModel().getAttributeGroup("atg.verkehrsLageVerfahren1");
        if (atgVerkehrsLageVerfahren1 == null) {
            String s = "Gew\u00fcnschte Attributgruppe atg.verkehrsLageVerfahren1 nicht gefunden";
            Logger.getLogger(this.getClass().getName()).warning("Gew\u00fcnschte Attributgruppe atg.verkehrsLageVerfahren1 nicht gefunden");
            throw new IllegalArgumentException("Gew\u00fcnschte Attributgruppe atg.verkehrsLageVerfahren1 nicht gefunden");
        }
        SystemObjectType typMessQuerschnitt = connection.getDataModel().getType("typ.messQuerschnitt");
        assert (typMessQuerschnitt != null);
        SystemObjectType typFahrStreifen = connection.getDataModel().getType("typ.fahrStreifen");
        assert (typFahrStreifen != null);
        SystemObject selectedObj = connection.getDataModel().getObject(this.selectedObjectPid);
        if (selectedObj == null) {
            String s = "Gew\u00fcnschtes Objekt " + this.selectedObjectPid + " nicht gefunden";
            Logger.getLogger(this.getClass().getName()).warning(s);
            throw new IllegalArgumentException(s);
        }
        ParametertypenCache ptypcache = ParametertypenCache.getInstanz();
        Set<SystemObjectType> parents = ptypcache.getParents(atgVerkehrsLageVerfahren1);
        Logger.getLogger(this.getClass().getName()).info("F\u00fcr Attributgruppe:\natg.verkehrsLageVerfahren1\nwurden als Eltern ermittelt:\n" + parents.toString());
        if (selectedObj instanceof SystemObjectType) {
            selectedType = (SystemObjectType)selectedObj;
            if (!parents.contains(selectedType)) {
                String s = "Selektierter Typ '" + selectedType.toString() + "' erreicht die selektierte ATG '" + atgVerkehrsLageVerfahren1 + "' nicht";
                Logger.getLogger(this.getClass().getName()).warning(s);
                throw new IllegalArgumentException(s);
            }
            objektAuswahlArt = selectedType.getAttributeGroups().contains(atgVerkehrsLageVerfahren1) ? ObjektAuswahlEnum.TYP_ECHT : ObjektAuswahlEnum.TYP_VIRTUELL;
        } else {
            selectedType = selectedObj.getType();
            objektAuswahlArt = selectedType.getAttributeGroups().contains(atgVerkehrsLageVerfahren1) ? ObjektAuswahlEnum.INSTANZ_ECHT : ObjektAuswahlEnum.INSTANZ_VIRTUELL;
        }
        switch (objektAuswahlArt) {
            case TYP_ECHT: {
                info = new ParameterInfo(selectedObj, selectedType, atgVerkehrsLageVerfahren1);
                break;
            }
            case INSTANZ_ECHT: {
                info = new ParameterInfo(selectedObj, atgVerkehrsLageVerfahren1);
                break;
            }
            case TYP_VIRTUELL: 
            case INSTANZ_VIRTUELL: {
                HashSet<SystemObjectType> possibleTypes = new HashSet<SystemObjectType>();
                possibleTypes.addAll(parents);
                possibleTypes.retainAll(ptypcache.getDirectParents(atgVerkehrsLageVerfahren1));
                SystemObjectType t = null;
                if (possibleTypes.isEmpty()) {
                    String s = "Keine echten Elternobjekte f\u00fcr Objekt " + selectedObj.toString();
                    Logger.getLogger(this.getClass().getName()).warning(s);
                    throw new IllegalArgumentException(s);
                }
                if (possibleTypes.size() > 1) {
                    System.out.print("Provide PID of type, possible values: ");
                    System.out.print(possibleTypes);
                    System.out.print(": ");
                    Scanner scanner = new Scanner(System.in);
                    String pid = "";
                    do {
                        pid = scanner.nextLine();
                    } while ((t = connection.getDataModel().getType(pid)) == null || !possibleTypes.contains(t));
                } else {
                    t = (SystemObjectType)possibleTypes.iterator().next();
                }
                info = new ParameterInfo(selectedObj, t, atgVerkehrsLageVerfahren1);
                break;
            }
            default: {
                String s = "Unbekannte Auswahlart " + (Object)((Object)objektAuswahlArt);
                Logger.getLogger(this.getClass().getName()).warning(s);
                throw new IllegalArgumentException(s);
            }
        }
        ParameterManager hierarchie = MethodenBibliothek.getParameterManager((ClientDavInterface)connection);
        Thread.sleep(2000L);
        Collection aenderbareObjekte = hierarchie.getAenderbareObjekte(info);
        if (aenderbareObjekte == null) {
            Logger.getLogger(this.getClass().getName()).warning("F\u00fcr ParameterInfo:\n" + info.toString() + "\nkonnten die betroffenen Objekte nicht ermittelt werden");
        } else {
            aenderbareObjekte.add(selectedObj);
            if (aenderbareObjekte.isEmpty()) {
                Logger.getLogger(this.getClass().getName()).info("F\u00fcr ParameterInfo:\n" + info.toString() + "\nsind keine Objekte betroffen");
            } else {
                Parameter[] einzelParameterIst;
                ArrayList aenderbareObjekteListe = new ArrayList(aenderbareObjekte.size());
                ArrayList<SystemObject> nichtAenderbareObjekteListe = new ArrayList<SystemObject>(aenderbareObjekte.size());
                aenderbareObjekteListe.addAll(aenderbareObjekte);
                Collections.sort(aenderbareObjekteListe, new SystemObjectComparatorAlphabetical(true));
                StringBuilder b = new StringBuilder("F\u00fcr ParameterInfo:\n");
                b.append(info.toString());
                b.append("\nsind folgende ");
                b.append(aenderbareObjekteListe.size());
                b.append(" Objekte potentiell betroffen:\n");
                Logger.getLogger(this.getClass().getName()).info("Bestimme Parameterquellen f\u00fcr " + aenderbareObjekte.size() + " Objekte...");
                ParameterInfo[] einzelInfos = new ParameterInfo[aenderbareObjekte.size()];
                int einzelInfosLoop = 0;
                for (SystemObject o : aenderbareObjekte) {
                    einzelInfos[einzelInfosLoop++] = new ParameterInfo(o, atgVerkehrsLageVerfahren1);
                }
                Parameter[] parameterArray = einzelParameterIst = hierarchie.getParameter(einzelInfos);
                int n = einzelParameterIst.length;
                int n2 = 0;
                while (n2 < n) {
                    Parameter p2 = parameterArray[n2];
                    SystemObject o = p2.getObjekt();
                    b.append(o.toString());
                    b.append(" --> Quelle: ");
                    b.append(p2.getQuelle().getTyp());
                    if (!ObjektAuswahlEnum.INSTANZ_ECHT.equals((Object)objektAuswahlArt) && !selectedObj.equals(o)) {
                        switch (p2.getQuelle().getTyp()) {
                            case LOKAL_OBJEKT: {
                                aenderbareObjekteListe.remove(o);
                                nichtAenderbareObjekteListe.add(o);
                                break;
                            }
                        }
                    }
                    b.append('\n');
                    ++n2;
                }
                Logger.getLogger(this.getClass().getName()).info(b.toString());
                Logger.getLogger(this.getClass().getName()).info("Zusammenfassung:\n  Potentiell betroffen: " + aenderbareObjekte.size() + " Objekte.\n  Wirklich betroffen: " + aenderbareObjekteListe.size() + " Objekte.");
                if (this.setzen) {
                    Data data = connection.createData(atgVerkehrsLageVerfahren1);
                    data.getUnscaledValue("v1").set(this.v1);
                    data.getUnscaledValue("v2").set(this.v2);
                    data.getUnscaledValue("k1").set(this.k1);
                    data.getUnscaledValue("k2").set(this.k2);
                    data.getItem("Urlasser").getReferenceValue("BenutzerReferenz").setSystemObject((SystemObject)connection.getLocalUser());
                    data.getItem("Urlasser").getTextValue("Ursache").setText(this.ursache);
                    data.getItem("Urlasser").getTextValue("Veranlasser").setText("");
                    Parameter parameterSoll = new Parameter(info, new DataWithTime(data, System.currentTimeMillis()));
                    hierarchie.setParameter(new Parameter[]{parameterSoll});
                }
                if (this.deleteNichtAenderbare) {
                    Parameter[] einzelParameterSoll = new Parameter[nichtAenderbareObjekteListe.size()];
                    int loop = 0;
                    while (loop < einzelParameterSoll.length) {
                        einzelParameterSoll[loop] = new Parameter(einzelInfos[loop]);
                        ++loop;
                    }
                    hierarchie.setParameter(einzelParameterSoll);
                }
            }
        }
        Parameter[] parameters = hierarchie.getParameter(new ParameterInfo[]{info});
        if (parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n3 = 0;
            while (n3 < n) {
                p = parameterArray[n3];
                System.out.println(p.getQuelle());
                ++n3;
            }
        }
        if (this.delete && parameters != null) {
            Parameter[] parameterArray = parameters;
            int n = parameters.length;
            int n4 = 0;
            while (n4 < n) {
                p = parameterArray[n4];
                p.setDataWithTime(null);
                hierarchie.setParameter(new Parameter[]{p});
                ++n4;
            }
        }
        System.exit(0);
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        this.selectedObjectPid = argumentList.fetchArgument("-selectedObjectPid").asString();
        this.v1 = argumentList.fetchArgument("-v1=41").intValueBetween(-3, 254);
        this.v2 = argumentList.fetchArgument("-v2=85").intValueBetween(-3, 254);
        this.k1 = argumentList.fetchArgument("-k1=12").intValueBetween(-3, 10000);
        this.k2 = argumentList.fetchArgument("-k2=43").intValueBetween(-3, 10000);
        this.delete = argumentList.fetchArgument("-delete=false").booleanValue();
        this.deleteNichtAenderbare = argumentList.fetchArgument("-deleteNichtAenderbare=false").booleanValue();
        this.setzen = argumentList.fetchArgument("-setzen=false").booleanValue();
        this.ursache = argumentList.fetchArgument("-ursache=Test des Param-Plug-In (AU)").asNonEmptyString();
    }

    public static void main(String[] args) {
        StandardApplicationRunner.run((StandardApplication)new VerkehrslageVerfahren1Parametrierer(), (String)"typ.applikation", (String[])args);
    }
}

