/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.viewer;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.puk.param.lib.Parameter;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractParameterKopierenViewer
extends ContentViewer {
    private final Group nachGroup;
    private Button kopierenButton;
    private Combo simulationsVarianteCombo;
    private short selectedSimulationsVariante = (short)-1;
    private final Composite mainControl;
    private final Group vonGroup;
    private final String dialogId;
    private final String hilfeId;

    public AbstractParameterKopierenViewer(Composite parent, String dialogId, String hilfeId) {
        this.dialogId = dialogId;
        this.hilfeId = hilfeId;
        ScrolledComposite scolledComposite = new ScrolledComposite(parent, 768);
        GridLayout slayout = new GridLayout(1, false);
        scolledComposite.setLayout((Layout)slayout);
        this.mainControl = new Composite((Composite)scolledComposite, 0);
        GridLayout layout = new GridLayout(3, false);
        this.mainControl.setLayout((Layout)layout);
        scolledComposite.setContent((Control)this.mainControl);
        scolledComposite.setExpandHorizontal(true);
        scolledComposite.setExpandVertical(true);
        scolledComposite.setMinWidth(800);
        scolledComposite.setMinHeight(300);
        this.vonGroup = new Group(this.mainControl, 0);
        GridLayout vonGroupLayout = new GridLayout(2, false);
        this.vonGroup.setLayout((Layout)vonGroupLayout);
        this.vonGroup.setText(this.getVonGroupLabel());
        GridData gd = new GridData(4, 4, false, false);
        this.vonGroup.setLayoutData((Object)gd);
        this.fillVonGroup();
        this.createKopierenButton();
        this.nachGroup = new Group(this.mainControl, 0);
        GridLayout nachGroupLayout = new GridLayout(2, false);
        this.nachGroup.setLayout((Layout)nachGroupLayout);
        this.nachGroup.setText(this.getNachGroupLabel());
        gd = new GridData(4, 4, true, false);
        this.nachGroup.setLayoutData((Object)gd);
        this.fillNachGroup();
    }

    protected abstract SelectionListener getKopierenButtonSelectionListener();

    protected abstract void fillVonGroup();

    protected abstract String getVonGroupLabel();

    protected abstract String getNachGroupLabel();

    protected abstract String getKopierenButtonText();

    protected abstract Image getKopierenButtonImage();

    protected abstract void fillNachGroup();

    protected void createKopierenButton() {
        this.kopierenButton = new Button(this.mainControl, 16392);
        this.kopierenButton.setText(this.getKopierenButtonText());
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 110;
        this.kopierenButton.setLayoutData((Object)gd);
        this.kopierenButton.setImage(this.getKopierenButtonImage());
        this.kopierenButton.setEnabled(false);
        this.kopierenButton.addSelectionListener(this.getKopierenButtonSelectionListener());
    }

    protected void createSimulationsVarianteCombo() {
        this.simulationsVarianteCombo = new Combo((Composite)this.nachGroup, 12);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 1;
        this.simulationsVarianteCombo.setLayoutData((Object)gd);
        this.simulationsVarianteCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Short s = (Short)AbstractParameterKopierenViewer.this.simulationsVarianteCombo.getData(AbstractParameterKopierenViewer.this.simulationsVarianteCombo.getText());
                if (s != null) {
                    AbstractParameterKopierenViewer.this.selectedSimulationsVariante = s;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Control getControl() {
        return this.mainControl;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    public short getSelectedSimulationsVariante() {
        return this.selectedSimulationsVariante;
    }

    protected void updateSimulationsVarianteCombo(Parameter p, IArtDesParametersatzesProvider backend) {
        this.simulationsVarianteCombo.removeAll();
        ArrayList<String> nameListe = new ArrayList<String>();
        String preSetText = null;
        int preSetSim = -1;
        for (Short s : backend.getValidSimlationsVarianten()) {
            String key = backend.getSimulationsVarianteString(s);
            if (p != null && p.getSim() == s.shortValue()) {
                preSetText = key;
                preSetSim = s.shortValue();
            }
            nameListe.add(key);
            this.simulationsVarianteCombo.setData(key, (Object)s);
        }
        this.simulationsVarianteCombo.setItems(nameListe.toArray(new String[nameListe.size()]));
        if (preSetText != null) {
            this.simulationsVarianteCombo.setText(preSetText);
            this.selectedSimulationsVariante = (short)preSetSim;
        }
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public String getHilfeId() {
        return this.hilfeId;
    }

    protected boolean isMultipleTargetsAllowed() {
        return true;
    }

    protected final Group getNachGroup() {
        return this.nachGroup;
    }

    protected final Button getKopierenButton() {
        return this.kopierenButton;
    }

    protected final Group getVonGroup() {
        return this.vonGroup;
    }
}

