/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.viewer;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.ArtDesParametersatzesContentProvider;
import de.bsvrz.buv.rw.basislib.kalender.DatumZeit;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ArtDesParametersatzesViewer
extends ContentViewer {
    private final ScrolledComposite mainControl;
    private final Button originalRadioButton;
    private final Button historischRadioButton;
    private final Button simulationRadioButton;
    private final Group mainGroup;
    private final Combo simulationsVarianteCombo;
    private boolean allowComboSelectionchanged = true;
    private final DatumZeit datumZeit;
    private ISelection currentSelection = new StructuredSelection();
    private final Button aktualisierenButton;

    public ArtDesParametersatzesViewer(Composite parent) {
        this.mainControl = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        this.mainControl.setLayout((Layout)layout);
        this.mainGroup = new Group((Composite)this.mainControl, 0);
        GridLayout mainGroupLayout = new GridLayout(3, false);
        this.mainGroup.setLayout((Layout)mainGroupLayout);
        this.mainGroup.setText("Art des Parametersatzes");
        this.mainGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.mainControl.setContent((Control)this.mainGroup);
        this.mainControl.setExpandHorizontal(true);
        this.mainControl.setExpandVertical(true);
        this.mainControl.setMinWidth(350);
        this.mainControl.setMinHeight(100);
        this.originalRadioButton = new Button((Composite)this.mainGroup, 16);
        GridData gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 3;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 16384;
        this.originalRadioButton.setLayoutData((Object)gd);
        this.originalRadioButton.setText(IArtDesParametersatzesProvider.ART_ORIGINAL);
        this.originalRadioButton.addSelectionListener((SelectionListener)new RadioButtonSelectionListener());
        this.simulationRadioButton = new Button((Composite)this.mainGroup, 16);
        gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        this.simulationRadioButton.setLayoutData((Object)gd);
        this.simulationRadioButton.setText(IArtDesParametersatzesProvider.ART_SIMULATION);
        this.simulationRadioButton.addSelectionListener((SelectionListener)new RadioButtonSelectionListener());
        Label l = new Label((Composite)this.mainGroup, 0);
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 131072;
        gd.verticalAlignment = 0x1000000;
        l.setLayoutData((Object)gd);
        l.setText("Variante:");
        this.simulationsVarianteCombo = new Combo((Composite)this.mainGroup, 12);
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 1;
        gd.minimumWidth = 100;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        this.simulationsVarianteCombo.setLayoutData((Object)gd);
        this.simulationsVarianteCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArtDesParametersatzesViewer.this.allowComboSelectionchanged) {
                    ArtDesParametersatzesViewer.this.buildAndPublishCurrentSelection();
                }
            }
        });
        this.historischRadioButton = new Button((Composite)this.mainGroup, 16);
        gd = new GridData(16384, 128, false, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        this.historischRadioButton.setLayoutData((Object)gd);
        this.historischRadioButton.setText(String.valueOf(IArtDesParametersatzesProvider.ART_HISTORISCH) + " vom:");
        this.historischRadioButton.addSelectionListener((SelectionListener)new RadioButtonSelectionListener());
        DatumZeit.Eingabetyp eingabeTyp = DatumZeit.Eingabetyp.datumuhrMS;
        this.datumZeit = new DatumZeit((Composite)this.mainGroup, 0, eingabeTyp, false, false);
        this.datumZeit.setToolTipText("Datum und Uhrzeit f\u00fcr die Archivabfrage");
        this.datumZeit.setLayout((Layout)new GridLayout());
        long initialTime = System.currentTimeMillis() - 3600000L;
        initialTime /= 1000L;
        this.datumZeit.setDatum(new Date(initialTime *= 1000L));
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        gd.minimumWidth = 130;
        this.datumZeit.setLayoutData((Object)gd);
        this.datumZeit.hinzufuegenSelektionsZuhoerer(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                long now = RahmenwerkService.getService().getObjektFactory().getDav().getTime();
                long newTime = ArtDesParametersatzesViewer.this.datumZeit.getDatum().getTime();
                if (newTime > now) {
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setText("Zukunft!");
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setImage(null);
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setEnabled(false);
                } else {
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setEnabled(true);
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setText("Aktualisieren");
                    ArtDesParametersatzesViewer.this.aktualisierenButton.setImage(ParamSharedImage.AKTUALISIEREN.getImage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.aktualisierenButton = new Button((Composite)this.mainGroup, 8);
        this.aktualisierenButton.setText("Aktualisieren");
        this.aktualisierenButton.setImage(ParamSharedImage.AKTUALISIEREN.getImage());
        this.aktualisierenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ArtDesParametersatzesViewer.this.getInput() != null && ArtDesParametersatzesViewer.this.getInput() instanceof IArtDesParametersatzesProvider) {
                    long now = RahmenwerkService.getService().getObjektFactory().getDav().getTime();
                    long newTime = ArtDesParametersatzesViewer.this.datumZeit.getDatum().getTime();
                    if (newTime > now) {
                        MessageDialog.openError(null, (String)"Fehler", (String)"Bitte w\u00e4hlen Sie einen Zeitpunkt aus der Vergangenheit!");
                    } else {
                        ArtDesParametersatzesViewer.this.buildAndPublishCurrentSelection();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData(16384, 128, true, false);
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        this.aktualisierenButton.setLayoutData((Object)gd);
    }

    public Control getControl() {
        return this.mainControl;
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void refresh() {
        if (this.getInput() instanceof IArtDesParametersatzesProvider && this.getContentProvider() instanceof ArtDesParametersatzesContentProvider) {
            IArtDesParametersatzesProvider backend = (IArtDesParametersatzesProvider)this.getInput();
            ArtDesParametersatzesContentProvider provider = (ArtDesParametersatzesContentProvider)this.getContentProvider();
            this.allowComboSelectionchanged = false;
            this.simulationsVarianteCombo.removeAll();
            ArrayList<String> nameListe = new ArrayList<String>();
            Object[] objectArray = provider.getElements(IArtDesParametersatzesProvider.ART_SIMULATION);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Short) {
                    short s = (Short)o;
                    String key = backend.getSimulationsVarianteString(s);
                    nameListe.add(key);
                    this.simulationsVarianteCombo.setData(key, (Object)s);
                }
                ++n2;
            }
            this.simulationsVarianteCombo.setItems(nameListe.toArray(new String[nameListe.size()]));
            Button selectedRadio = null;
            if (IArtDesParametersatzesProvider.ART_ORIGINAL.equals(backend.getArtDesParametersatzes())) {
                this.originalRadioButton.setSelection(true);
                selectedRadio = this.originalRadioButton;
                this.simulationRadioButton.setSelection(false);
                this.simulationsVarianteCombo.setEnabled(false);
                this.historischRadioButton.setSelection(false);
                this.datumZeit.setEnabled(false);
            } else if (IArtDesParametersatzesProvider.ART_SIMULATION.equals(backend.getArtDesParametersatzes())) {
                this.originalRadioButton.setSelection(false);
                this.simulationRadioButton.setSelection(true);
                selectedRadio = this.simulationRadioButton;
                this.simulationsVarianteCombo.setEnabled(true);
                this.historischRadioButton.setSelection(false);
                this.datumZeit.setEnabled(false);
                this.datumZeit.setDatum(new Date(backend.getZeitpunkt()));
            } else if (IArtDesParametersatzesProvider.ART_HISTORISCH.equals(backend.getArtDesParametersatzes())) {
                this.originalRadioButton.setSelection(false);
                this.simulationRadioButton.setSelection(false);
                this.simulationsVarianteCombo.setEnabled(false);
                this.historischRadioButton.setSelection(true);
                selectedRadio = this.historischRadioButton;
                this.datumZeit.setEnabled(true);
                this.datumZeit.setDatum(new Date(backend.getZeitpunkt()));
            }
            String text = backend.getSimulationsVarianteString(backend.getSelectedSimulationsVariante());
            if (nameListe.contains(text)) {
                this.simulationsVarianteCombo.setText(text);
            }
            this.allowComboSelectionchanged = true;
            this.enableOrDisableControls(selectedRadio);
            this.getControl().redraw();
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.originalRadioButton.setSelection(false);
        this.simulationRadioButton.setSelection(false);
        this.historischRadioButton.setSelection(false);
        if (this.getInput() instanceof IArtDesParametersatzesProvider && !selection.isEmpty() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof String) {
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            String selectedRadio = (String)iterator.next();
            if (IArtDesParametersatzesProvider.ART_ORIGINAL.equals(selectedRadio)) {
                this.originalRadioButton.setSelection(true);
            } else if (IArtDesParametersatzesProvider.ART_SIMULATION.equals(selectedRadio) && iterator.hasNext()) {
                this.simulationRadioButton.setSelection(true);
                Short s = (Short)iterator.next();
                IArtDesParametersatzesProvider backend = (IArtDesParametersatzesProvider)this.getInput();
                String text = backend.getSimulationsVarianteString(s);
                this.simulationsVarianteCombo.setText(text);
            } else if (IArtDesParametersatzesProvider.ART_HISTORISCH.equals(selectedRadio)) {
                this.historischRadioButton.setSelection(true);
                IArtDesParametersatzesProvider backend = (IArtDesParametersatzesProvider)this.getInput();
                this.datumZeit.setDatum(new Date(backend.getZeitpunkt()));
            } else {
                throw new IllegalArgumentException("Ung\u00fcltige Selektion: " + selectedRadio);
            }
            this.currentSelection = selection;
        }
    }

    protected void buildAndPublishCurrentSelection() {
        Object selection;
        if (this.originalRadioButton.getSelection()) {
            selection = new StructuredSelection((Object)IArtDesParametersatzesProvider.ART_ORIGINAL);
        } else if (this.simulationRadioButton.getSelection()) {
            Short selectedSimulationsVariante = 1000;
            Short s = (Short)this.simulationsVarianteCombo.getData(this.simulationsVarianteCombo.getText());
            if (s != null) {
                selectedSimulationsVariante = s;
            }
            selection = selectedSimulationsVariante < 1000 ? new StructuredSelection(new Object[]{IArtDesParametersatzesProvider.ART_SIMULATION, selectedSimulationsVariante}) : this.currentSelection;
        } else if (this.historischRadioButton.getSelection()) {
            Timestamp timestamp = new Timestamp(this.datumZeit.getDatum().getTime());
            selection = new StructuredSelection(new Object[]{IArtDesParametersatzesProvider.ART_HISTORISCH, timestamp});
        } else {
            selection = new StructuredSelection();
        }
        this.currentSelection = selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection));
    }

    private void enableOrDisableControls(Button selectedRadio) {
        if (selectedRadio == this.originalRadioButton) {
            this.simulationsVarianteCombo.setEnabled(false);
            this.datumZeit.setEnabled(false);
            this.aktualisierenButton.setEnabled(false);
        } else if (selectedRadio == this.simulationRadioButton) {
            this.simulationsVarianteCombo.setEnabled(true);
            this.datumZeit.setEnabled(false);
            this.aktualisierenButton.setEnabled(false);
        } else if (selectedRadio == this.historischRadioButton) {
            this.simulationsVarianteCombo.setEnabled(false);
            boolean historischEnabled = false;
            if (this.getInput() instanceof IArtDesParametersatzesProvider) {
                IArtDesParametersatzesProvider backend = (IArtDesParametersatzesProvider)this.getInput();
                historischEnabled = backend.isArchivAvailable();
            }
            this.datumZeit.setEnabled(historischEnabled);
            if (historischEnabled) {
                this.aktualisierenButton.setEnabled(historischEnabled);
                this.aktualisierenButton.setText("Aktualisieren");
            } else {
                this.aktualisierenButton.setEnabled(true);
                this.aktualisierenButton.setText("Kein Archiv!");
                this.aktualisierenButton.setEnabled(false);
            }
        }
    }

    private final class RadioButtonSelectionListener
    implements SelectionListener {
        private boolean first = true;

        private RadioButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ArtDesParametersatzesViewer.this.getInput() instanceof IArtDesParametersatzesProvider && e.widget instanceof Button && ((Button)e.widget).getSelection() && (!this.first || e.widget != ArtDesParametersatzesViewer.this.originalRadioButton)) {
                ArtDesParametersatzesViewer.this.enableOrDisableControls((Button)e.widget);
                ArtDesParametersatzesViewer.this.buildAndPublishCurrentSelection();
            }
            this.first = false;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

