/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.viewer;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.AbstractParamPluginTableLabelProvider;
import de.bsvrz.buv.plugin.param.provider.helper.MehrfachauswahlDialog;
import de.bsvrz.buv.plugin.param.viewer.AbstractParameterKopierenViewer;
import de.bsvrz.buv.plugin.param.viewer.MehrereParameterKopierenButtonSelectionAdapter;
import de.bsvrz.puk.param.lib.Parameter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MehrereParameterKopierenViewer
extends AbstractParameterKopierenViewer {
    private TableViewer vonTableViewer;

    public MehrereParameterKopierenViewer(Composite parent, String dialogId, String hilfeId) {
        super(parent, dialogId, hilfeId);
    }

    @Override
    protected void fillNachGroup() {
        GridLayout nachGroupLayout = new GridLayout(1, false);
        this.getNachGroup().setLayout((Layout)nachGroupLayout);
        Label l = new Label((Composite)this.getNachGroup(), 0);
        l.setText("Objekte: Wie auf der VON-Seite");
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = 1;
        l.setLayoutData((Object)gd);
        l = new Label((Composite)this.getNachGroup(), 0);
        l.setText("Simulationsvariante:");
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = 1;
        l.setLayoutData((Object)gd);
        this.createSimulationsVarianteCombo();
        gd = (GridData)this.getNachGroup().getLayoutData();
        gd.grabExcessHorizontalSpace = false;
    }

    @Override
    protected void fillVonGroup() {
        Table table = new Table((Composite)this.getVonGroup(), 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 400;
        gd.heightHint = 220;
        table.setLayoutData((Object)gd);
        AbstractParamPluginTableLabelProvider labelProvider = new AbstractParamPluginTableLabelProvider(){

            @Override
            public String getColumnId(int columnIndex) {
                String text = "unbekannt";
                switch (columnIndex) {
                    case 0: {
                        text = "Objekt";
                        break;
                    }
                    case 1: {
                        text = "Simulationsvariante";
                        break;
                    }
                    case 2: {
                        text = "Parameterquelle";
                        break;
                    }
                    case 3: {
                        text = "Typ der Quelle";
                        break;
                    }
                }
                return text;
            }

            @Override
            public int getNumColumns() {
                return 4;
            }
        };
        int columnIndex = 0;
        while (columnIndex < labelProvider.getNumColumns()) {
            TableColumn column = new TableColumn(table, 0);
            String columnId = labelProvider.getColumnId(columnIndex);
            column.setText(columnId);
            column.setWidth(labelProvider.getPreferredColumnWidth(columnId));
            ++columnIndex;
        }
        this.vonTableViewer = new TableViewer(table);
        this.vonTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.vonTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled;
                boolean bl = enabled = !event.getSelection().isEmpty();
                if (((IStructuredSelection)event.getSelection()).size() > 1 && MehrfachauswahlDialog.isEnabled()) {
                    MehrfachauswahlDialog mad = new MehrfachauswahlDialog(null, MehrereParameterKopierenViewer.this.getHilfeId());
                    int userResponse = mad.open();
                    enabled = userResponse == 0;
                }
                MehrereParameterKopierenViewer.this.getKopierenButton().setEnabled(enabled);
            }
        });
        GridData vonGroupGridData = (GridData)this.getVonGroup().getLayoutData();
        vonGroupGridData.grabExcessHorizontalSpace = true;
    }

    @Override
    protected SelectionListener getKopierenButtonSelectionListener() {
        return new MehrereParameterKopierenButtonSelectionAdapter(this);
    }

    public ISelection getSelection() {
        return this.vonTableViewer.getSelection();
    }

    public void refresh() {
        if (this.getInput() instanceof Parameter[]) {
            Parameter[] parameters = (Parameter[])this.getInput();
            Parameter p = parameters[0];
            IArtDesParametersatzesProvider backend = RahmenwerkService.getService().getArtDesParametersatzesProvider();
            this.vonTableViewer.setContentProvider(this.getContentProvider());
            this.vonTableViewer.setInput((Object)parameters);
            this.updateSimulationsVarianteCombo(p, backend);
            this.getKopierenButton().setEnabled(!this.getSelection().isEmpty());
        } else {
            this.vonTableViewer.setInput(null);
            this.getKopierenButton().setEnabled(false);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.vonTableViewer.setSelection(selection, reveal);
    }

    @Override
    protected String getNachGroupLabel() {
        return "Nach";
    }

    @Override
    protected String getVonGroupLabel() {
        return "Von";
    }

    @Override
    protected String getKopierenButtonText() {
        return "Kopieren";
    }

    @Override
    protected Image getKopierenButtonImage() {
        return ParamSharedImage.KOPIEREN.getImage();
    }
}

