/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.param.viewer;

import de.bsvrz.buv.plugin.param.IArtDesParametersatzesProvider;
import de.bsvrz.buv.plugin.param.ParamSharedImage;
import de.bsvrz.buv.plugin.param.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.param.provider.helper.MehrfachauswahlDialog;
import de.bsvrz.buv.plugin.param.viewer.AbstractParameterKopierenViewer;
import de.bsvrz.buv.plugin.param.viewer.ParameterKopierenButtonSelectionAdapter;
import de.bsvrz.puk.param.lib.Parameter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;

public class ParameterKopierenViewer
extends AbstractParameterKopierenViewer {
    private static final Label[] VON_LABELS_VALUES = new Label[5];
    private static final String[] VON_LABELS_KEYS = new String[]{"Objekt:", "Typ:", "Attributgruppe:", "Sim.Var.:", "Quelltyp:"};
    private TreeViewer nachTreeViewer;

    public ParameterKopierenViewer(Composite parent, String dialogId, String hilfeId) {
        super(parent, dialogId, hilfeId);
        Assert.isTrue((VON_LABELS_KEYS.length == VON_LABELS_VALUES.length ? 1 : 0) != 0);
    }

    @Override
    protected void fillNachGroup() {
        int style = 2048;
        style = this.isMultipleTargetsAllowed() ? (style |= 2) : (style |= 4);
        Tree tree = new Tree((Composite)this.getNachGroup(), style);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 220;
        tree.setLayoutData((Object)gd);
        this.nachTreeViewer = new TreeViewer(tree);
        this.nachTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled;
                boolean bl = enabled = !event.getSelection().isEmpty();
                if (((IStructuredSelection)event.getSelection()).size() > 1 && MehrfachauswahlDialog.isEnabled()) {
                    MehrfachauswahlDialog mad = new MehrfachauswahlDialog(null, ParameterKopierenViewer.this.getHilfeId());
                    int userResponse = mad.open();
                    enabled = userResponse == 0;
                }
                ParameterKopierenViewer.this.getKopierenButton().setEnabled(enabled);
            }
        });
        this.nachTreeViewer.setComparator(new ViewerComparator());
        Label l = new Label((Composite)this.getNachGroup(), 0);
        l.setText(VON_LABELS_KEYS[3]);
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalSpan = 1;
        l.setLayoutData((Object)gd);
        this.createSimulationsVarianteCombo();
    }

    @Override
    protected void fillVonGroup() {
        int loop = 0;
        while (loop < VON_LABELS_KEYS.length) {
            Label l = new Label((Composite)this.getVonGroup(), 0);
            l.setText(VON_LABELS_KEYS[loop]);
            GridData gd = new GridData(4, 4, false, false);
            l.setLayoutData((Object)gd);
            l = new Label((Composite)this.getVonGroup(), 0);
            l.setText("Keine Quelle f\u00fcr Kopieraktion!");
            gd = new GridData(4, 4, true, false);
            gd.widthHint = 310;
            l.setLayoutData((Object)gd);
            ParameterKopierenViewer.VON_LABELS_VALUES[loop] = l;
            ++loop;
        }
    }

    @Override
    protected SelectionListener getKopierenButtonSelectionListener() {
        return new ParameterKopierenButtonSelectionAdapter(this);
    }

    public ISelection getSelection() {
        return this.nachTreeViewer.getSelection();
    }

    public void refresh() {
        if (this.getInput() instanceof Parameter[]) {
            Parameter[] parameters = (Parameter[])this.getInput();
            Parameter p = parameters[0];
            IArtDesParametersatzesProvider backend = RahmenwerkService.getService().getArtDesParametersatzesProvider();
            VON_LABELS_VALUES[0].setText(p.getObjekt().getName());
            VON_LABELS_VALUES[1].setText(p.getTyp().getName());
            VON_LABELS_VALUES[2].setText(p.getAtg().getName());
            VON_LABELS_VALUES[3].setText(backend.getSimulationsVarianteString(p.getSim()));
            VON_LABELS_VALUES[4].setText(p.getQuelle().getTyp().toString());
            this.nachTreeViewer.setContentProvider(this.getContentProvider());
            this.nachTreeViewer.setLabelProvider(this.getLabelProvider());
            this.nachTreeViewer.setInput((Object)parameters);
            this.updateSimulationsVarianteCombo(p, backend);
        } else {
            int loop = 0;
            while (loop < VON_LABELS_VALUES.length) {
                VON_LABELS_VALUES[loop].setText("Keine Quelle f\u00fcr Kopieraktion!");
                ++loop;
            }
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.nachTreeViewer.setSelection(selection, reveal);
    }

    @Override
    protected String getNachGroupLabel() {
        return "Nach";
    }

    @Override
    protected String getVonGroupLabel() {
        return "Von";
    }

    @Override
    protected String getKopierenButtonText() {
        return "Kopieren";
    }

    @Override
    protected Image getKopierenButtonImage() {
        return ParamSharedImage.ARROW_RIGHT.getImage();
    }
}

