/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkaaxl;

import de.bsvrz.buv.plugin.tkaaxl.HOT_AXL;
import de.bsvrz.buv.plugin.tkaaxl.TkaAxlActivator;
import de.bsvrz.buv.plugin.tkabasis.DataFactory;
import de.bsvrz.buv.plugin.tkabasis.LookupFactory;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HODaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HOHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HOMitStatus;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HierarchieObjekt;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieManager;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieObjektTyp;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.MengeInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.SystemObjektDaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.TypInfo;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.IPruefungen;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.LoeschenChecker;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.PruefungenTools;
import de.bsvrz.buv.plugin.tkabasis.regeln.IBildungsRegeln;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.ConfigurationObjectType;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.ObjectSet;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.ReferenceType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import de.bsvrz.puk.config.configFile.datamodel.ConfigSystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class HierachieManagerAXL
implements IHierarchieManager {
    private static final Debug LOGGER = Debug.getLogger();
    private static final IHierarchieObjektTyp[] EBENE1 = new IHierarchieObjektTyp[]{HOT_AXL.AXLMS};
    private IHierarchie hierarchie;

    public IHierarchie getHierarchie() {
        return this.hierarchie;
    }

    public void setHierarchie(IHierarchie hierarchie) {
        this.hierarchie = hierarchie;
    }

    public void bestimmeUntergeordneteHOs(Object objekt) {
        if (objekt instanceof ConfigurationArea) {
            ConfigurationArea kb = (ConfigurationArea)objekt;
            IHierarchieObjektTyp[] iHierarchieObjektTypArray = EBENE1;
            int n = EBENE1.length;
            int n2 = 0;
            while (n2 < n) {
                IHierarchieObjektTyp hot = iHierarchieObjektTypArray[n2];
                String typPid = (String)hot.getTypen().get(0);
                SystemObjectType typ = this.hierarchie.getDataModel().getType(typPid);
                if (typ == null) {
                    throw new IllegalStateException("Typ " + typPid + " wurde im aktuellen Datemmodell nicht gefunden");
                }
                ArrayList<SystemObjectType> typeSpez = new ArrayList<SystemObjectType>(1);
                typeSpez.add(typ);
                for (SystemObject so : kb.getObjects(typeSpez, ObjectTimeSpecification.valid())) {
                    ConfigurationObject ko = (ConfigurationObject)so;
                    if (ko.getNotValidSince() >= ko.getConfigurationArea().getModifiableVersion()) continue;
                    HierarchieObjekt ho = new HierarchieObjekt(hot, new SystemObject[]{so}, EBENE1);
                    this.hierarchie.objektHinzufuegen((Object)kb, ho);
                    this.bestimmeUntergeordneteHOs(ho);
                }
                for (SystemObject so : kb.getNewObjects()) {
                    if (!so.isOfType(typ)) continue;
                    HierarchieObjekt ho = new HierarchieObjekt(hot, new SystemObject[]{so}, EBENE1);
                    this.hierarchie.objektHinzufuegen((Object)kb, ho);
                    this.bestimmeUntergeordneteHOs(ho);
                }
                ++n2;
            }
        }
    }

    public IHierarchieObjektTyp[] getUntergeordneteHOTs(Object objekt) {
        if (objekt instanceof ConfigurationArea) {
            return EBENE1;
        }
        return new IHierarchieObjektTyp[0];
    }

    private List<ObjectSet> erzeugeMengen(IHierarchieObjektTyp hot, SystemObjectType typ, ConfigurationArea kb, MultiStatus status) {
        ArrayList<ObjectSet> result = new ArrayList<ObjectSet>();
        for (String mengenName : hot.getTypInfo(typ.getPid()).getMengen()) {
            ObjectSet menge;
            MengeInfo info = hot.getTypInfo(typ.getPid()).getMengeInfo(mengenName);
            SystemObjectType mengenTyp = this.hierarchie.getDataModel().getType(info.getTyp());
            try {
                menge = (ObjectSet)kb.createConfigurationObject((ConfigurationObjectType)mengenTyp, "", mengenName, null);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Menge " + mengenName + " vom Typ " + mengenTyp.getPid() + " erzeugt"));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim Erzeugen der Menge " + mengenName + " vom Typ " + mengenTyp.getName() + " erzeugt", (Throwable)e));
                return result;
            }
            result.add(menge);
        }
        return result;
    }

    private SystemObject erzeugeSystemObjekt(String pid, ConfigurationObjectType typ, ConfigurationArea kb, List<ObjectSet> mengen, MultiStatus status) {
        ConfigurationObject result = null;
        try {
            result = kb.createConfigurationObject(typ, pid, "", mengen);
            if (mengen != null && !mengen.isEmpty()) {
                MultiStatus unterStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " erzeugt", null);
                status.add((IStatus)unterStatus);
                for (ObjectSet set : mengen) {
                    unterStatus.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Menge " + set.getName() + " dem Systemobjekt " + pid + " vom Typ " + typ.getPid() + " zugewiesen"));
                }
            } else {
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " erzeugt"));
            }
        }
        catch (ConfigurationChangeException e) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " konnte nicht erzeugt werden", (Throwable)e));
        }
        return result;
    }

    public HOMitStatus erzeugeNeuesHO(ConfigurationArea kb, Object vater, String[] pid, IHierarchieObjektTyp hot, boolean pruefePid) {
        ConfigDataModel dataModel = this.hierarchie.getDataModel();
        ConfigurationObjectType typ = (ConfigurationObjectType)dataModel.getType((String)hot.getTypen().get(0));
        if (typ == null) {
            throw new IllegalArgumentException("F\u00fcr " + (String)hot.getTypen().get(0) + " kann kein Typ im Datenmodell bestimmt werden");
        }
        HierarchieObjekt ho = null;
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Erzeuge neues Hierarchieobjekt vom Typ " + hot, null);
        if (pruefePid) {
            status.add(new PruefungenTools(dataModel).pruefePid(pid[0]));
        }
        if (!status.matches(12)) {
            List<ObjectSet> mengen = this.erzeugeMengen(hot, (SystemObjectType)typ, kb, status);
            if (!status.matches(12)) {
                SystemObject so = this.erzeugeSystemObjekt(pid[0], typ, kb, mengen, status);
                if (!status.matches(12)) {
                    ho = new HierarchieObjekt(hot, new SystemObject[]{so}, EBENE1);
                    this.getHierarchie().objektHinzufuegen(vater, ho);
                }
            }
        }
        return new HOMitStatus(ho, (IStatus)status);
    }

    public HOMitStatus kopiereHO(HierarchieObjekt ho, ConfigurationArea kb, Object neuerVater, String[] neuePid, boolean rekursiv, boolean isWurzel) {
        return this.kopiereHO(ho, kb, neuerVater, neuePid, rekursiv, true, true);
    }

    private HOMitStatus kopiereHO(HierarchieObjekt ho, ConfigurationArea kb, Object neuerVater, String[] neuePid, boolean rekursiv, boolean anwendenBR, boolean pruefePid) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Hierarchieobjekt " + ho, null);
        String[] pid = neuePid;
        if (pid == null) {
            pid = new String[]{ho.getSystemObjekt(0).getPid()};
        }
        HOMitStatus result = this.erzeugeNeuesHO(kb, neuerVater, pid, ho.getHierarchieObjektTyp(), pruefePid);
        HierarchieObjekt neu = result.getHO();
        status.add(result.getStatus());
        if (!status.matches(12)) {
            status.merge((IStatus)this.kopiereDaten(ho, result.getHO(), anwendenBR, anwendenBR));
        }
        if (!status.matches(12) && rekursiv) {
            for (HierarchieObjekt lauf : this.hierarchie.getUntergeordneteObjekte((Object)ho)) {
                MultiStatus meldung = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere untergeordnetes Hierarchieobjekt " + lauf + " zu " + ho, null);
                result = this.kopiereHO(lauf, kb, neu, null, true, anwendenBR, pruefePid);
                meldung.merge(result.getStatus());
                status.add((IStatus)meldung);
                if (status.matches(12)) break;
            }
        }
        return new HOMitStatus(neu, (IStatus)status);
    }

    private MultiStatus kopiereDaten(HierarchieObjekt srcHO, HierarchieObjekt destHO, boolean bildungsRegelnFuerName, boolean bildungsRegelnFuerAtg) {
        if (!srcHO.getHierarchieObjektTyp().equals(destHO.getHierarchieObjektTyp())) {
            throw new IllegalArgumentException("Beide \u00fcbergebenen Hierarchieobjekte m\u00fcssen vom gleichen Hierarchieobjekttyp sein");
        }
        int index = 0;
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Daten von " + srcHO + " nach " + destHO, null);
        IBildungsRegeln br = TkaAxlActivator.getDefault().getDatenSpeicher().getBildungsRegeln();
        ConfigDataModel dataModel = this.hierarchie.getDataModel();
        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
        for (SystemObject src : srcHO.getSystemObjekte()) {
            SystemObject dest = (SystemObject)destHO.getSystemObjekte().get(index);
            String name = bildungsRegelnFuerName ? br.getName(dest) : src.getName();
            try {
                dest.setName(name);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Setze Name \"" + name + "\" f\u00fcr Systemobjekt " + dest.getPid()));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + name + "\" f\u00fcr Systemobjekt " + dest.getPid() + " konnte nicht gesetzt werden", (Throwable)e));
                return status;
            }
            for (AttributeGroupUsage atgu : src.getUsedAttributeGroupUsages()) {
                Data dataSrc = ((ConfigSystemObject)src).getConfigurationData(atgu, lookup);
                if (dataSrc == null) continue;
                try {
                    Data dataDest = DataFactory.createModifiableCopy((Data)dataSrc, (ObjectLookup)lookup);
                    if (bildungsRegelnFuerAtg) {
                        dataDest = br.getDatensatz(destHO, dest, atgu.getAttributeGroup(), dataDest, true);
                    }
                    dest.setConfigurationData(atgu, dataDest);
                    status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Kopiere Daten der ATG-Verwendung " + atgu.getAttributeGroup().getPid() + "/" + atgu.getAspect().getPid() + " f\u00fcr Systemobjekt " + dest.getPid()));
                }
                catch (ConfigurationChangeException e) {
                    status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Daten der ATG-Verwendung " + atgu.getAttributeGroup().getPid() + "/" + atgu.getAspect().getPid() + " f\u00fcr Systemobjekt " + dest.getPid() + " konnten nicht kopiert werden", (Throwable)e));
                    return status;
                }
            }
            ++index;
        }
        return status;
    }

    public HOMitStatus verschiebeHO(HierarchieObjekt ho, Object neuerVater) {
        Object alterVater = this.hierarchie.getUebergeordnetesObjekt(ho);
        ConfigurationArea srcKB = this.hierarchie.getKonfigurationsBereich(alterVater);
        Assert.isNotNull((Object)srcKB, (String)("Der Konfigurationsbereich zu " + alterVater + " darf nicht null sein"));
        ConfigurationArea destKB = this.hierarchie.getKonfigurationsBereich(neuerVater);
        Assert.isNotNull((Object)destKB, (String)("Der Konfigurationsbereich zu " + neuerVater + " darf nicht null sein"));
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Verschiebe Hierarchieobjekt " + ho, null);
        HierarchieObjekt neu = null;
        if (srcKB.equals(destKB)) {
            if (neuerVater.equals(alterVater)) {
                status.add((IStatus)new Status(1, "de.bsvrz.buv.plugin.tkabasis", "Objekt " + ho + " kann nicht in sich selbst verschoben werden"));
            }
        } else {
            HOHierarchie hoHierarchie = new HOHierarchie(ho, this.hierarchie);
            status.add((IStatus)this.loescheHO(ho));
            if (!status.matches(12)) {
                HOMitStatus result = this.kopiereHORekursiv(hoHierarchie.getWurzel(), destKB, neuerVater, hoHierarchie);
                status.add(result.getStatus());
                neu = result.getHO();
            }
        }
        return new HOMitStatus(neu, (IStatus)status);
    }

    private HOMitStatus kopiereHORekursiv(HierarchieObjekt ho, ConfigurationArea kb, Object vater, HOHierarchie srcHierarchie) {
        MultiStatus meldung = ho == srcHierarchie.getWurzel() ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Hierarchieobjekt " + ho, null) : new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere untergeordnetes Hierarchieobjekt " + ho + " zu " + vater, null);
        HOMitStatus result = this.kopiereHO(ho, kb, vater, null, false, false, false);
        meldung.merge(result.getStatus());
        HierarchieObjekt neu = result.getHO();
        if (neu != null) {
            for (HierarchieObjekt kind : srcHierarchie.getUntergeordneteObjekte(ho)) {
                result = this.kopiereHORekursiv(kind, kb, neu, srcHierarchie);
                meldung.add(result.getStatus());
            }
        }
        return new HOMitStatus(neu, (IStatus)meldung);
    }

    public MultiStatus loescheHO(HierarchieObjekt ho) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "L\u00f6sche Hierarchieobjekt " + ho, null);
        this.loescheHO(ho, status);
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private void loescheHO(HierarchieObjekt ho, MultiStatus status) {
        vater = this.getHierarchie().getUebergeordnetesObjekt(ho);
        if (vater == null) {
            throw new IllegalArgumentException("Kein \u00fcbergeordnetes Objekt f\u00fcr " + ho + " gefunden  in der Hierarchie AXL Achslast");
        }
        hot = ho.getHierarchieObjektTyp();
        if (!Arrays.asList(HierachieManagerAXL.EBENE1).contains(hot) || vater instanceof ConfigurationArea) ** GOTO lbl13
        throw new IllegalArgumentException("Als \u00fcbergeordnetes Objekt ist nur ein Konfigurationsbereich zul\u00e4ssig");
lbl-1000:
        // 1 sources

        {
            objekt = (HierarchieObjekt)this.getHierarchie().getUntergeordneteObjekte((Object)ho).get(0);
            unterStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "L\u00f6sche Hierarchieobjekt " + objekt, null);
            this.loescheHO(objekt, unterStatus);
            status.add((IStatus)unterStatus);
            if (!unterStatus.matches(12)) continue;
            return;
lbl13:
            // 2 sources

            ** while (!this.getHierarchie().getUntergeordneteObjekte((Object)ho).isEmpty())
        }
lbl14:
        // 1 sources

        ko = (ConfigurationObject)ho.getSystemObjekte().get(0);
        try {
            ko.invalidate();
            status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " gel\u00f6scht."));
        }
        catch (ConfigurationChangeException e) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " konnte nicht gel\u00f6scht werden.", (Throwable)e));
            return;
        }
        catch (RuntimeException e) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " konnte nicht gel\u00f6scht werden.", (Throwable)e));
            return;
        }
        this.getHierarchie().objektEntfernen(vater, ho);
    }

    public IStatus pruefeDaten(HierarchieObjekt ho, HODaten daten) {
        SystemObjektDaten soDaten;
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        IPruefungen pruefInstanz = TkaAxlActivator.getDefault().getDatenSpeicher().getPruefungen();
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Hierarchieobjekt " + ho, null);
        result.merge(pruefInstanz.pruefeHierarchieObjekt(ho, daten));
        LoeschenChecker loeschenChecker = new LoeschenChecker((IHierarchieManager)this);
        ArrayList<SystemObject> liste = new ArrayList<SystemObject>();
        StringBuffer aend = new StringBuffer();
        StringBuffer loesch = new StringBuffer();
        for (SystemObject so : ho.getSystemObjekte()) {
            soDaten = daten.getSystemObjektDaten(so);
            if (so.getPid().equals(soDaten.getPid())) continue;
            liste.add(so);
            if (aend.length() > 0) {
                aend.append(", ");
            }
            aend.append(soDaten.getPid());
            if (loesch.length() > 0) {
                loesch.append(", ");
            }
            loesch.append(so.getPid());
        }
        if (!liste.isEmpty()) {
            MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Durch PID-\u00c4nderung(en) auf " + aend + " werden folgende Objekte gel\u00f6scht: " + loesch, null);
            boolean flag = this.verwendeZuLoeschendeObjekteZurPruefungOffeneReferenzen();
            status.add(loeschenChecker.bestimmeOffeneReferenzen(liste, flag));
            result.add((IStatus)status);
        }
        for (SystemObject so : ho.getSystemObjekte()) {
            soDaten = daten.getSystemObjektDaten(so);
            if (soDaten != null) {
                MultiStatus objektStatus = ho.getSystemObjekte().size() > 1 ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe ATG-Daten f\u00fcr Systemobjekt " + so.getPid() + " vom Typ " + so.getType().getPid(), null) : result;
                TypInfo typInfo = hot.getTypInfo(so.getType().getPid());
                if (typInfo != null) {
                    for (String atgPid : typInfo.getAtgs()) {
                        AtgInfo atgInfo = typInfo.getAtgInfo(atgPid);
                        if (atgInfo != null) {
                            Data data = soDaten.getAtgDaten(atgPid);
                            if (data == null && (atgInfo.isMandatory() || !atgInfo.isOptional())) {
                                objektStatus.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "F\u00fcr die nicht-optionale ATG " + atgPid + " sind keine Daten vorhanden"));
                            }
                            if (data == null) continue;
                            MultiStatus atgStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Daten der ATG " + atgPid, null);
                            atgStatus.merge(pruefInstanz.pruefeDaten(ho, so, atgInfo, data));
                            objektStatus.add((IStatus)atgStatus);
                            continue;
                        }
                        throw new IllegalStateException("AtgInfo f\u00fcr ATG " + atgPid + " fehlt in TypInfo f\u00fcr " + so.getType().getPid() + " im HierarchieObjektTyp " + hot);
                    }
                } else {
                    throw new IllegalStateException("TypInfo fehlt f\u00fcr  " + so.getType().getPid() + " im HierarchieObjektTyp " + hot);
                }
                if (result.equals(objektStatus)) continue;
                result.add((IStatus)objektStatus);
                continue;
            }
            throw new IllegalStateException("Daten f\u00fcr Systemobjekt " + so.getPid() + " erforderlich, aber nicht \u00fcbergeben");
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigurationObject dupliziereObjekt(ConfigurationObject ko, String neuePid) throws ConfigurationChangeException {
        block9: {
            sets = new ArrayList<ObjectSet>();
            neu = null;
            result = null;
            try {
                for (ObjectSet set : ko.getObjectSets()) {
                    setTyp = set.getObjectSetType();
                    if (!HierachieManagerAXL.$assertionsDisabled && setTyp.getReferenceType() == ReferenceType.COMPOSITION) {
                        throw new AssertionError();
                    }
                    menge = (ObjectSet)ko.getConfigurationArea().createConfigurationObject((ConfigurationObjectType)set.getObjectSetType(), "", set.getName(), null);
                    elemente = set instanceof NonMutableSet != false ? ((NonMutableSet)set).getElementsInModifiableVersion() : set.getElements();
                    menge.add(elemente.toArray(new SystemObject[elemente.size()]));
                    sets.add(menge);
                }
                kbPid = neuePid;
                if (kbPid == null) {
                    kbPid = ko.getPid();
                }
                neu = ko.getConfigurationArea().createConfigurationObject((ConfigurationObjectType)ko.getType(), kbPid, ko.getName(), sets);
                lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)((ConfigDataModel)ko.getDataModel()));
                for (AttributeGroupUsage atgu : ko.getUsedAttributeGroupUsages()) {
                    dataSrc = ((ConfigSystemObject)ko).getConfigurationData(atgu, lookup);
                    if (dataSrc == null) continue;
                    dataDest = DataFactory.createModifiableCopy((Data)dataSrc, (ObjectLookup)lookup);
                    neu.setConfigurationData(atgu, dataDest);
                }
                result = neu;
            }
            finally {
                if (result != null) break block9;
                ** for (set : sets)
            }
lbl-1000:
            // 1 sources

            {
                set.invalidate();
                continue;
            }
lbl33:
            // 1 sources

            if (neu != null) {
                neu.invalidate();
            }
        }
        return result;
    }

    private ConfigurationObject behandleSystemObjektAendeung(ConfigurationObject ko, String neuePid) throws ConfigurationChangeException {
        ConfigurationObject result = this.dupliziereObjekt(ko, neuePid);
        ko.invalidate();
        return result;
    }

    public MultiStatus uebernehmeDaten(HierarchieObjekt ho, HODaten daten) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "\u00dcbernehme bearbeitete Daten f\u00fcr Hierarchieobjekt " + ho, null);
        List objektListe = daten.getSystemObjekte();
        int i = 0;
        while (i < objektListe.size()) {
            SystemObject so = (SystemObject)objektListe.get(i);
            if (ho.getSystemObjekte().contains(so)) {
                SystemObjektDaten soDaten = daten.getSystemObjektDaten(so);
                if (!so.getPid().equals(soDaten.getPid())) {
                    try {
                        so = this.behandleSystemObjektAendeung((ConfigurationObject)so, soDaten.getPid());
                        ho.setSystemObjekt(i, so);
                        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " erzeugt"));
                    }
                    catch (ConfigurationChangeException e) {
                        status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim Behandeln der PID-\u00c4nderung auf " + soDaten.getPid() + " f\u00fcr Objekt " + so.getPid(), (Throwable)e));
                    }
                }
                if (so.getName() == null || !so.getName().equals(soDaten.getName())) {
                    try {
                        so.setName(soDaten.getName());
                        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + soDaten.getName() + "\" \u00fcbernommen"));
                    }
                    catch (ConfigurationChangeException e) {
                        status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + soDaten.getName() + "\" konnte nicht \u00fcbernommen werden", (Throwable)e));
                    }
                }
                List atgList = ho.getHierarchieObjektTyp().getTypInfo(so.getType().getPid()).getAtgs();
                for (String atgPid : atgList) {
                    AttributeGroup atg = this.hierarchie.getDataModel().getAttributeGroup(atgPid);
                    if (atg != null) {
                        ConfigDataModel dataModel = this.hierarchie.getDataModel();
                        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
                        Data ist = ((ConfigSystemObject)so).getConfigurationData(atg, lookup);
                        Data soll = soDaten.getAtgDaten(atgPid);
                        if (soll != null) {
                            if (ist != null && !soDaten.isDatenGeaendert(atgPid)) continue;
                            if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)so, (AttributeGroup)atg)) {
                                try {
                                    so = this.behandleSystemObjektAendeung((ConfigurationObject)so, so.getPid());
                                    ho.setSystemObjekt(i, so);
                                    status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingt Erzeugung neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid()));
                                }
                                catch (ConfigurationChangeException e) {
                                    status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Bei der durch ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingten Erzeugung neues Objekts mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " ist ein Fehler aufgetreten", (Throwable)e));
                                    continue;
                                }
                            }
                            try {
                                so.setConfigurationData(atg, soll);
                                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurierende Daten der ATG " + atgPid + " \u00fcbernommen"));
                            }
                            catch (ConfigurationChangeException e) {
                                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim \u00dcbernehmen konfigurierender Daten der ATG " + atgPid, (Throwable)e));
                            }
                            continue;
                        }
                        if (ist == null) continue;
                        if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)so, (AttributeGroup)atg)) {
                            try {
                                so = this.behandleSystemObjektAendeung((ConfigurationObject)so, so.getPid());
                                ho.setSystemObjekt(i, so);
                                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingt Erzeugung neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid()));
                            }
                            catch (ConfigurationChangeException e) {
                                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Bei der durch ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingten Erzeugung neues Objekts mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " ist ein Fehler aufgetreten", (Throwable)e));
                                continue;
                            }
                        }
                        try {
                            so.setConfigurationData(atg, null);
                            status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurierende Daten der ATG " + atgPid + " gel\u00f6scht"));
                        }
                        catch (ConfigurationChangeException e) {
                            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim L\u00f6schen konfigurierender Daten der ATG " + atgPid, (Throwable)e));
                        }
                        continue;
                    }
                    LOGGER.warning("Bearbeitung Objekt " + so.getPid() + ": Keine Attributgruppe im Datenmodell gefunden f\u00fcr " + atgPid);
                }
            }
            ++i;
        }
        return status;
    }

    public boolean pruefeNeuanlageVerboten(Object objekt, IHierarchieObjektTyp hot) {
        return false;
    }

    public Collection<SystemObjectType> loeschenOffeneReferenzenVerboten(IHierarchieObjektTyp hot) {
        return null;
    }

    public boolean verwendeZuLoeschendeObjekteZurPruefungOffeneReferenzen() {
        return false;
    }

    public boolean kopierenNichtErlaubt(HierarchieObjekt ho) {
        return false;
    }
}

