/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkaaxl;

import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HODaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HierarchieObjekt;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IAttributInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.SystemObjektDaten;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.IPruefungen;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.PruefungenTools;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class PruefungenAXL
implements IPruefungen {
    private IHierarchie hierarchie;

    public IHierarchie getHierarchie() {
        return this.hierarchie;
    }

    public void setHierarchie(IHierarchie hierarchie) {
        this.hierarchie = hierarchie;
    }

    public IStatus pruefeHierarchieObjekt(HierarchieObjekt ho, HODaten daten) {
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Hierarchieobjekt " + ho, null);
        for (SystemObject so : ho.getSystemObjekte()) {
            SystemObjektDaten soDaten = daten.getSystemObjektDaten(so);
            if (soDaten == null) continue;
            MultiStatus objektStatus = ho.getSystemObjekte().size() > 1 ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Systemobjekt " + so.getPid() + " vom Typ " + so.getType().getPid(), null) : result;
            objektStatus.add(new PruefungenTools(this.getHierarchie().getDataModel()).pruefePid(soDaten.getPid(), so));
        }
        return result;
    }

    public IStatus pruefeDaten(HierarchieObjekt ho, SystemObject so, AtgInfo atgInfo, Data daten) {
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Daten der ATG " + atgInfo.getAtg(), null);
        if (so.isOfType("typ.achsLastMessStelle") && ("atg.achsLastMessStelle".equals(atgInfo.getAtg()) || "atg.punktKoordinaten".equals(atgInfo.getAtg()))) {
            this.pruefeDatenDefinition(atgInfo, daten, result);
        }
        return result;
    }

    private boolean pruefeDatenDefinition(IAttributInfo attInfo, Data daten, MultiStatus status) {
        Data item = daten.getItem(attInfo.getName());
        if (!item.isDefined()) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Wert ist nicht korrekt definiert"));
            return false;
        }
        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Pr\u00fcfen Daten-Definition: OK"));
        if (item.isPlain() && attInfo.isPflichtFeld()) {
            String wert = item.asTextValue().getText();
            if ("".equals(wert) || !(item.getAttributeType() instanceof StringAttributeType) && "undefiniert".equals(wert) || "_Undefiniert_".equals(wert)) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Wert f\u00fcr Pflichtfeld nicht angegeben"));
                return false;
            }
            status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Pr\u00fcfen Pflichtfeld-Eigenschaft: OK"));
        }
        return true;
    }

    private void pruefeDatenDefinition(AtgInfo atgInfo, Data daten, MultiStatus status) {
        for (String attribut : atgInfo.getAttribute()) {
            MultiStatus meldung = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Wert f\u00fcr Attribut " + attribut, null);
            IAttributInfo attInfo = atgInfo.getAttributInfo(attribut);
            this.pruefeDatenDefinition(attInfo, daten, meldung);
            status.add((IStatus)meldung);
        }
    }
}

