/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkaaxl.preferences;

import de.bsvrz.buv.plugin.tkaaxl.HOT_AXL;
import de.bsvrz.buv.plugin.tkaaxl.TkaAxlActivator;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieObjektTyp;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.TypInfo;
import de.bsvrz.buv.plugin.tkabasis.preferences.tree.AtgInfoNode;
import de.bsvrz.buv.plugin.tkabasis.preferences.tree.ITreeNode;
import de.bsvrz.buv.plugin.tkabasis.preferences.tree.RootNode;
import de.bsvrz.buv.plugin.tkabasis.preferences.tree.TreeContentProvider;
import de.bsvrz.buv.plugin.tkabasis.preferences.tree.TreeLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TkaAxlPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "de.bsvrz.buv.plugin.tkaaxl.preferencePage";
    private Text textBR;
    private Text textP;
    private CheckboxTreeViewer treeVOptional;

    public TkaAxlPreferencePage() {
        this.setPreferenceStore(TkaAxlActivator.getDefault().getPreferenceStore());
        String msg = "Mit Hilfe dieser Seite k\u00f6nnen Einstellungen bzgl. des Plugins\nTeilkonfigurationsassistent AXL Achslast vorgenommen werden\n";
        this.setDescription("Mit Hilfe dieser Seite k\u00f6nnen Einstellungen bzgl. des Plugins\nTeilkonfigurationsassistent AXL Achslast vorgenommen werden\n");
    }

    public TkaAxlPreferencePage(String title) {
        super(title);
    }

    public TkaAxlPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        Group grpBR = new Group(top, 0);
        grpBR.setText("Klassen-Instanz f\u00fcr Bildungsregeln");
        Label labelBR = new Label((Composite)grpBR, 0);
        labelBR.setText("Klassenname:");
        this.textBR = new Text((Composite)grpBR, 2048);
        Group grpP = new Group(top, 0);
        grpP.setText("Klassen-Instanz f\u00fcr Pr\u00fcfungen");
        Label labelP = new Label((Composite)grpP, 0);
        labelP.setText("Klassenname:");
        this.textP = new Text((Composite)grpP, 2048);
        Group grpOptional = new Group(top, 0);
        grpOptional.setText("optionale Attributgruppen");
        this.treeVOptional = new CheckboxTreeViewer((Composite)grpOptional, 2048);
        this.treeVOptional.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeVOptional.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeVOptional.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ITreeNode element = (ITreeNode)event.getElement();
                if (element.hasChildren()) {
                    TkaAxlPreferencePage.this.treeVOptional.setSubtreeChecked((Object)element, checked);
                }
            }
        });
        if (HOT_AXL.values().length > 0) {
            HOT_AXL[] hots = HOT_AXL.values();
            ArrayList<HOT_AXL> list = new ArrayList<HOT_AXL>();
            HOT_AXL[] hOT_AXLArray = hots;
            int n = hots.length;
            int n2 = 0;
            while (n2 < n) {
                HOT_AXL hot = hOT_AXLArray[n2];
                boolean istAtgMandatory = true;
                List<String> typen = hot.getTypen();
                for (String string : typen) {
                    TypInfo ti = hot.getTypInfo(string);
                    List atgs = ti.getAtgs();
                    for (String atg : atgs) {
                        AtgInfo ai = ti.getAtgInfo(atg);
                        istAtgMandatory = ai.isMandatory();
                    }
                }
                if (!istAtgMandatory) {
                    list.add(hot);
                }
                ++n2;
            }
            RootNode rootNode = new RootNode((IHierarchieObjektTyp[])list.toArray(new HOT_AXL[list.size()]));
            this.treeVOptional.setInput((Object)rootNode);
            this.treeVOptional.expandAll();
            this.treeVOptional.refresh();
        }
        GridData gdTop = new GridData();
        gdTop.grabExcessHorizontalSpace = true;
        gdTop.horizontalAlignment = 4;
        top.setLayoutData((Object)gdTop);
        GridLayout glTop = new GridLayout(1, false);
        top.setLayout((Layout)glTop);
        GridData gdGrpBR = new GridData();
        gdGrpBR.grabExcessHorizontalSpace = true;
        gdGrpBR.horizontalAlignment = 4;
        grpBR.setLayoutData((Object)gdGrpBR);
        GridLayout glGrpBR = new GridLayout(4, false);
        grpBR.setLayout((Layout)glGrpBR);
        GridData gdTextBR = new GridData();
        gdTextBR.grabExcessHorizontalSpace = true;
        gdTextBR.horizontalAlignment = 4;
        this.textBR.setLayoutData((Object)gdTextBR);
        GridData gdGrpP = new GridData();
        gdGrpP.grabExcessHorizontalSpace = true;
        gdGrpP.horizontalAlignment = 4;
        grpP.setLayoutData((Object)gdGrpP);
        GridLayout glGrpP = new GridLayout(4, false);
        grpP.setLayout((Layout)glGrpP);
        GridData gdTextP = new GridData();
        gdTextP.grabExcessHorizontalSpace = true;
        gdTextP.horizontalAlignment = 4;
        this.textP.setLayoutData((Object)gdTextP);
        grpOptional.setLayoutData((Object)new GridData(1808));
        grpOptional.setLayout((Layout)new GridLayout());
        this.actionLoadFromPreferenceStore();
        return null;
    }

    private void actionLoadDefaultsFromPreferenceStore() {
        Object input;
        IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
        String klassenNameBR = preferences.getDefaultString("klasseBildungsregeln");
        if (this.textBR != null) {
            this.textBR.setText(klassenNameBR);
        }
        String klassenNameP = preferences.getDefaultString("klassePruefungen");
        if (this.textP != null) {
            this.textP.setText(klassenNameP);
        }
        if (this.treeVOptional != null && (input = this.treeVOptional.getInput()) instanceof ITreeNode) {
            ITreeNode root = (ITreeNode)input;
            this.setDefaultCheck(root);
        }
    }

    private void setDefaultCheck(ITreeNode node) {
        IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (Object obj : children) {
                ITreeNode child = (ITreeNode)obj;
                if (child.hasChildren()) {
                    this.setDefaultCheck(child);
                    continue;
                }
                if (!(child instanceof AtgInfoNode)) continue;
                AtgInfo atgInfo = ((AtgInfoNode)child).getAtgInfo();
                String typ = ((AtgInfoNode)child).getTyp();
                if (preferences.contains(String.valueOf(typ) + "," + atgInfo.getAtg())) {
                    boolean isOptional = preferences.getDefaultBoolean(String.valueOf(typ) + "," + atgInfo.getAtg());
                    this.treeVOptional.setChecked((Object)child, isOptional);
                    continue;
                }
                if (!atgInfo.isOptional()) continue;
                this.treeVOptional.setChecked((Object)child, true);
            }
        }
    }

    private void setCheck(ITreeNode node) {
        IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (Object obj : children) {
                ITreeNode child = (ITreeNode)obj;
                if (child.hasChildren()) {
                    this.setCheck(child);
                    continue;
                }
                if (!(child instanceof AtgInfoNode)) continue;
                AtgInfo atgInfo = ((AtgInfoNode)child).getAtgInfo();
                String typ = ((AtgInfoNode)child).getTyp();
                if (preferences.contains(String.valueOf(typ) + "," + atgInfo.getAtg())) {
                    boolean isOptional = preferences.getBoolean(String.valueOf(typ) + "," + atgInfo.getAtg());
                    this.treeVOptional.setChecked((Object)child, isOptional);
                    continue;
                }
                if (!atgInfo.isOptional()) continue;
                this.treeVOptional.setChecked((Object)child, true);
            }
        }
    }

    private void actionLoadFromPreferenceStore() {
        Object input;
        IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
        String klassenNameBR = preferences.getString("klasseBildungsregeln");
        if (this.textBR != null) {
            this.textBR.setText(klassenNameBR);
        }
        String klassenNameP = preferences.getString("klassePruefungen");
        if (this.textP != null) {
            this.textP.setText(klassenNameP);
        }
        if (this.treeVOptional != null && (input = this.treeVOptional.getInput()) instanceof ITreeNode) {
            ITreeNode root = (ITreeNode)input;
            this.setCheck(root);
        }
    }

    private void actionSaveToPreferenceStore() {
        Object input;
        boolean allValuesAvailable = true;
        String klassenNameBR = "";
        String klassenNameP = "";
        Boolean selectedPL = false;
        if (this.textBR != null && this.textP != null) {
            klassenNameBR = this.textBR.getText();
            klassenNameP = this.textP.getText();
        } else {
            allValuesAvailable = false;
        }
        if (this.treeVOptional != null && (input = this.treeVOptional.getInput()) instanceof ITreeNode) {
            ITreeNode root = (ITreeNode)input;
            this.saveOptional(root);
        }
        if (allValuesAvailable) {
            IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
            preferences.setValue("klasseBildungsregeln", klassenNameBR);
            preferences.setValue("klassePruefungen", klassenNameP);
            preferences.setValue("selectedPruefungBeimLoeschen", selectedPL.booleanValue());
        }
    }

    private void saveOptional(ITreeNode node) {
        IPreferenceStore preferences = TkaAxlActivator.getDefault().getPreferenceStore();
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (Object obj : children) {
                ITreeNode child = (ITreeNode)obj;
                if (child.hasChildren()) {
                    this.saveOptional(child);
                    continue;
                }
                if (!(child instanceof AtgInfoNode)) continue;
                AtgInfo atgInfo = ((AtgInfoNode)child).getAtgInfo();
                String typ = ((AtgInfoNode)child).getTyp();
                if (atgInfo.isMandatory()) continue;
                atgInfo.setOptional(this.treeVOptional.getChecked((Object)child));
                preferences.setValue(String.valueOf(typ) + "," + atgInfo.getAtg(), atgInfo.isOptional());
            }
        }
    }

    protected void performApply() {
        this.actionSaveToPreferenceStore();
    }

    protected void performDefaults() {
        this.actionLoadDefaultsFromPreferenceStore();
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public void performHelp() {
    }
}

