/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkanba;

import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.AttributInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IAttributInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieObjektTyp;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.MengeInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.PflichtArray;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.TypInfo;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum HOT_NBA implements IHierarchieObjektTyp
{
    Masche("Masche", new TypInfo[]{new TypInfo("typ.masche", new AtgInfo[]{new AtgInfo("atg.routen", true, new IAttributInfo[]{new PflichtArray("Route", AttributInfo.Edit.FIX)})}, null)}),
    ROUTE("Route", new TypInfo[]{new TypInfo("typ.route", new AtgInfo[]{new AtgInfo("atg.bestehtAusLinienObjekten", true, new IAttributInfo[]{new PflichtArray("LinienReferenz", AttributInfo.Edit.FIX)})}, null)}),
    HauptRoute("HauptRoute", ROUTE, "typ.route", "typ.route", false),
    NebenRoute("NebenRoute", ROUTE, "typ.route", "typ.route", false),
    RoutenStueck("RoutenSt\u00fcck", new TypInfo[]{new TypInfo("typ.routenSt\u00fcck", new AtgInfo[]{new AtgInfo("atg.bestehtAusLinienObjekten", true, new IAttributInfo[]{new PflichtArray("LinienReferenz", AttributInfo.Edit.FIX)})}, null)}),
    ASS("\u00c4u\u00dferesStra\u00dfenSegment", new TypInfo[]{new TypInfo("typ.\u00e4u\u00dferesStra\u00dfenSegment", null, null)}, true);

    private String name;
    private final List<String> typen = new ArrayList<String>();
    private final Map<String, TypInfo> typInfoMap = new HashMap<String, TypInfo>();
    private boolean systemObjektVorhanden;

    private HOT_NBA(String name, TypInfo[] typInfos) {
        this.name = name;
        if (typInfos != null) {
            TypInfo[] typInfoArray = typInfos;
            int n2 = typInfos.length;
            int n3 = 0;
            while (n3 < n2) {
                TypInfo info = typInfoArray[n3];
                this.typen.add(info.getTyp());
                this.typInfoMap.put(info.getTyp(), info);
                ++n3;
            }
        }
    }

    private HOT_NBA(String name, TypInfo[] typInfos, boolean isSystemObjektVorhanden) {
        this(name, typInfos);
        this.systemObjektVorhanden = isSystemObjektVorhanden;
    }

    private HOT_NBA(String name, HOT_NBA uebergeorneterHOT, String oberTyp, String unterTyp, boolean alleTypen) {
        this.name = name;
        if (alleTypen) {
            for (String typ : uebergeorneterHOT.getTypen()) {
                TypInfo typInfo = uebergeorneterHOT.getTypInfo(typ);
                this.addTypInfos(typInfo, oberTyp, unterTyp);
            }
        } else {
            TypInfo typInfo = uebergeorneterHOT.getTypInfo(oberTyp);
            this.addTypInfos(typInfo, oberTyp, unterTyp);
        }
    }

    private void addTypInfos(TypInfo typInfo, String oberTyp, String unterTyp) {
        List atgs = typInfo.getAtgs();
        AtgInfo[] atgInfo = new AtgInfo[atgs.size()];
        int i = 0;
        while (i < atgInfo.length) {
            atgInfo[i] = typInfo.getAtgInfo((String)atgs.get(i));
            ++i;
        }
        List mengen = typInfo.getMengen();
        MengeInfo[] mengeInfo = new MengeInfo[mengen.size()];
        int i2 = 0;
        while (i2 < mengeInfo.length) {
            mengeInfo[i2] = typInfo.getMengeInfo((String)mengen.get(i2));
            ++i2;
        }
        String typ = typInfo.getTyp();
        if (typ.equals(oberTyp)) {
            this.typen.add(unterTyp);
            this.typInfoMap.put(unterTyp, new TypInfo(unterTyp, atgInfo, mengeInfo));
        } else {
            this.typen.add(typ);
            this.typInfoMap.put(typ, new TypInfo(typ, atgInfo, mengeInfo));
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getSymbolName() {
        return super.toString();
    }

    public List<String> getTypen() {
        return Collections.unmodifiableList(this.typen);
    }

    public TypInfo getTypInfo(String typ) {
        return this.typInfoMap.get(typ);
    }

    public TypInfo getTypInfo(SystemObjectType sot) {
        TypInfo result = this.getTypInfo(sot.getPid());
        if (result == null && !sot.isBaseType()) {
            for (SystemObjectType superTyp : sot.getSuperTypes()) {
                if (superTyp.isConfigurating() && (result = this.getTypInfo(superTyp)) != null) break;
            }
        }
        return result;
    }

    public boolean isSystemObjektVorhanden() {
        return this.systemObjektVorhanden;
    }

    public boolean isSystemObjektNichtAenderbar() {
        return this.isSystemObjektVorhanden();
    }
}

