/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkanba;

import de.bsvrz.buv.plugin.tkabasis.DataFactory;
import de.bsvrz.buv.plugin.tkabasis.LookupFactory;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HODaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HOHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HOMitStatus;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HierarchieObjekt;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieManager;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchieObjektTyp;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.MengeInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.SystemObjektDaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.TypInfo;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.IPruefungen;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.LoeschenChecker;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.PruefungenTools;
import de.bsvrz.buv.plugin.tkabasis.regeln.IBildungsRegeln;
import de.bsvrz.buv.plugin.tkanba.HOT_NBA;
import de.bsvrz.buv.plugin.tkanba.TkaNbaActivator;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.ConfigurationObjectType;
import de.bsvrz.dav.daf.main.config.NonMutableSet;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.ObjectSet;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.ReferenceType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.puk.config.configFile.datamodel.ConfigConfigurationObject;
import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import de.bsvrz.puk.config.configFile.datamodel.ConfigSystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class HierarchieManagerNBA
implements IHierarchieManager {
    private static final IHierarchieObjektTyp[] EMPTY_HIERARCHIE_OBJEKT_TYPS = new IHierarchieObjektTyp[0];
    private static final Debug LOGGER = Debug.getLogger();
    private IHierarchie hierarchie;
    private static final IHierarchieObjektTyp[] EBENE1 = new IHierarchieObjektTyp[]{HOT_NBA.Masche};
    private static final IHierarchieObjektTyp[] EBENE2 = new IHierarchieObjektTyp[]{HOT_NBA.HauptRoute, HOT_NBA.NebenRoute};
    private static final IHierarchieObjektTyp[] EBENE20 = new IHierarchieObjektTyp[]{HOT_NBA.HauptRoute};
    private static final IHierarchieObjektTyp[] EBENE21 = new IHierarchieObjektTyp[]{HOT_NBA.NebenRoute};
    private static final IHierarchieObjektTyp[] EBENE3 = new IHierarchieObjektTyp[]{HOT_NBA.RoutenStueck};
    private static final IHierarchieObjektTyp[] EBENE4 = new IHierarchieObjektTyp[]{HOT_NBA.ASS};

    public IHierarchieObjektTyp[] getUntergeordneteHOTs(Object objekt) {
        if (objekt instanceof ConfigurationArea) {
            return EBENE1;
        }
        if (objekt instanceof HierarchieObjekt) {
            HierarchieObjekt ho = (HierarchieObjekt)objekt;
            IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
            if (hot.equals((Object)HOT_NBA.Masche)) {
                return EBENE2;
            }
            if (hot.equals((Object)HOT_NBA.HauptRoute) || hot.equals((Object)HOT_NBA.NebenRoute)) {
                return EBENE3;
            }
            if (hot.equals((Object)HOT_NBA.RoutenStueck)) {
                return EBENE4;
            }
        }
        return EMPTY_HIERARCHIE_OBJEKT_TYPS;
    }

    public IHierarchie getHierarchie() {
        return this.hierarchie;
    }

    public void setHierarchie(IHierarchie hierarchie) {
        this.hierarchie = hierarchie;
    }

    public void bestimmeUntergeordneteHOs(Object objekt) {
        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)this.hierarchie.getDataModel());
        this.bestimmeUntergeordneteHOs(objekt, lookup);
    }

    private void bestimmeUntergeordneteHOs(Object objekt, ObjectLookup lookup) {
        ConfigDataModel dataModel = this.hierarchie.getDataModel();
        if (objekt instanceof ConfigurationArea) {
            ConfigurationArea kb = (ConfigurationArea)objekt;
            Vector<SystemObjectType> typeSpez = new Vector<SystemObjectType>();
            IHierarchieObjektTyp[] iHierarchieObjektTypArray = EBENE1;
            int n = EBENE1.length;
            int n2 = 0;
            while (n2 < n) {
                IHierarchieObjektTyp hot = iHierarchieObjektTypArray[n2];
                String typPid = (String)hot.getTypen().get(0);
                SystemObjectType typ = this.hierarchie.getDataModel().getType(typPid);
                if (typ == null) {
                    throw new IllegalStateException("Typ " + typPid + " wurde im aktuellen Datemmodell nicht gefunden");
                }
                typeSpez.add(typ);
                for (SystemObject so : kb.getObjects(typeSpez, ObjectTimeSpecification.valid())) {
                    ConfigurationObject ko = (ConfigurationObject)so;
                    if (ko.getNotValidSince() >= ko.getConfigurationArea().getModifiableVersion()) continue;
                    HierarchieObjekt ho = new HierarchieObjekt(hot, new SystemObject[]{so}, EBENE1);
                    this.hierarchie.objektHinzufuegen((Object)kb, ho);
                    this.bestimmeUntergeordneteHOs(ho);
                }
                for (SystemObject so : kb.getNewObjects()) {
                    if (!so.isOfType(typ)) continue;
                    HierarchieObjekt ho = new HierarchieObjekt(hot, new SystemObject[]{so}, EBENE1);
                    this.hierarchie.objektHinzufuegen((Object)kb, ho);
                    this.bestimmeUntergeordneteHOs(ho);
                }
                ++n2;
            }
        } else if (objekt instanceof HierarchieObjekt) {
            HierarchieObjekt ho = (HierarchieObjekt)objekt;
            IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
            if (hot.equals((Object)HOT_NBA.Masche)) {
                ConfigSystemObject kso = (ConfigSystemObject)ho.getSystemObjekt(0);
                Data data = kso.getConfigurationData(dataModel.getAttributeGroup("atg.routen"), lookup);
                if (data != null) {
                    SystemObject[] soArray = data.getItem("Route").asReferenceArray().getSystemObjectArray();
                    List<SystemObject> liste = Arrays.asList(soArray);
                    int index = 0;
                    for (SystemObject so : liste) {
                        if (so != null) {
                            if (so.isOfType("typ.route")) {
                                HOT_NBA hotKind = null;
                                hotKind = index == 0 ? HOT_NBA.HauptRoute : HOT_NBA.NebenRoute;
                                HierarchieObjekt kind = new HierarchieObjekt((IHierarchieObjektTyp)hotKind, new SystemObject[]{so}, this.getUntergeordneteHOTs(objekt));
                                this.hierarchie.objektHinzufuegen((Object)ho, kind);
                                this.bestimmeUntergeordneteHOs(kind);
                            } else {
                                LOGGER.warning("Unzul\u00e4ssiger Objekttyp " + so.getPid() + " in Attributgruppe Routen vom Objekt " + kso.getPid());
                            }
                        }
                        ++index;
                    }
                } else {
                    LOGGER.warning("Attributgruppe Routen nicht gefunden f\u00fcr Objekt " + kso.getPid());
                }
            } else if (hot.equals((Object)HOT_NBA.HauptRoute) || hot.equals((Object)HOT_NBA.NebenRoute)) {
                ConfigSystemObject kso = (ConfigSystemObject)ho.getSystemObjekt(0);
                Data data = kso.getConfigurationData(dataModel.getAttributeGroup("atg.bestehtAusLinienObjekten"), lookup);
                if (data != null) {
                    SystemObject[] soArray = data.getItem("LinienReferenz").asReferenceArray().getSystemObjectArray();
                    List<SystemObject> liste = Arrays.asList(soArray);
                    for (SystemObject so : liste) {
                        if (so == null) continue;
                        if (so.isOfType("typ.routenSt\u00fcck")) {
                            HOT_NBA hotKind = HOT_NBA.RoutenStueck;
                            HierarchieObjekt kind = new HierarchieObjekt((IHierarchieObjektTyp)hotKind, new SystemObject[]{so}, this.getUntergeordneteHOTs(objekt));
                            this.hierarchie.objektHinzufuegen((Object)ho, kind);
                            this.bestimmeUntergeordneteHOs(kind);
                            continue;
                        }
                        LOGGER.warning("Unzul\u00e4ssiger Objekttyp " + so.getPid() + " in Attributgruppe BestehtAusLinienObjekten vom Objekt " + kso.getPid());
                    }
                } else {
                    LOGGER.warning("Attributgruppe BestehtAusLinienObjekten nicht gefunden f\u00fcr Objekt " + kso.getPid());
                }
            } else if (hot.equals((Object)HOT_NBA.RoutenStueck)) {
                ConfigSystemObject kso = (ConfigSystemObject)ho.getSystemObjekt(0);
                Data data = kso.getConfigurationData(dataModel.getAttributeGroup("atg.bestehtAusLinienObjekten"), lookup);
                if (data != null) {
                    SystemObject[] soArray = data.getItem("LinienReferenz").asReferenceArray().getSystemObjectArray();
                    List<SystemObject> liste = Arrays.asList(soArray);
                    for (SystemObject so : liste) {
                        if (so == null) continue;
                        if (so.isOfType("typ.\u00e4u\u00dferesStra\u00dfenSegment")) {
                            HOT_NBA hotKind = HOT_NBA.ASS;
                            HierarchieObjekt kind = new HierarchieObjekt((IHierarchieObjektTyp)hotKind, new SystemObject[]{so}, this.getUntergeordneteHOTs(objekt));
                            this.hierarchie.objektHinzufuegen((Object)ho, kind);
                            continue;
                        }
                        LOGGER.warning("Unzul\u00e4ssiger Objekttyp " + so.getPid() + " in Attributgruppe \u00c4u\u00dferesStra\u00dfenSegmente vom Objekt " + kso.getPid());
                    }
                } else {
                    LOGGER.warning("Attributgruppe \u00c4u\u00dferesStra\u00dfenSegmente nicht gefunden f\u00fcr Objekt " + kso.getPid());
                }
            } else {
                LOGGER.warning("\u00dcbergebenes HO " + ho + " ist vom unzul\u00e4ssigen (HO-)Typ + " + ho.getHierarchieObjektTyp());
            }
        } else {
            LOGGER.warning("\u00dcbergebenes Objekt " + objekt + " ist von unzul\u00e4ssigem Typ");
        }
    }

    private List<ObjectSet> erzeugeMengen(IHierarchieObjektTyp hot, SystemObjectType typ, ConfigurationArea kb, ConfigDataModel dataModel, MultiStatus status) {
        Vector<ObjectSet> result = new Vector<ObjectSet>();
        for (String mengenName : hot.getTypInfo(typ.getPid()).getMengen()) {
            ObjectSet menge;
            MengeInfo info = hot.getTypInfo(typ.getPid()).getMengeInfo(mengenName);
            SystemObjectType mengenTyp = dataModel.getType(info.getTyp());
            try {
                menge = (ObjectSet)kb.createConfigurationObject((ConfigurationObjectType)mengenTyp, "", mengenName, null);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Menge " + mengenName + " vom Typ " + mengenTyp.getPid() + " erzeugt"));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim Erzeugen der Menge " + mengenName + " vom Typ " + mengenTyp.getName() + " erzeugt", (Throwable)e));
                return result;
            }
            result.add(menge);
        }
        return result;
    }

    private SystemObject erzeugeSystemObjekt(String pid, ConfigurationObjectType typ, ConfigurationArea kb, List<ObjectSet> mengen, MultiStatus status) {
        ConfigurationObject result = null;
        try {
            result = kb.createConfigurationObject(typ, pid, "", mengen);
            if (mengen != null && !mengen.isEmpty()) {
                MultiStatus unterStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " erzeugt", null);
                status.add((IStatus)unterStatus);
                for (ObjectSet set : mengen) {
                    unterStatus.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Menge " + set.getName() + " dem Systemobjekt " + pid + " vom Typ " + typ.getPid() + " zugewiesen"));
                }
            } else {
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " erzeugt"));
            }
        }
        catch (ConfigurationChangeException e) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + pid + " vom Typ " + typ.getPid() + " konnte nicht erzeugt werden", (Throwable)e));
        }
        return result;
    }

    public HOMitStatus erzeugeNeuesHO(ConfigurationArea kb, Object vater, String[] pid, IHierarchieObjektTyp hot, boolean pruefeEindeutigkeit) {
        ConfigDataModel dataModel = this.hierarchie.getDataModel();
        ConfigurationObjectType typ = (ConfigurationObjectType)dataModel.getType((String)hot.getTypen().get(0));
        if (typ == null) {
            throw new IllegalArgumentException("F\u00fcr " + (String)hot.getTypen().get(0) + " kann kein Typ im Datenmodell bestimmt werden");
        }
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Erzeuge neues Hierarchieobjekt vom Typ " + hot, null);
        HierarchieObjekt ho = null;
        List mengenListe = hot.getTypInfo(typ.getPid()).getMengen();
        List<ObjectSet> mengen = null;
        if (mengenListe != null && mengenListe.size() == 0) {
            mengenListe = null;
        }
        if (!status.matches(12)) {
            SystemObject so = null;
            if (!hot.isSystemObjektVorhanden()) {
                if (pruefeEindeutigkeit) {
                    status.add(new PruefungenTools(dataModel).pruefePid(pid[0]));
                }
                if (!status.matches(12)) {
                    if (mengenListe != null) {
                        mengen = this.erzeugeMengen(hot, (SystemObjectType)typ, kb, dataModel, status);
                    }
                    so = this.erzeugeSystemObjekt(pid[0], typ, kb, mengen, status);
                }
            } else {
                so = dataModel.getObject(pid[0]);
                if (so == null) {
                    Collection areas = dataModel.getAllConfigurationAreas().values();
                    for (ConfigurationArea ca : areas) {
                        Collection elements = ca.getNewObjects();
                        for (SystemObject soNeu : elements) {
                            if (!pid[0].equals(soNeu.getPid())) continue;
                            so = soNeu;
                        }
                    }
                }
            }
            if (so != null && !status.matches(12)) {
                if (mengenListe == null) {
                    this.setzeHOArrayZuordnung(so, vater, status);
                }
                if (!status.matches(12)) {
                    ho = new HierarchieObjekt(hot, new SystemObject[]{so}, this.getUntergeordneteHOTs(vater));
                    this.getHierarchie().objektHinzufuegen(vater, ho);
                } else if (!hot.isSystemObjektVorhanden()) {
                    try {
                        so.invalidate();
                    }
                    catch (ConfigurationChangeException configurationChangeException) {
                        // empty catch block
                    }
                }
            }
        }
        return new HOMitStatus(ho, (IStatus)status);
    }

    private void setzeHOZuordnung(HierarchieObjekt ho, Object vater, MultiStatus status) {
        IHierarchie srcHierarchie = this.getHierarchie();
        SystemObject so = ho.getSystemObjekt(0);
        this.setzeHOArrayZuordnung(so, vater, status);
        if (!status.matches(12)) {
            srcHierarchie.objektHinzufuegen(vater, ho);
        }
    }

    private void setzeHOArrayZuordnung(SystemObject so, Object vater, MultiStatus status) {
        if (vater instanceof HierarchieObjekt) {
            ObjectLookup lookup;
            HierarchieObjekt ho = (HierarchieObjekt)vater;
            IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
            SystemObject vaterSo = ho.getSystemObjekt(0);
            String pidSo = vaterSo.getType().getPid();
            String atgPid = (String)hot.getTypInfo(pidSo).getAtgs().get(0);
            AtgInfo atgInfo = hot.getTypInfo(pidSo).getAtgInfo(atgPid);
            List attNamenListe = atgInfo.getAttribute();
            AttributeGroup atg = this.hierarchie.getDataModel().getAttributeGroup(atgPid);
            Data data = ((ConfigConfigurationObject)vaterSo).getConfigurationData(atg, lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)this.getHierarchie().getDataModel()));
            if (data == null) {
                data = DataFactory.createData((AttributeGroup)atg);
                data.setToDefault();
            }
            String arrayName = "";
            for (String attName : attNamenListe) {
                if (!data.getItem(attName).isArray()) continue;
                arrayName = attName;
                break;
            }
            if (arrayName.isEmpty()) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gesetzt werden, weil kein Array gefunden wurde."));
                return;
            }
            Data.ReferenceArray ra = data.getReferenceArray(arrayName);
            int len = ra.getLength();
            Data.Array array = data.getItem(arrayName).asArray();
            if (array.getMaxCount() != 0 && array.getMaxCount() < len + 1) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gesetzt werden, weil die maximale Anzahl von Array-Elementen erreicht ist."));
                return;
            }
            if (Arrays.asList(ra.getSystemObjectArray()).contains(so)) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gesetzt werden, weil dieses bereits vorhanden ist."));
                return;
            }
            ra.setLength(len + 1);
            ra.getReferenceValue(len).setSystemObject(so);
            try {
                if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)vaterSo, (AttributeGroup)atg)) {
                    vaterSo = this.behandleSystemObjektAenderung(ho, (ConfigurationObject)vaterSo, vaterSo.getPid());
                    ho.setSystemObjekt(0, vaterSo);
                }
                vaterSo.setConfigurationData(atg, data);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " als Referenz in " + vaterSo.getPid() + " gesetzt"));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gesetzt werden ", (Throwable)e));
            }
        }
    }

    public HOMitStatus kopiereHO(HierarchieObjekt ho, ConfigurationArea kb, Object neuerVater, String[] neuePid, boolean rekursiv, boolean isWurzel) {
        return this.kopiereHO(ho, kb, neuerVater, neuePid, rekursiv, true, true);
    }

    private HOMitStatus kopiereHO(HierarchieObjekt ho, ConfigurationArea kb, Object neuerVater, String[] neuePid, boolean rekursiv, boolean anwendenBR, boolean pruefePid) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Hierarchieobjekt " + ho, null);
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        String[] pid = neuePid;
        HOMitStatus result = null;
        HierarchieObjekt neu = null;
        if (pid == null || pid.length == 0) {
            pid = new String[]{ho.getSystemObjekt(0).getPid()};
        }
        if (!hot.isSystemObjektVorhanden()) {
            result = this.erzeugeNeuesHO(kb, neuerVater, pid, ho.getHierarchieObjektTyp(), pruefePid);
            neu = result.getHO();
            status.add(result.getStatus());
            if (neu != null) {
                String pidTyp;
                List mengenListe;
                MultiStatus statusDaten = this.kopiereDaten(ho, neu, anwendenBR, anwendenBR);
                status.merge((IStatus)statusDaten);
                if (hot.equals((Object)HOT_NBA.HauptRoute) && this.hierarchie.getUntergeordneteObjekte(neuerVater).size() > 1) {
                    neu.setHierarchieObjektTyp((IHierarchieObjektTyp)HOT_NBA.NebenRoute);
                }
                if ((mengenListe = hot.getTypInfo(pidTyp = (String)hot.getTypen().get(0)).getMengen()) != null && mengenListe.size() == 0) {
                    mengenListe = null;
                }
                if (mengenListe == null) {
                    this.loescheHOArrayZuordnung(neu, status);
                }
            }
        } else {
            result = this.erzeugeNeuesHO(kb, neuerVater, pid, ho.getHierarchieObjektTyp(), pruefePid);
            neu = result.getHO();
            status.add(result.getStatus());
        }
        if (!status.matches(12) && rekursiv) {
            for (HierarchieObjekt kind : this.hierarchie.getUntergeordneteObjekte((Object)ho)) {
                MultiStatus meldung = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere untergeordnetes Hierarchieobjekt " + kind + " zu " + ho, null);
                result = this.kopiereHO(kind, kb, neu, null, true, anwendenBR, pruefePid);
                meldung.merge(result.getStatus());
                status.add((IStatus)meldung);
            }
        }
        return new HOMitStatus(neu, (IStatus)status);
    }

    private MultiStatus kopiereDaten(HierarchieObjekt srcHO, HierarchieObjekt destHO, boolean bildungsRegelnFuerName, boolean bildungsRegelnFuerAtg) {
        if (!srcHO.getHierarchieObjektTyp().equals(destHO.getHierarchieObjektTyp())) {
            throw new IllegalArgumentException("Beide \u00fcbergebenen Hierarchieobjekte m\u00fcssen vom gleichen Hierarchieobjekttyp sein");
        }
        int index = 0;
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Daten von " + srcHO + " nach " + destHO, null);
        IBildungsRegeln br = TkaNbaActivator.getDefault().getDatenSpeicher().getBildungsRegeln();
        ConfigDataModel dataModel = this.hierarchie.getDataModel();
        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
        for (SystemObject src : srcHO.getSystemObjekte()) {
            SystemObject dest = destHO.getSystemObjekt(index);
            String name = bildungsRegelnFuerName ? br.getName(dest) : src.getName();
            try {
                dest.setName(name);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Setze Name \"" + name + "\" f\u00fcr Systemobjekt " + dest.getPid()));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + name + "\" f\u00fcr Systemobjekt " + dest.getPid() + " konnte nicht gesetzt werden", (Throwable)e));
                return status;
            }
            for (AttributeGroupUsage atgu : src.getUsedAttributeGroupUsages()) {
                Data dataSrc = ((ConfigSystemObject)src).getConfigurationData(atgu, lookup);
                if (dataSrc == null) continue;
                try {
                    Data dataDest = DataFactory.createModifiableCopy((Data)dataSrc, (ObjectLookup)lookup);
                    if (bildungsRegelnFuerAtg) {
                        dataDest = br.getDatensatz(destHO, dest, atgu.getAttributeGroup(), dataDest, true);
                    }
                    dest.setConfigurationData(atgu, dataDest);
                    status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Kopiere Daten der ATG-Verwendung " + atgu.getAttributeGroup().getPid() + "/" + atgu.getAspect().getPid() + " f\u00fcr Systemobjekt " + dest.getPid()));
                }
                catch (ConfigurationChangeException e) {
                    status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Daten der ATG-Verwendung " + atgu.getAttributeGroup().getPid() + "/" + atgu.getAspect().getPid() + " f\u00fcr Systemobjekt " + dest.getPid() + " konnten nicht kopiert werden", (Throwable)e));
                    return status;
                }
            }
            ++index;
        }
        return status;
    }

    public HOMitStatus verschiebeHO(HierarchieObjekt ho, Object neuerVater) {
        IHierarchie srcHierarchie = this.getHierarchie();
        ConfigDataModel dataModel = srcHierarchie.getDataModel();
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        Object alterVater = srcHierarchie.getUebergeordnetesObjekt(ho);
        ConfigurationArea srcKB = srcHierarchie.getKonfigurationsBereich(alterVater);
        ConfigurationArea destKB = srcHierarchie.getKonfigurationsBereich(neuerVater);
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Verschiebe Hierarchieobjekt " + ho, null);
        HierarchieObjekt neu = null;
        if (srcKB.equals(destKB)) {
            if (neuerVater.equals(alterVater)) {
                status.add((IStatus)new Status(1, "de.bsvrz.buv.plugin.tkabasis", "Objekt " + ho + " kann nicht in sich selbst verschoben werden"));
            } else {
                ConfigurationObjectType typ;
                List mengenListe = null;
                if (hot != null && (typ = (ConfigurationObjectType)dataModel.getType((String)hot.getTypen().get(0))) != null && (mengenListe = hot.getTypInfo(typ.getPid()).getMengen()) != null && mengenListe.size() == 0) {
                    mengenListe = null;
                }
                if (mengenListe == null) {
                    SystemObject so = ho.getSystemObjekt(0);
                    this.setzeHOArrayZuordnung(so, neuerVater, status);
                    if (!status.matches(12)) {
                        this.loescheHOArrayZuordnung(ho, alterVater, status);
                    }
                }
                if (!status.matches(12)) {
                    srcHierarchie.objektVerschieben(alterVater, neuerVater, ho);
                    if (HOT_NBA.HauptRoute.equals(hot)) {
                        this.aendernHOT(alterVater, HOT_NBA.HauptRoute, status);
                        if (srcHierarchie.getUntergeordneteObjekte(neuerVater).size() > 1) {
                            ho.setHierarchieObjektTyp((IHierarchieObjektTyp)HOT_NBA.NebenRoute);
                        }
                    }
                }
                if (!status.matches(12)) {
                    neu = ho;
                }
            }
        } else {
            HOHierarchie hoHierarchie = new HOHierarchie(ho, srcHierarchie);
            status.add((IStatus)this.loescheHO(ho));
            if (!status.matches(12)) {
                HOMitStatus result = this.kopiereHORekursiv(hoHierarchie.getWurzel(), destKB, neuerVater, hoHierarchie);
                status.add(result.getStatus());
                neu = result.getHO();
            }
        }
        return new HOMitStatus(neu, (IStatus)status);
    }

    private HOMitStatus kopiereHORekursiv(HierarchieObjekt ho, ConfigurationArea kb, Object vater, HOHierarchie hierarchieObjekt) {
        MultiStatus meldung = ho == hierarchieObjekt.getWurzel() ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere Hierarchieobjekt " + ho, null) : new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Kopiere untergeordnetes Hierarchieobjekt " + ho + " zu " + vater, null);
        HOMitStatus result = this.kopiereHO(ho, kb, vater, null, false, false, false);
        meldung.merge(result.getStatus());
        HierarchieObjekt neu = result.getHO();
        if (neu != null) {
            for (HierarchieObjekt kind : hierarchieObjekt.getUntergeordneteObjekte(ho)) {
                result = this.kopiereHORekursiv(kind, kb, neu, hierarchieObjekt);
                meldung.add(result.getStatus());
            }
        }
        return new HOMitStatus(neu, (IStatus)meldung);
    }

    public MultiStatus loescheHO(HierarchieObjekt ho) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "L\u00f6sche Hierarchieobjekt " + ho, null);
        this.loescheHO(ho, status);
        return status;
    }

    private void loescheHO(HierarchieObjekt ho, MultiStatus status) {
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        Object vater = this.getHierarchie().getUebergeordnetesObjekt(ho);
        if (vater == null) {
            throw new IllegalArgumentException("Kein \u00fcbergeordnetes Objekt f\u00fcr " + ho + " gefunden  in der Hierarchie Netzbeeinflussungsanlagen");
        }
        if (Arrays.asList(EBENE1).contains(hot) && !(vater instanceof ConfigurationArea)) {
            throw new IllegalArgumentException("Als \u00fcbergeordnetes Objekt ist nur ein Konfigurationsbereich zul\u00e4ssig");
        }
        if (!Arrays.asList(this.getUntergeordneteHOTs(vater)).contains(hot)) {
            throw new IllegalArgumentException("Unzul\u00e4ssiges \u00fcbergeordnetes Objekt " + vater + " f\u00fcr Hierarchieobjekt " + ho);
        }
        MultiStatus unterStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "L\u00f6sche Hierarchieobjekt " + ho + " vom Typ " + hot, null);
        if (!hot.isSystemObjektVorhanden()) {
            while (!this.getHierarchie().getUntergeordneteObjekte((Object)ho).isEmpty()) {
                HierarchieObjekt objekt = (HierarchieObjekt)this.getHierarchie().getUntergeordneteObjekte((Object)ho).get(0);
                this.loescheHO(objekt, unterStatus);
                status.add((IStatus)unterStatus);
                if (status.matches(12)) break;
            }
            if (status.matches(12)) {
                return;
            }
            this.loescheHOZuordnung(ho, vater, status);
            if (status.matches(12)) {
                return;
            }
            ConfigurationObject ko = (ConfigurationObject)ho.getSystemObjekt(0);
            try {
                ko.invalidate();
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " gel\u00f6scht."));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " konnte nicht gel\u00f6scht werden.", (Throwable)e));
                this.setzeHOZuordnung(ho, vater, status);
                return;
            }
            catch (RuntimeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Konfigurationsobjekt " + ko.getPid() + " vom Typ " + ko.getType().getName() + " konnte nicht gel\u00f6scht werden.", (Throwable)e));
                return;
            }
            if (hot.equals((Object)HOT_NBA.HauptRoute)) {
                this.aendernHOT(vater, HOT_NBA.HauptRoute, status);
            }
        } else {
            this.loescheHOZuordnung(ho, vater, status);
            if (status.matches(12)) {
                return;
            }
        }
    }

    private void loescheHOZuordnung(HierarchieObjekt ho, Object vater, MultiStatus status) {
        String pid;
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        List mengenListe = hot.getTypInfo(pid = (String)hot.getTypen().get(0)).getMengen();
        if (mengenListe != null && mengenListe.size() == 0) {
            mengenListe = null;
        }
        if (mengenListe == null) {
            this.loescheHOArrayZuordnung(ho, vater, status);
        }
        if (!status.matches(12)) {
            this.getHierarchie().objektEntfernen(vater, ho);
        }
    }

    private void loescheHOArrayZuordnung(Object vater, MultiStatus status) {
        ObjectLookup lookup;
        HierarchieObjekt vaterHo = null;
        if (vater == null || !(vater instanceof HierarchieObjekt)) {
            return;
        }
        vaterHo = (HierarchieObjekt)vater;
        IHierarchieObjektTyp vaterHot = vaterHo.getHierarchieObjektTyp();
        SystemObject vaterSo = vaterHo.getSystemObjekt(0);
        String pidSo = vaterSo.getType().getPid();
        String atgPid = (String)vaterHot.getTypInfo(pidSo).getAtgs().get(0);
        List attNamenListe = vaterHot.getTypInfo(pidSo).getAtgInfo(atgPid).getAttribute();
        AttributeGroup atg = this.getHierarchie().getDataModel().getAttributeGroup(atgPid);
        Data data = ((ConfigConfigurationObject)vaterSo).getConfigurationData(atg, lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)this.getHierarchie().getDataModel()));
        if (data != null) {
            String arrayName = "";
            for (String attName : attNamenListe) {
                if (!data.getItem(attName).isArray()) continue;
                arrayName = attName;
                break;
            }
            if (arrayName.isEmpty()) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Das Array in " + vaterSo.getPid() + " konnte nicht geleert werden, weil der Name des Arrays nicht gefunden wurde."));
                return;
            }
            Data.ReferenceArray ra = data.getReferenceArray(arrayName);
            ra.setLength(0);
            try {
                if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)vaterSo, (AttributeGroup)atg)) {
                    vaterSo = this.behandleSystemObjektAenderung(vaterHo, (ConfigurationObject)vaterSo, vaterSo.getPid());
                    vaterHo.setSystemObjekt(0, vaterSo);
                }
                vaterSo.setConfigurationData(atg, data);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Das Array in " + vaterSo.getPid() + " wurde geleert"));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Das Array in " + vaterSo.getPid() + " konnte nicht geleert werden ", (Throwable)e));
            }
        }
    }

    private void loescheHOArrayZuordnung(HierarchieObjekt ho, Object vater, MultiStatus status) {
        ObjectLookup lookup;
        SystemObject so = ho.getSystemObjekt(0);
        HierarchieObjekt vaterHo = null;
        if (vater == null || !(vater instanceof HierarchieObjekt)) {
            return;
        }
        vaterHo = (HierarchieObjekt)vater;
        IHierarchieObjektTyp vaterHot = vaterHo.getHierarchieObjektTyp();
        SystemObject vaterSo = vaterHo.getSystemObjekt(0);
        String pidSo = vaterSo.getType().getPid();
        String atgPid = (String)vaterHot.getTypInfo(pidSo).getAtgs().get(0);
        AtgInfo atgInfo = vaterHot.getTypInfo(pidSo).getAtgInfo(atgPid);
        List attNamenListe = atgInfo.getAttribute();
        AttributeGroup atg = this.getHierarchie().getDataModel().getAttributeGroup(atgPid);
        Data data = ((ConfigConfigurationObject)vaterSo).getConfigurationData(atg, lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)this.getHierarchie().getDataModel()));
        if (data != null) {
            String arrayName = "";
            for (String attName : attNamenListe) {
                if (!data.getItem(attName).isArray()) continue;
                arrayName = attName;
                break;
            }
            if (arrayName.isEmpty()) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gel\u00f6scht werden, weil der Name des Arrays nicht gefunden wurde."));
                return;
            }
            Data.ReferenceArray ra = data.getReferenceArray(arrayName);
            if (!Arrays.asList(ra.getSystemObjectArray()).contains(so)) {
                status.add((IStatus)new Status(1, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gel\u00f6scht werden, weil dieses nicht vorhanden ist."));
                return;
            }
            ArrayList<SystemObject> delList = new ArrayList<SystemObject>();
            ArrayList<SystemObject> list = new ArrayList<SystemObject>();
            int i = 0;
            while (i < ra.getLength()) {
                SystemObject ref = ra.getReferenceValue(i).getSystemObject();
                list.add(ref);
                if (ref.equals(so)) {
                    delList.add(ref);
                }
                ++i;
            }
            list.removeAll(delList);
            ra.setLength(list.size());
            i = 0;
            while (i < ra.getLength()) {
                ra.getReferenceValue(i).setSystemObject((SystemObject)list.get(i));
                ++i;
            }
            try {
                if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)vaterSo, (AttributeGroup)atg)) {
                    vaterSo = this.behandleSystemObjektAenderung(vaterHo, (ConfigurationObject)vaterSo, vaterSo.getPid());
                    vaterHo.setSystemObjekt(0, vaterSo);
                }
                vaterSo.setConfigurationData(atg, data);
                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " als Referenz in " + vaterSo.getPid() + " gel\u00f6scht"));
            }
            catch (ConfigurationChangeException e) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Systemobjekt " + so.getPid() + " konnte nicht als Referenz in " + vaterSo.getPid() + " gel\u00f6scht werden ", (Throwable)e));
            }
        }
    }

    private void aendernHOT(Object vater, IHierarchieObjektTyp neuerHot, MultiStatus status) {
        HierarchieObjekt vaterHo = null;
        if (!(vater instanceof HierarchieObjekt)) {
            return;
        }
        vaterHo = (HierarchieObjekt)vater;
        IHierarchieObjektTyp vaterHot = vaterHo.getHierarchieObjektTyp();
        SystemObject vaterSo = vaterHo.getSystemObjekt(0);
        String pidSo = vaterSo.getType().getPid();
        String atgPid = (String)vaterHot.getTypInfo(pidSo).getAtgs().get(0);
        List attNamenListe = vaterHot.getTypInfo(pidSo).getAtgInfo(atgPid).getAttribute();
        AttributeGroup atg = this.getHierarchie().getDataModel().getAttributeGroup(atgPid);
        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)this.getHierarchie().getDataModel());
        Data data = ((ConfigConfigurationObject)vaterSo).getConfigurationData(atg, lookup);
        if (data != null) {
            String arrayName = "";
            for (String attName : attNamenListe) {
                if (!data.getItem(attName).isArray()) continue;
                arrayName = attName;
                break;
            }
            if (arrayName.isEmpty()) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "HierarchieObjektTyp der 1.Route in " + vaterSo.getPid() + " konnte nicht ge\u00e4ndert werden, weil der Name des Arrays nicht gefunden wurde."));
                return;
            }
            Data.ReferenceArray ra = data.getReferenceArray(arrayName);
            if (ra.getLength() > 0) {
                SystemObject so = ra.getSystemObject(0);
                List uos = this.getHierarchie().getUntergeordneteObjekte((Object)vaterHo);
                for (HierarchieObjekt ho : uos) {
                    if (!ho.getSystemObjekt(0).equals(so)) continue;
                    ho.setHierarchieObjektTyp(neuerHot);
                    this.hierarchie.notifyHOGeaendert(ho);
                    break;
                }
            }
        }
    }

    public IStatus pruefeDaten(HierarchieObjekt ho, HODaten daten) {
        SystemObjektDaten soDaten;
        IHierarchieObjektTyp hot = ho.getHierarchieObjektTyp();
        IPruefungen pruefInstanz = TkaNbaActivator.getDefault().getDatenSpeicher().getPruefungen();
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Hierarchieobjekt " + ho, null);
        result.merge(pruefInstanz.pruefeHierarchieObjekt(ho, daten));
        Vector<SystemObject> listeEltern = new Vector<SystemObject>();
        Object ueberObj = this.getHierarchie().getUebergeordnetesObjekt(ho);
        if (ueberObj instanceof HierarchieObjekt) {
            HierarchieObjekt ueberHO = (HierarchieObjekt)ueberObj;
            listeEltern.add(ueberHO.getSystemObjekt(0));
        }
        LoeschenChecker loeschenChecker = new LoeschenChecker((IHierarchieManager)this);
        Vector<SystemObject> liste = new Vector<SystemObject>();
        StringBuffer aend = new StringBuffer();
        StringBuffer loesch = new StringBuffer();
        for (SystemObject so : ho.getSystemObjekte()) {
            soDaten = daten.getSystemObjektDaten(so);
            if (so.getPid().equals(soDaten.getPid())) continue;
            liste.add(so);
            if (aend.length() > 0) {
                aend.append(", ");
            }
            aend.append(soDaten.getPid());
            if (loesch.length() > 0) {
                loesch.append(", ");
            }
            loesch.append(so.getPid());
        }
        if (liste.size() > 0) {
            MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Durch PID-\u00c4nderung(en) auf " + aend + " werden folgende Objekte gel\u00f6scht: " + loesch, null);
            Collection<SystemObjectType> typen = this.loeschenOffeneReferenzenVerboten(ho.getHierarchieObjektTyp());
            boolean flag = this.verwendeZuLoeschendeObjekteZurPruefungOffeneReferenzen();
            status.add(loeschenChecker.bestimmeOffeneReferenzen(liste, typen, listeEltern, flag));
            result.add((IStatus)status);
        }
        for (SystemObject so : ho.getSystemObjekte()) {
            soDaten = daten.getSystemObjektDaten(so);
            if (soDaten != null) {
                MultiStatus objektStatus = ho.getSystemObjekte().size() > 1 ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe ATG-Daten f\u00fcr Systemobjekt " + so.getPid() + " vom Typ " + so.getType().getPid(), null) : result;
                TypInfo typInfo = hot.getTypInfo(so.getType().getPid());
                if (typInfo != null) {
                    for (String atgPid : typInfo.getAtgs()) {
                        AtgInfo atgInfo = typInfo.getAtgInfo(atgPid);
                        if (atgInfo != null) {
                            Data data = soDaten.getAtgDaten(atgPid);
                            if (data == null && (atgInfo.isMandatory() || !atgInfo.isOptional())) {
                                objektStatus.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "F\u00fcr die nicht-optionale ATG " + atgPid + " sind keine Daten vorhanden"));
                            }
                            if (data == null) continue;
                            MultiStatus atgStatus = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Daten der ATG " + atgPid, null);
                            atgStatus.merge(pruefInstanz.pruefeDaten(ho, so, atgInfo, data));
                            objektStatus.add((IStatus)atgStatus);
                            continue;
                        }
                        throw new IllegalStateException("AtgInfo f\u00fcr ATG " + atgPid + " fehlt in TypInfo f\u00fcr " + so.getType().getPid() + " im HierarchieObjektTyp " + hot);
                    }
                } else {
                    throw new IllegalStateException("TypInfo fehlt f\u00fcr  " + so.getType().getPid() + " im HierarchieObjektTyp " + hot);
                }
                if (result == objektStatus) continue;
                result.add((IStatus)objektStatus);
                continue;
            }
            throw new IllegalStateException("Daten f\u00fcr Systemobjekt " + so.getPid() + " erforderlich, aber nicht \u00fcbergeben");
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ConfigurationObject dupliziereObjekt(ConfigurationObject ko, String neuePid) throws ConfigurationChangeException {
        block9: {
            sets = new Vector<ObjectSet>();
            neu = null;
            result = null;
            try {
                for (ObjectSet set : ko.getObjectSets()) {
                    setTyp = set.getObjectSetType();
                    if (!HierarchieManagerNBA.$assertionsDisabled && setTyp.getReferenceType() == ReferenceType.COMPOSITION) {
                        throw new AssertionError();
                    }
                    menge = (ObjectSet)ko.getConfigurationArea().createConfigurationObject((ConfigurationObjectType)set.getObjectSetType(), "", set.getName(), null);
                    elemente = set instanceof NonMutableSet != false ? ((NonMutableSet)set).getElementsInModifiableVersion() : set.getElements();
                    menge.add(elemente.toArray(new SystemObject[elemente.size()]));
                    sets.add(menge);
                }
                kbPid = neuePid;
                if (kbPid == null) {
                    kbPid = ko.getPid();
                }
                neu = ko.getConfigurationArea().createConfigurationObject((ConfigurationObjectType)ko.getType(), kbPid, ko.getName(), sets);
                lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)((ConfigDataModel)ko.getDataModel()));
                for (AttributeGroupUsage atgu : ko.getUsedAttributeGroupUsages()) {
                    dataSrc = ((ConfigSystemObject)ko).getConfigurationData(atgu, lookup);
                    if (dataSrc == null) continue;
                    dataDest = DataFactory.createModifiableCopy((Data)dataSrc, (ObjectLookup)lookup);
                    neu.setConfigurationData(atgu, dataDest);
                }
                result = neu;
            }
            finally {
                if (result != null) break block9;
                ** for (set : sets)
            }
lbl-1000:
            // 1 sources

            {
                set.invalidate();
                continue;
            }
lbl33:
            // 1 sources

            if (neu != null) {
                neu.invalidate();
            }
        }
        return result;
    }

    private ConfigurationObject behandleSystemObjektAenderung(HierarchieObjekt ho, ConfigurationObject ko, String neuePid) throws ConfigurationChangeException {
        ConfigurationObject result = this.dupliziereObjekt(ko, neuePid);
        Object vater = this.hierarchie.getUebergeordnetesObjekt(ho);
        if (vater instanceof HierarchieObjekt && !ko.getPid().equals(result.getPid())) {
            Data data;
            HierarchieObjekt vaterHo = (HierarchieObjekt)vater;
            IHierarchieObjektTyp hot = vaterHo.getHierarchieObjektTyp();
            SystemObject vaterSo = vaterHo.getSystemObjekt(0);
            ConfigDataModel dataModel = this.hierarchie.getDataModel();
            ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
            AttributeGroup atg = null;
            Data neu = null;
            Data.ReferenceArray refArray = null;
            if (hot.equals((Object)HOT_NBA.Masche)) {
                atg = dataModel.getAttributeGroup("atg.routen");
                data = ((ConfigSystemObject)vaterSo).getConfigurationData(atg, lookup);
                neu = DataFactory.createModifiableCopy((Data)data, (ObjectLookup)lookup);
                refArray = neu.getReferenceArray("Route");
            } else {
                atg = dataModel.getAttributeGroup("atg.bestehtAusLinienObjekten");
                data = ((ConfigSystemObject)vaterSo).getConfigurationData(atg, lookup);
                neu = DataFactory.createModifiableCopy((Data)data, (ObjectLookup)lookup);
                refArray = neu.getReferenceArray("LinienReferenz");
            }
            int i = 0;
            while (i < refArray.getLength()) {
                SystemObject ref = refArray.getReferenceValue(i).getSystemObject();
                if (ref != null && ref.equals(ko)) {
                    refArray.getReferenceValue(i).setSystemObject((SystemObject)result);
                }
                ++i;
            }
            if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)vaterSo, (AttributeGroup)atg)) {
                vaterSo = this.behandleSystemObjektAenderung(vaterHo, (ConfigurationObject)vaterSo, vaterSo.getPid());
                vaterHo.setSystemObjekt(0, vaterSo);
            }
            vaterSo.setConfigurationData(atg, neu);
        }
        ko.invalidate();
        return result;
    }

    public MultiStatus uebernehmeDaten(HierarchieObjekt ho, HODaten daten) {
        MultiStatus status = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "\u00dcbernehme bearbeitete Daten f\u00fcr Hierarchieobjekt " + ho, null);
        List objektListe = daten.getSystemObjekte();
        int i = 0;
        while (i < objektListe.size()) {
            SystemObject so = (SystemObject)objektListe.get(i);
            if (ho.getSystemObjekte().contains(so)) {
                SystemObjektDaten soDaten = daten.getSystemObjektDaten(so);
                if (!so.getPid().equals(soDaten.getPid())) {
                    try {
                        so = this.behandleSystemObjektAenderung(ho, (ConfigurationObject)so, soDaten.getPid());
                        ho.setSystemObjekt(i, so);
                        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " erzeugt"));
                    }
                    catch (ConfigurationChangeException e) {
                        status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim behandeln der PID-\u00c4nderung auf " + soDaten.getPid() + " f\u00fcr Objekt " + so.getPid(), (Throwable)e));
                    }
                }
                if (so.getName() == null || !so.getName().equals(soDaten.getName())) {
                    try {
                        so.setName(soDaten.getName());
                        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + soDaten.getName() + "\" \u00fcbernommen"));
                    }
                    catch (ConfigurationChangeException e) {
                        status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Name \"" + soDaten.getName() + "\" konnte nicht \u00fcbernommen werden", (Throwable)e));
                    }
                }
                List atgList = ho.getHierarchieObjektTyp().getTypInfo(so.getType().getPid()).getAtgs();
                for (String atgPid : atgList) {
                    AttributeGroup atg = this.hierarchie.getDataModel().getAttributeGroup(atgPid);
                    if (atg != null) {
                        ConfigDataModel dataModel = this.hierarchie.getDataModel();
                        ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
                        Data ist = ((ConfigSystemObject)so).getConfigurationData(atg, lookup);
                        Data soll = soDaten.getAtgDaten(atgPid);
                        if (soll != null) {
                            if (ist != null && !soDaten.isDatenGeaendert(atgPid)) continue;
                            if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)so, (AttributeGroup)atg)) {
                                try {
                                    so = this.behandleSystemObjektAenderung(ho, (ConfigurationObject)so, so.getPid());
                                    ho.setSystemObjekt(i, so);
                                    status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingt Erzeugung neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid()));
                                }
                                catch (ConfigurationChangeException e) {
                                    status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Bei der durch ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingten Erzeugung neues Objekts mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " ist ein Fehler aufgetreten", (Throwable)e));
                                    continue;
                                }
                            }
                            try {
                                so.setConfigurationData(atg, soll);
                                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurierende Daten der ATG " + atgPid + " \u00fcbernommen"));
                            }
                            catch (ConfigurationChangeException e) {
                                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim \u00dcbernehmen konfigurierender Daten der ATG " + atgPid, (Throwable)e));
                            }
                            continue;
                        }
                        if (ist == null) continue;
                        if (!HierarchieObjekt.isAttributgruppeAenderbar((SystemObject)so, (AttributeGroup)atg)) {
                            try {
                                so = this.behandleSystemObjektAenderung(ho, (ConfigurationObject)so, so.getPid());
                                ho.setSystemObjekt(i, so);
                                status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingt Erzeugung neues Objekt mit PID " + so.getPid() + " vom Typ " + so.getType().getPid()));
                            }
                            catch (ConfigurationChangeException e) {
                                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Bei der durch ATG-Verwendung " + AttributeGroupUsage.Usage.OptionalConfigurationData + " bedingten Erzeugung neues Objekts mit PID " + so.getPid() + " vom Typ " + so.getType().getPid() + " ist ein Fehler aufgetreten", (Throwable)e));
                                continue;
                            }
                        }
                        try {
                            so.setConfigurationData(atg, null);
                            status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Konfigurierende Daten der ATG " + atgPid + " gel\u00f6scht"));
                        }
                        catch (ConfigurationChangeException e) {
                            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Fehler beim L\u00f6schen konfigurierender Daten der ATG " + atgPid, (Throwable)e));
                        }
                        continue;
                    }
                    LOGGER.warning("Bearbeitung Objekt " + so.getPid() + ": Keine Attributgruppe im Datenmodell gefunden f\u00fcr " + atgPid);
                }
            }
            ++i;
        }
        return status;
    }

    public boolean pruefeNeuanlageVerboten(Object objekt, IHierarchieObjektTyp hot) {
        if (Arrays.asList(EBENE2).contains(hot)) {
            if (this.getHierarchie().getUntergeordneteObjekte(objekt).size() == 0) {
                return !Arrays.asList(EBENE20).contains(hot);
            }
            return !Arrays.asList(EBENE21).contains(hot);
        }
        return false;
    }

    public Collection<SystemObjectType> loeschenOffeneReferenzenVerboten(IHierarchieObjektTyp hot) {
        return null;
    }

    public boolean verwendeZuLoeschendeObjekteZurPruefungOffeneReferenzen() {
        return false;
    }

    public boolean kopierenNichtErlaubt(HierarchieObjekt ho) {
        return false;
    }
}

