/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.tkanba;

import de.bsvrz.buv.plugin.tkabasis.LookupFactory;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.AtgInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HODaten;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.HierarchieObjekt;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IAttributInfo;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.IHierarchie;
import de.bsvrz.buv.plugin.tkabasis.hierarchie.SystemObjektDaten;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.IPruefungen;
import de.bsvrz.buv.plugin.tkabasis.pruefungen.PruefungenTools;
import de.bsvrz.buv.plugin.tkanba.RoutenStueck;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ObjectLookup;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import de.bsvrz.puk.config.configFile.datamodel.ConfigSystemObject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class PruefungenNBA
implements IPruefungen {
    private IHierarchie hierarchie;

    public IHierarchie getHierarchie() {
        return this.hierarchie;
    }

    public void setHierarchie(IHierarchie hierarchie) {
        this.hierarchie = hierarchie;
    }

    public IStatus pruefeHierarchieObjekt(HierarchieObjekt ho, HODaten daten) {
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Hierarchieobjekt " + ho, null);
        for (SystemObject so : ho.getSystemObjekte()) {
            SystemObjektDaten soDaten = daten.getSystemObjektDaten(so);
            if (soDaten == null) continue;
            MultiStatus objektStatus = ho.getSystemObjekte().size() > 1 ? new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Systemobjekt " + so.getPid() + " vom Typ " + so.getType().getPid(), null) : result;
            objektStatus.add(new PruefungenTools(this.getHierarchie().getDataModel()).pruefePid(soDaten.getPid(), so));
        }
        return result;
    }

    public IStatus pruefeDaten(HierarchieObjekt ho, SystemObject so, AtgInfo atgInfo, Data daten) {
        MultiStatus result = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Daten der ATG " + atgInfo.getAtg(), null);
        this.pruefeDatenDefinition(atgInfo, daten, result);
        if (so.isOfType("typ.masche")) {
            Data item;
            if ("atg.routen".equals(atgInfo.getAtg()) && (item = daten.getItem("Route")).isArray()) {
                SystemObject[] routen;
                if (item.asArray().getLength() >= 0 && item.asArray().getLength() < 2) {
                    result.add((IStatus)new Status(2, "de.bsvrz.buv.plugin.tkabasis", so.getType() + " muss genau 2 Routen enthalten"));
                } else if (item.asArray().getLength() > 0 && this.hatGleicheObjekte(routen = item.asReferenceArray().getSystemObjectArray())) {
                    result.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Alle " + item.getName() + "n von " + atgInfo.getAtg() + " m\u00fcssen verschieden sein"));
                }
            }
        } else if (so.isOfType("typ.route")) {
            this.pruefeLinienReferenz(so, atgInfo, daten, "typ.routenSt\u00fcck", result);
        } else if (so.isOfType("typ.routenSt\u00fcck")) {
            this.pruefeLinienReferenz(so, atgInfo, daten, "typ.\u00e4u\u00dferesStra\u00dfenSegment", result);
        }
        return result;
    }

    private RoutenStueck pruefeLinienReferenz(SystemObject so, AtgInfo atgInfo, Data daten, String subTyp, MultiStatus result) {
        Data item;
        if ("atg.bestehtAusLinienObjekten".equals(atgInfo.getAtg()) && daten != null && (item = daten.getItem("LinienReferenz")).isArray() && item.asArray().getLength() > 0) {
            SystemObject[] linien = item.asReferenceArray().getSystemObjectArray();
            if (this.hatGleicheObjekte(linien)) {
                result.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Alle " + item.getName() + "en von " + atgInfo.getAtg() + " m\u00fcssen verschieden sein"));
            }
            String richtung = null;
            SystemObject startKnoten = null;
            SystemObject knoten = null;
            ConfigDataModel dataModel = this.getHierarchie().getDataModel();
            ObjectLookup lookup = LookupFactory.createLookupForModifiableVersion((ConfigDataModel)dataModel);
            int i = 0;
            while (i < linien.length) {
                RoutenStueck rs;
                Data coDaten;
                AttributeGroup atg;
                if (!linien[i].isOfType(subTyp)) {
                    result.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", String.valueOf(linien[i].getNameOrPidOrId()) + " muss vom Typ " + subTyp + " sein"));
                    break;
                }
                String tmcRichtung = null;
                SystemObject vonKnoten = null;
                SystemObject nachKnoten = null;
                if (linien[i].isOfType("typ.\u00e4u\u00dferesStra\u00dfenSegment")) {
                    atg = dataModel.getAttributeGroup("atg.\u00e4u\u00dferesStra\u00dfenSegment");
                    coDaten = ((ConfigSystemObject)linien[i]).getConfigurationData(atg, lookup);
                    if (coDaten != null) {
                        tmcRichtung = coDaten.getItem("TmcRichtung").asTextValue().getValueText();
                        vonKnoten = coDaten.getItem("vonKnoten").asReferenceValue().getSystemObject();
                        nachKnoten = coDaten.getItem("nachKnoten").asReferenceValue().getSystemObject();
                    }
                } else if (linien[i].isOfType("typ.routenSt\u00fcck") && (rs = this.pruefeLinienReferenz(linien[i], atgInfo, coDaten = ((ConfigSystemObject)linien[i]).getConfigurationData(atg = dataModel.getAttributeGroup("atg.bestehtAusLinienObjekten"), lookup), "typ.\u00e4u\u00dferesStra\u00dfenSegment", result)) != null) {
                    tmcRichtung = rs.getTmcRichtung();
                    vonKnoten = rs.getVonKnoten();
                    nachKnoten = rs.getNachKnoten();
                }
                if (richtung == null && tmcRichtung != null) {
                    richtung = tmcRichtung;
                } else if (richtung != null && !richtung.equals(tmcRichtung)) {
                    result.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "LinienReferenzen zu " + so.getPid() + " liegen nicht in einer Fahrtrichtung: " + linien[i].getPidOrNameOrId() + " hat andere Fahrtrichtung"));
                    richtung = null;
                    break;
                }
                if (startKnoten == null) {
                    startKnoten = vonKnoten;
                }
                if (nachKnoten != null && (knoten == null || knoten == vonKnoten)) {
                    knoten = nachKnoten;
                } else if (knoten != vonKnoten && i > 0) {
                    result.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "LinienReferenzen zu " + so.getPid() + " liegen nicht hintereinander: " + linien[i].getPidOrNameOrId() + " folgt nicht auf " + linien[i - 1].getPidOrNameOrId()));
                    knoten = null;
                    break;
                }
                ++i;
            }
            return new RoutenStueck(startKnoten, knoten, richtung);
        }
        return null;
    }

    private boolean hatGleicheObjekte(SystemObject[] objekte) {
        int i = 0;
        while (i < objekte.length - 1) {
            int j = i + 1;
            while (j < objekte.length) {
                if (objekte[i] == objekte[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean pruefeDatenDefinition(IAttributInfo attInfo, Data daten, MultiStatus status) {
        Data item = daten.getItem(attInfo.getName());
        if (!item.isDefined()) {
            status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Wert ist nicht korrekt definiert"));
            return false;
        }
        status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Pr\u00fcfen Daten-Definition: OK"));
        if (item.isPlain() && attInfo.isPflichtFeld()) {
            String wert = item.asTextValue().getText();
            if ("".equals(wert) || !(item.getAttributeType() instanceof StringAttributeType) && "undefiniert".equals(wert) || "_Undefiniert_".equals(wert)) {
                status.add((IStatus)new Status(4, "de.bsvrz.buv.plugin.tkabasis", "Wert f\u00fcr Pflichtfeld nicht angegeben"));
                return false;
            }
            status.add((IStatus)new Status(0, "de.bsvrz.buv.plugin.tkabasis", "Pr\u00fcfen Pflichtfeld-Eigenschaft: OK"));
        }
        return true;
    }

    private void pruefeDatenDefinition(AtgInfo atgInfo, Data daten, MultiStatus status) {
        for (String attribut : atgInfo.getAttribute()) {
            MultiStatus meldung = new MultiStatus("de.bsvrz.buv.plugin.tkabasis", 0, "Pr\u00fcfe Wert f\u00fcr Attribut " + attribut, null);
            IAttributInfo attInfo = atgInfo.getAttributInfo(attribut);
            this.pruefeDatenDefinition(attInfo, daten, meldung);
            status.add((IStatus)meldung);
        }
    }
}

